/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.frostclick;

import com.frostwire.search.PagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.frostclick.UserAgent;
import com.frostwire.util.Logger;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FrostClickSearchPerformer
extends PagedWebSearchPerformer {
    private static final Logger LOG = Logger.getLogger(FrostClickSearchPerformer.class);
    private static final int MAX_RESULTS = 1;
    private final Map<String, String> customHeaders;

    public FrostClickSearchPerformer(String domainName, long token, String keywords, int timeout, UserAgent userAgent) {
        super(domainName, token, keywords, timeout, 1);
        this.customHeaders = this.buildCustomHeaders(userAgent);
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return "http://api.frostclick.com/q?page=" + page + "&q=" + encodedKeywords;
    }

    @Override
    protected List<? extends SearchResult> searchPage(int page) {
        String url = this.getUrl(page, this.getEncodedKeywords());
        String text = null;
        try {
            text = this.fetch(url, null, this.customHeaders);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (text != null) {
            return this.searchPage(text);
        }
        LOG.warn("Page content empty for url: " + url);
        return Collections.emptyList();
    }

    @Override
    protected List<? extends SearchResult> searchPage(String page) {
        return Collections.emptyList();
    }

    private Map<String, String> buildCustomHeaders(UserAgent userAgent) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(userAgent.getHeadersMap());
        map.put("User-Agent", userAgent.toString());
        map.put("sessionId", userAgent.getUUID());
        return map;
    }
}

