/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search.eztv;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchMatcher;
import com.frostwire.search.eztv.EztvSearchResult;
import com.frostwire.search.eztv.EztvTempSearchResult;
import com.frostwire.search.torrent.TorrentRegexSearchPerformer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class EztvSearchPerformer
extends TorrentRegexSearchPerformer<EztvSearchResult> {
    private static final int MAX_RESULTS = 20;
    public static final String SEARCH_RESULTS_REGEX = "(?is)<a href=\"(/ep/.*?)\"";
    public static final String TORRENT_DETAILS_PAGE_REGEX = "(?is)<td class=\"section_post_header\" colspan=\"2\"><h1><span style.*?>(?<displaynamefallback>.*?)</span></h1></td>.*?Download Links.*?.*<a href=\"(?<magneturl>magnet:\\?.*?)\" class=\"magnet\".*?.*<a href=\"(?<torrenturl>http(s)?.*?\\.torrent)\" class=\"download_.\".*?Seeds: <span.*?>(?<seeds>.*?)</span><br.*?(Torrent Info.*?title=\"(?<displayname>.*?)\".*?)?(<b>Torrent File:</b>\\s+(?<displayname2>.*?)<br.*?)?(<b>Torrent Hash:</b>\\s+(?<infohash>.*?)<br.*?)?<b>Filesize:</b>\\s+(?<filesize>.*?)<br.*?<b>Released:</b>\\s+(?<creationtime>.*?)<br";

    public EztvSearchPerformer(String domainName, long token, String keywords, int timeout) {
        super(domainName, token, keywords, timeout, 1, 40, 20, SEARCH_RESULTS_REGEX, TORRENT_DETAILS_PAGE_REGEX);
    }

    @Override
    public CrawlableSearchResult fromMatcher(SearchMatcher matcher) {
        String itemId = matcher.group(1);
        return new EztvTempSearchResult(this.getDomainName(), itemId);
    }

    @Override
    protected String fetchSearchPage(String url) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("SearchString1", this.getEncodedKeywords());
        formData.put("SearchString", "");
        formData.put("search", "Search");
        String page = this.post(url, formData);
        return page != null && this.isValidHtml(page) ? page : null;
    }

    @Override
    protected String getUrl(int page, String encodedKeywords) {
        return "https://" + this.getDomainName() + "/search/" + encodedKeywords;
    }

    @Override
    protected EztvSearchResult fromHtmlMatcher(CrawlableSearchResult sr, SearchMatcher matcher) {
        return new EztvSearchResult(sr.getDetailsUrl(), matcher);
    }

    @Override
    protected int htmlPrefixOffset(String html) {
        int offset = html.indexOf("id=\"searchsearch_submit\"");
        return offset > 0 ? offset : 0;
    }

    @Override
    protected boolean isValidHtml(String html) {
        int count;
        if (html == null || html.contains("Cloudflare")) {
            return false;
        }
        String[] keywords = this.getKeywords().split(" ");
        String k = null;
        for (int i = 0; k == null && i < keywords.length; ++i) {
            String s = keywords[i];
            if (s.length() < 3) continue;
            k = s;
        }
        if (k == null) {
            k = keywords[0];
        }
        return (count = StringUtils.countMatches((CharSequence)html.toLowerCase(Locale.US), k.toLowerCase(Locale.US))) > 9;
    }
}

