/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.SearchError;
import com.frostwire.search.SearchListener;
import com.frostwire.search.SearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.filter.SearchTable;
import com.frostwire.util.Logger;
import com.frostwire.util.Ref;
import com.frostwire.util.ThreadPool;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;

public final class SearchManager {
    private static final Logger LOG = Logger.getLogger(SearchManager.class);
    private final ExecutorService executor;
    private final List<SearchTask> tasks;
    private final List<WeakReference<SearchTable>> tables;
    private SearchListener listener;

    private SearchManager(int nThreads) {
        this.executor = new ThreadPool("SearchManager", nThreads, nThreads, 1L, new PriorityBlockingQueue<Runnable>(), true);
        this.tasks = Collections.synchronizedList(new LinkedList());
        this.tables = Collections.synchronizedList(new LinkedList());
    }

    public static SearchManager getInstance() {
        return Loader.INSTANCE;
    }

    public void perform(final SearchPerformer performer) {
        if (performer != null) {
            if (performer.getToken() < 0L) {
                throw new IllegalArgumentException("Search token id must be >= 0");
            }
            performer.setListener(new SearchListener(){

                @Override
                public void onResults(long token, List<? extends SearchResult> results) {
                    if (performer.getToken() == token) {
                        SearchManager.this.onResults(performer, (List<? extends SearchResult>)results);
                    } else {
                        LOG.warn("Performer token does not match listener onResults token, review your logic");
                    }
                }

                @Override
                public void onError(long token, SearchError error) {
                    SearchManager.this.onError(token, error);
                }

                @Override
                public void onStopped(long token) {
                }
            });
            PerformTask task = new PerformTask(this, performer, this.nextOrdinal(performer.getToken()));
            this.submit(task);
        } else {
            LOG.warn("Search performer is null, review your logic");
        }
    }

    public void stop() {
        this.stopTasks(-1L);
    }

    public void stop(long token) {
        this.stopTasks(token);
    }

    public SearchListener getListener() {
        return this.listener;
    }

    public void setListener(SearchListener listener) {
        this.listener = listener;
    }

    private void submit(SearchTask task) {
        this.tasks.add(task);
        this.executor.execute(task);
    }

    private void onResults(SearchPerformer performer, List<? extends SearchResult> results) {
        LinkedList<SearchResult> list = new LinkedList<SearchResult>();
        for (SearchResult searchResult : results) {
            if (searchResult instanceof CrawlableSearchResult) {
                CrawlableSearchResult csr = (CrawlableSearchResult)searchResult;
                if (csr.isComplete()) {
                    list.add(searchResult);
                }
                this.crawl(performer, csr);
                continue;
            }
            list.add(searchResult);
        }
        if (!list.isEmpty()) {
            this.onResults(performer.getToken(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResults(long token, List<? extends SearchResult> results) {
        try {
            if (results != null && this.listener != null) {
                this.listener.onResults(token, results);
            }
            List<WeakReference<SearchTable>> list = this.tables;
            synchronized (list) {
                Iterator<WeakReference<SearchTable>> it = this.tables.iterator();
                while (it.hasNext()) {
                    WeakReference<SearchTable> t = it.next();
                    if (Ref.alive(t)) {
                        ((SearchTable)t.get()).add(results);
                        continue;
                    }
                    it.remove();
                }
            }
        }
        catch (Throwable e) {
            LOG.warn("Error sending results to listener: " + e.getMessage(), e);
        }
    }

    private void onError(long token, SearchError error) {
        try {
            if (error != null && this.listener != null) {
                this.listener.onError(token, error);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error sending search error to listener: " + e.getMessage(), e);
        }
    }

    private void onStopped(long token) {
        try {
            if (this.listener != null) {
                this.listener.onStopped(token);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error sending stopped signal to listener: " + e.getMessage(), e);
        }
    }

    private void crawl(SearchPerformer performer, CrawlableSearchResult sr) {
        if (performer != null && !performer.isStopped()) {
            try {
                CrawlTask task = new CrawlTask(this, performer, sr, this.nextOrdinal(performer.getToken()));
                this.submit(task);
            }
            catch (Throwable e) {
                LOG.warn("Error scheduling crawling of search result: " + sr);
            }
        } else {
            LOG.warn("Search performer is null or stopped, review your logic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTasks(long token) {
        List<SearchTask> list = this.tasks;
        synchronized (list) {
            for (SearchTask task : this.tasks) {
                if (token != -1L && task.token() != token) continue;
                task.stopSearch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfFinished(long token) {
        SearchTask pendingTask = null;
        List<SearchTask> list = this.tasks;
        synchronized (list) {
            Iterator<SearchTask> it = this.tasks.iterator();
            while (it.hasNext() && pendingTask == null) {
                SearchTask task = it.next();
                if (task.token() == token && !task.stopped()) {
                    pendingTask = task;
                }
                if (!task.stopped()) continue;
                it.remove();
            }
        }
        if (pendingTask == null) {
            this.onStopped(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int nextOrdinal(long token) {
        int ordinal = 0;
        List<SearchTask> list = this.tasks;
        synchronized (list) {
            for (SearchTask task : this.tasks) {
                if (task.token() != token) continue;
                ++ordinal;
            }
        }
        return ordinal;
    }

    private static final class CrawlTask
    extends SearchTask {
        private final CrawlableSearchResult sr;

        CrawlTask(SearchManager manager, SearchPerformer performer, CrawlableSearchResult sr, int order) {
            super(manager, performer, order);
            this.sr = sr;
        }

        @Override
        public void run() {
            try {
                if (!this.stopped()) {
                    this.performer.crawl(this.sr);
                }
            }
            catch (Throwable e) {
                LOG.warn("Error performing crawling of: " + this.sr + ", e=" + e.getMessage());
            }
            finally {
                if (this.manager.tasks.remove(this)) {
                    this.manager.checkIfFinished(this.performer.getToken());
                }
            }
        }
    }

    private static final class PerformTask
    extends SearchTask {
        PerformTask(SearchManager manager, SearchPerformer performer, int order) {
            super(manager, performer, order);
        }

        @Override
        public void run() {
            try {
                if (!this.stopped()) {
                    this.performer.perform();
                }
            }
            catch (Throwable e) {
                LOG.warn("Error performing search: " + this.performer + ", e=" + e.getMessage());
            }
            finally {
                if (this.manager.tasks.remove(this)) {
                    this.manager.checkIfFinished(this.performer.getToken());
                }
            }
        }
    }

    private static abstract class SearchTask
    extends Thread
    implements Comparable<SearchTask> {
        protected final SearchManager manager;
        protected final SearchPerformer performer;
        private final int ordinal;

        SearchTask(SearchManager manager, SearchPerformer performer, int ordinal) {
            this.manager = manager;
            this.performer = performer;
            this.ordinal = ordinal;
            this.setName(performer.getClass().getName() + "-SearchTask");
        }

        public long token() {
            return this.performer.getToken();
        }

        public boolean stopped() {
            return this.performer.isStopped();
        }

        void stopSearch() {
            this.performer.stop();
        }

        @Override
        public int compareTo(SearchTask o) {
            int x = this.ordinal;
            int y = o.ordinal;
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }

    private static class Loader {
        static final SearchManager INSTANCE = new SearchManager(6);

        private Loader() {
        }
    }
}

