/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.search;

import com.frostwire.search.CrawlCache;
import com.frostwire.search.CrawlableSearchResult;
import com.frostwire.search.MagnetDownloader;
import com.frostwire.search.PagedWebSearchPerformer;
import com.frostwire.search.SearchResult;
import com.frostwire.search.torrent.TorrentSearchResult;
import com.frostwire.util.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class CrawlPagedWebSearchPerformer<T extends CrawlableSearchResult>
extends PagedWebSearchPerformer {
    private static final Logger LOG = Logger.getLogger(CrawlPagedWebSearchPerformer.class);
    private static final int DEFAULT_CRAWL_TIMEOUT = 10000;
    private static final int FAILED_CRAWL_URL_CACHE_LIFETIME = 600000;
    private static final int DEFAULT_MAGNET_DOWNLOAD_TIMEOUT_SECS = 20;
    private static CrawlCache cache = null;
    private static MagnetDownloader magnetDownloader = null;
    private int numCrawls;
    protected static final Map<String, Integer> UNIT_TO_BYTES = new HashMap<String, Integer>();

    public CrawlPagedWebSearchPerformer(String domainName, long token, String keywords, int timeout, int pages, int numCrawls) {
        super(domainName, token, keywords, timeout, pages);
        this.numCrawls = numCrawls;
    }

    public static void setCache(CrawlCache cache) {
        CrawlPagedWebSearchPerformer.cache = cache;
    }

    public static MagnetDownloader getMagnetDownloader() {
        return magnetDownloader;
    }

    public static void setMagnetDownloader(MagnetDownloader magnetDownloader) {
        CrawlPagedWebSearchPerformer.magnetDownloader = magnetDownloader;
    }

    @Override
    public void crawl(CrawlableSearchResult sr) {
        block19: {
            if (this.numCrawls > 0) {
                --this.numCrawls;
                T obj = this.cast(sr);
                if (obj != null) {
                    String url = this.getCrawlUrl(obj);
                    if (url != null) {
                        String infohash;
                        byte[] failed = this.cacheGet("failed:" + url);
                        if (failed != null) {
                            long failedWhen = CrawlPagedWebSearchPerformer.array2long(failed);
                            if (System.currentTimeMillis() - failedWhen < 600000L) {
                                this.onResults(Collections.emptyList());
                                return;
                            }
                            this.cacheRemove("failed:" + url);
                        }
                        byte[] data = this.cacheGet(url);
                        if (sr instanceof TorrentSearchResult) {
                            infohash = ((TorrentSearchResult)((Object)sr)).getHash();
                            if (data == null) {
                                data = this.cacheGet(infohash);
                            } else {
                                this.cachePut(infohash, data);
                            }
                        }
                        if (data == null) {
                            data = url.startsWith("magnet") ? this.fetchMagnet(url) : this.fetchBytes(url, sr.getDetailsUrl(), 10000);
                            if (data != null) {
                                this.cachePut(url, data);
                                if (sr instanceof TorrentSearchResult) {
                                    infohash = ((TorrentSearchResult)((Object)sr)).getHash();
                                    this.cachePut(infohash, data);
                                }
                            } else {
                                this.cachePut("failed:" + url, CrawlPagedWebSearchPerformer.long2array(System.currentTimeMillis()));
                            }
                        }
                        try {
                            List<SearchResult> results;
                            if (data == null || (results = this.crawlResult(obj, data)) == null) break block19;
                            if (!results.isEmpty()) {
                                this.onResults(results);
                                break block19;
                            }
                            this.cachePut("failed:" + url, CrawlPagedWebSearchPerformer.long2array(System.currentTimeMillis()));
                        }
                        catch (Throwable e) {
                            LOG.warn("Error creating crawled results from downloaded data: url=" + url + ", e=" + e.getMessage());
                            this.cacheRemove(url);
                        }
                    } else {
                        try {
                            List<SearchResult> results = this.crawlResult(obj, null);
                            if (results != null) {
                                this.onResults(results);
                            }
                        }
                        catch (Throwable e) {
                            LOG.warn("Error creating crawled results from search result alone: " + obj.getDetailsUrl() + ", e=" + e.getMessage());
                        }
                    }
                }
            }
        }
    }

    protected abstract String getCrawlUrl(T var1);

    protected abstract List<? extends SearchResult> crawlResult(T var1, byte[] var2) throws Exception;

    private byte[] fetchMagnet(String magnet) {
        if (magnetDownloader != null) {
            return magnetDownloader.download(magnet, 20);
        }
        LOG.warn("Magnet downloader not set, download not supported: " + magnet);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] cacheGet(String key) {
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                return cache.get(key);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cachePut(String key, byte[] data) {
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                cache.put(key, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheRemove(String key) {
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                cache.remove(key);
            }
        }
    }

    private T cast(CrawlableSearchResult sr) {
        try {
            return (T)sr;
        }
        catch (ClassCastException e) {
            LOG.warn("Something wrong with the logic, need to pass a crawlable search result with the correct type");
            return null;
        }
    }

    private static byte[] long2array(long l) {
        byte[] arr = new byte[8];
        CrawlPagedWebSearchPerformer.longToByteArray(l, 0, arr, 0, arr.length);
        return arr;
    }

    private static long array2long(byte[] arr) {
        return CrawlPagedWebSearchPerformer.byteArrayToLong(arr, 0, 0L, 0, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                cache.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCacheNumEntries() {
        long result = 0L;
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                result = cache.numEntries();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getCacheSize() {
        long result = 0L;
        if (cache != null) {
            CrawlCache crawlCache = cache;
            synchronized (crawlCache) {
                result = cache.sizeInBytes();
            }
        }
        return result;
    }

    private static long byteArrayToLong(byte[] src, int srcPos, long dstInit, int dstPos, int nBytes) {
        if (src.length == 0 && srcPos == 0 || 0 == nBytes) {
            return dstInit;
        }
        if ((nBytes - 1) * 8 + dstPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+dstPos is greater or equal to than 64");
        }
        long out = dstInit;
        for (int i = 0; i < nBytes; ++i) {
            int shift = i * 8 + dstPos;
            long bits = (0xFFL & (long)src[i + srcPos]) << shift;
            long mask = 255L << shift;
            out = out & (mask ^ 0xFFFFFFFFFFFFFFFFL) | bits;
        }
        return out;
    }

    private static byte[] longToByteArray(long src, int srcPos, byte[] dst, int dstPos, int nBytes) {
        if (0 == nBytes) {
            return dst;
        }
        if ((nBytes - 1) * 8 + srcPos >= 64) {
            throw new IllegalArgumentException("(nBytes-1)*8+srcPos is greater or equal to than 64");
        }
        for (int i = 0; i < nBytes; ++i) {
            int shift = i * 8 + srcPos;
            dst[dstPos + i] = (byte)(0xFFL & src >> shift);
        }
        return dst;
    }

    static {
        UNIT_TO_BYTES.put("bytes", 1);
        UNIT_TO_BYTES.put("B", 1);
        UNIT_TO_BYTES.put("KB", 1024);
        UNIT_TO_BYTES.put("MB", 0x100000);
        UNIT_TO_BYTES.put("GB", 0x40000000);
    }
}

