/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ISO639 {
    private static Map<String, String> ISO_639_2_to_ISO_639_1 = new HashMap<String, String>();
    private static Map<String, String> ISO_639_1_to_ISO_639_2 = new HashMap<String, String>();

    private static void addCode(String iso3, String iso2) {
        ISO_639_2_to_ISO_639_1.put(iso3, iso2);
        ISO_639_1_to_ISO_639_2.put(iso2, iso3);
    }

    private static String getCode(String iso3) {
        return ISO_639_2_to_ISO_639_1.get(iso3);
    }

    public static Locale getLocaleFromISO639_2(String iso3) {
        if (iso3 == null) {
            return null;
        }
        String iso2 = ISO639.getCode(iso3);
        if (iso2 == null) {
            return null;
        }
        return new Locale(iso2);
    }

    public static String getISO639_2FromLocale(Locale locale) {
        if (locale == null) {
            return null;
        }
        String iso1 = ISO_639_1_to_ISO_639_2.get(locale.getLanguage());
        return iso1;
    }

    static {
        ISO639.addCode("\u00ef\u00bb\u00bfaar", "aa");
        ISO639.addCode("abk", "ab");
        ISO639.addCode("afr", "af");
        ISO639.addCode("aka", "ak");
        ISO639.addCode("alb", "sq");
        ISO639.addCode("amh", "am");
        ISO639.addCode("ara", "ar");
        ISO639.addCode("arg", "an");
        ISO639.addCode("arm", "hy");
        ISO639.addCode("asm", "as");
        ISO639.addCode("ava", "av");
        ISO639.addCode("ave", "ae");
        ISO639.addCode("aym", "ay");
        ISO639.addCode("aze", "az");
        ISO639.addCode("bak", "ba");
        ISO639.addCode("bam", "bm");
        ISO639.addCode("baq", "eu");
        ISO639.addCode("bel", "be");
        ISO639.addCode("ben", "bn");
        ISO639.addCode("bih", "bh");
        ISO639.addCode("bis", "bi");
        ISO639.addCode("bos", "bs");
        ISO639.addCode("bre", "br");
        ISO639.addCode("bul", "bg");
        ISO639.addCode("bur", "my");
        ISO639.addCode("cat", "ca");
        ISO639.addCode("cha", "ch");
        ISO639.addCode("che", "ce");
        ISO639.addCode("chi", "zh");
        ISO639.addCode("chu", "cu");
        ISO639.addCode("chv", "cv");
        ISO639.addCode("cor", "kw");
        ISO639.addCode("cos", "co");
        ISO639.addCode("cre", "cr");
        ISO639.addCode("cze", "cs");
        ISO639.addCode("dan", "da");
        ISO639.addCode("div", "dv");
        ISO639.addCode("dut", "nl");
        ISO639.addCode("dzo", "dz");
        ISO639.addCode("eng", "en");
        ISO639.addCode("epo", "eo");
        ISO639.addCode("est", "et");
        ISO639.addCode("ewe", "ee");
        ISO639.addCode("fao", "fo");
        ISO639.addCode("fij", "fj");
        ISO639.addCode("fin", "fi");
        ISO639.addCode("fre", "fr");
        ISO639.addCode("fry", "fy");
        ISO639.addCode("ful", "ff");
        ISO639.addCode("gaa", "Ga");
        ISO639.addCode("geo", "ka");
        ISO639.addCode("ger", "de");
        ISO639.addCode("gla", "gd");
        ISO639.addCode("gle", "ga");
        ISO639.addCode("glg", "gl");
        ISO639.addCode("glv", "gv");
        ISO639.addCode("gre", "el");
        ISO639.addCode("grn", "gn");
        ISO639.addCode("guj", "gu");
        ISO639.addCode("hat", "ht");
        ISO639.addCode("hau", "ha");
        ISO639.addCode("heb", "he");
        ISO639.addCode("her", "hz");
        ISO639.addCode("hin", "hi");
        ISO639.addCode("hmo", "ho");
        ISO639.addCode("hrv", "hr");
        ISO639.addCode("hun", "hu");
        ISO639.addCode("ibo", "ig");
        ISO639.addCode("ice", "is");
        ISO639.addCode("ido", "io");
        ISO639.addCode("iii", "ii");
        ISO639.addCode("iku", "iu");
        ISO639.addCode("ile", "ie");
        ISO639.addCode("ina", "ia");
        ISO639.addCode("ind", "id");
        ISO639.addCode("ipk", "ik");
        ISO639.addCode("ita", "it");
        ISO639.addCode("jav", "jv");
        ISO639.addCode("jpn", "ja");
        ISO639.addCode("kal", "kl");
        ISO639.addCode("kan", "kn");
        ISO639.addCode("kas", "ks");
        ISO639.addCode("kau", "kr");
        ISO639.addCode("kaz", "kk");
        ISO639.addCode("khm", "km");
        ISO639.addCode("kik", "ki");
        ISO639.addCode("kin", "rw");
        ISO639.addCode("kir", "ky");
        ISO639.addCode("kom", "kv");
        ISO639.addCode("kon", "kg");
        ISO639.addCode("kor", "ko");
        ISO639.addCode("kua", "kj");
        ISO639.addCode("kur", "ku");
        ISO639.addCode("lao", "lo");
        ISO639.addCode("lat", "la");
        ISO639.addCode("lav", "lv");
        ISO639.addCode("lim", "li");
        ISO639.addCode("lin", "ln");
        ISO639.addCode("lit", "lt");
        ISO639.addCode("ltz", "lb");
        ISO639.addCode("lub", "lu");
        ISO639.addCode("lug", "lg");
        ISO639.addCode("mac", "mk");
        ISO639.addCode("mah", "mh");
        ISO639.addCode("mal", "ml");
        ISO639.addCode("mao", "mi");
        ISO639.addCode("mar", "mr");
        ISO639.addCode("may", "ms");
        ISO639.addCode("mlg", "mg");
        ISO639.addCode("mlt", "mt");
        ISO639.addCode("mon", "mn");
        ISO639.addCode("nau", "na");
        ISO639.addCode("nav", "nv");
        ISO639.addCode("nbl", "nr");
        ISO639.addCode("nde", "nd");
        ISO639.addCode("ndo", "ng");
        ISO639.addCode("nep", "ne");
        ISO639.addCode("nno", "nn");
        ISO639.addCode("nob", "nb");
        ISO639.addCode("nor", "no");
        ISO639.addCode("nya", "ny");
        ISO639.addCode("oci", "oc");
        ISO639.addCode("oji", "oj");
        ISO639.addCode("ori", "or");
        ISO639.addCode("orm", "om");
        ISO639.addCode("oss", "os");
        ISO639.addCode("pan", "pa");
        ISO639.addCode("per", "fa");
        ISO639.addCode("pli", "pi");
        ISO639.addCode("pol", "pl");
        ISO639.addCode("por", "pt");
        ISO639.addCode("pus", "ps");
        ISO639.addCode("que", "qu");
        ISO639.addCode("roh", "rm");
        ISO639.addCode("rum", "ro");
        ISO639.addCode("run", "rn");
        ISO639.addCode("rus", "ru");
        ISO639.addCode("sag", "sg");
        ISO639.addCode("san", "sa");
        ISO639.addCode("sin", "si");
        ISO639.addCode("slo", "sk");
        ISO639.addCode("slv", "sl");
        ISO639.addCode("sme", "se");
        ISO639.addCode("smo", "sm");
        ISO639.addCode("sna", "sn");
        ISO639.addCode("snd", "sd");
        ISO639.addCode("som", "so");
        ISO639.addCode("sot", "st");
        ISO639.addCode("spa", "es");
        ISO639.addCode("srd", "sc");
        ISO639.addCode("srp", "sr");
        ISO639.addCode("ssw", "ss");
        ISO639.addCode("sun", "su");
        ISO639.addCode("swa", "sw");
        ISO639.addCode("swe", "sv");
        ISO639.addCode("tah", "ty");
        ISO639.addCode("tam", "ta");
        ISO639.addCode("tat", "tt");
        ISO639.addCode("tel", "te");
        ISO639.addCode("tgk", "tg");
        ISO639.addCode("tgl", "tl");
        ISO639.addCode("tha", "th");
        ISO639.addCode("tib", "bo");
        ISO639.addCode("tir", "ti");
        ISO639.addCode("ton", "to");
        ISO639.addCode("tsn", "tn");
        ISO639.addCode("tso", "ts");
        ISO639.addCode("tuk", "tk");
        ISO639.addCode("tur", "tr");
        ISO639.addCode("twi", "tw");
        ISO639.addCode("uig", "ug");
        ISO639.addCode("ukr", "uk");
        ISO639.addCode("urd", "ur");
        ISO639.addCode("uzb", "uz");
        ISO639.addCode("ven", "ve");
        ISO639.addCode("vie", "vi");
        ISO639.addCode("vol", "vo");
        ISO639.addCode("wel", "cy");
        ISO639.addCode("wln", "wa");
        ISO639.addCode("wol", "wo");
        ISO639.addCode("xho", "xh");
        ISO639.addCode("yid", "yi");
        ISO639.addCode("yor", "yo");
        ISO639.addCode("zha", "za");
        ISO639.addCode("zul", "zu");
    }
}

