/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

final class OutputChannel
implements WritableByteChannel {
    private final WritableByteChannel ch;
    private long count;

    public OutputChannel(WritableByteChannel ch) {
        this.ch = ch;
        this.count = 0L;
    }

    public long count() {
        return this.count;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int n = this.ch.write(src);
        if (n > 0) {
            this.count += (long)n;
        }
        return n;
    }

    @Override
    public boolean isOpen() {
        return this.ch.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.ch.close();
    }
}

