/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;

final class IO {
    private IO() {
    }

    public static void read(InputChannel ch, int len, ByteBuffer buf) throws IOException {
        int r;
        if (len <= 0) {
            throw new IllegalArgumentException("len argument must be > 0");
        }
        buf.clear().limit(len);
        int n = 0;
        do {
            if ((r = ch.read(buf)) >= 0) continue;
            throw new EOFException();
        } while ((n += r) < len);
        buf.flip();
    }

    public static void skip(InputChannel ch, long len, ByteBuffer buf) throws IOException {
        if (len <= 0L) {
            throw new IllegalArgumentException("len argument must be > 0");
        }
        int size = buf.clear().capacity();
        long a = len / (long)size;
        int b = (int)(len % (long)size);
        for (long i = 0L; i < a; ++i) {
            IO.read(ch, size, buf);
        }
        if (b > 0) {
            IO.read(ch, b, buf);
        }
    }

    public static void skip(InputChannel ch, ByteBuffer buf) throws IOException {
        long len = Long.MAX_VALUE;
        boolean eof = false;
        do {
            try {
                IO.skip(ch, len, buf);
            }
            catch (EOFException e) {
                eof = true;
            }
        } while (!eof);
    }

    public static void write(OutputChannel ch, int len, ByteBuffer buf) throws IOException {
        if (len <= 0) {
            throw new IllegalArgumentException("len argument must be > 0");
        }
        buf.flip().limit(len);
        int n = 0;
        while ((n += ch.write(buf)) < len) {
        }
        buf.clear();
    }

    public static void skip(OutputChannel ch, long len, ByteBuffer buf) throws IOException {
        if (len <= 0L) {
            throw new IllegalArgumentException("len argument must be > 0");
        }
        int size = buf.clear().capacity();
        long a = len / (long)size;
        int b = (int)(len % (long)size);
        for (long i = 0L; i < a; ++i) {
            IO.write(ch, size, buf);
        }
        if (b > 0) {
            IO.write(ch, b, buf);
        }
    }

    public static void copy(InputChannel src, OutputChannel dst, long len, ByteBuffer buf) throws IOException {
        if (len <= 0L) {
            throw new IllegalArgumentException("len argument must be > 0");
        }
        int size = buf.clear().capacity();
        long a = len / (long)size;
        int b = (int)(len % (long)size);
        for (long i = 0L; i < a; ++i) {
            IO.read(src, size, buf);
            IO.write(dst, size, buf);
        }
        if (b > 0) {
            IO.read(src, b, buf);
            IO.write(dst, b, buf);
        }
    }

    public static ByteBuffer get(ByteBuffer buf, int[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = buf.getInt();
        }
        return buf;
    }

    public static ByteBuffer get(ByteBuffer buf, short[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = buf.getShort();
        }
        return buf;
    }

    public static byte[] str(ByteBuffer buf) {
        byte b;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((b = buf.get()) != 0) {
            out.write(b);
        }
        return out.toByteArray();
    }

    public static ByteBuffer put(ByteBuffer buf, int[] arr) {
        for (int anArr : arr) {
            buf.putInt(anArr);
        }
        return buf;
    }

    public static ByteBuffer put(ByteBuffer buf, short[] arr) {
        for (short anArr : arr) {
            buf.putShort(anArr);
        }
        return buf;
    }

    public static void close(Closeable f) {
        try {
            if (f != null) {
                f.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

