/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.Bits;
import com.frostwire.mp4.Box;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public class FullBox
extends Box {
    protected byte version;
    protected int flags;

    FullBox(int type) {
        super(type);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        IO.read(ch, 4, buf);
        int n = buf.getInt();
        this.version = Bits.int3(n);
        this.flags = Bits.int32((byte)0, Bits.int2(n), Bits.int1(n), Bits.int0(n));
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        int n = Bits.int32(this.version, Bits.int2(this.flags), Bits.int1(this.flags), Bits.int0(this.flags));
        buf.putInt(n);
        IO.write(ch, 4, buf);
    }
}

