/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.OutputChannel;
import com.frostwire.mp4.Utf8;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class DataEntryUrlBox
extends FullBox {
    protected byte[] location;

    DataEntryUrlBox() {
        super(url_);
    }

    public String location() {
        return this.location != null ? Utf8.convert(this.location) : null;
    }

    public void location(String value) {
        this.location = value != null ? Utf8.convert(value) : null;
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        int len = (int)(this.length() - 4L);
        if (len != 0) {
            IO.read(ch, len, buf);
            if (buf.remaining() > 0) {
                this.location = IO.str(buf);
            }
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        if (this.location != null) {
            buf.put(this.location);
            buf.put((byte)0);
        }
        if (buf.position() > 0) {
            IO.write(ch, buf.position(), buf);
        }
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        if (this.location != null) {
            s += (long)(this.location.length + 1);
        }
        this.length(s);
    }
}

