/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp4;

import com.frostwire.mp4.BoxEntry;
import com.frostwire.mp4.FullBox;
import com.frostwire.mp4.IO;
import com.frostwire.mp4.InputChannel;
import com.frostwire.mp4.IsoMedia;
import com.frostwire.mp4.OutputChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class CompositionOffsetBox
extends FullBox {
    protected int entry_count;
    protected Entry[] entries;

    CompositionOffsetBox() {
        super(ctts);
    }

    @Override
    void read(InputChannel ch, ByteBuffer buf) throws IOException {
        super.read(ch, buf);
        IO.read(ch, 4, buf);
        this.entry_count = buf.getInt();
        this.entries = new Entry[this.entry_count];
        for (int i = 0; i < this.entry_count; ++i) {
            Entry e = new Entry();
            IO.read(ch, 8, buf);
            e.get(buf);
            this.entries[i] = e;
        }
    }

    @Override
    void write(OutputChannel ch, ByteBuffer buf) throws IOException {
        super.write(ch, buf);
        buf.putInt(this.entry_count);
        IO.write(ch, 4, buf);
        IsoMedia.write(ch, this.entry_count, 8, this.entries, buf);
    }

    @Override
    void update() {
        long s = 0L;
        s += 4L;
        s += 4L;
        this.length(s += (long)(this.entry_count * 8));
    }

    public static final class Entry
    extends BoxEntry {
        public int sample_count;
        public int sample_offset;

        @Override
        void get(ByteBuffer buf) throws IOException {
            this.sample_count = buf.getInt();
            this.sample_offset = buf.getInt();
        }

        @Override
        void put(ByteBuffer buf) throws IOException {
            buf.putInt(this.sample_count);
            buf.putInt(this.sample_offset);
        }
    }
}

