/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.AbstractID3v2FrameData;
import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2TextFrameData
extends AbstractID3v2FrameData {
    protected EncodedText text;

    public ID3v2TextFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2TextFrameData(boolean unsynchronisation, EncodedText text) {
        super(unsynchronisation);
        this.text = text;
    }

    public ID3v2TextFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation);
        this.synchroniseAndUnpackFrameData(bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        this.text = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 1, bytes.length - 1));
    }

    @Override
    protected byte[] packFrameData() {
        byte[] bytes = new byte[this.getLength()];
        bytes[0] = this.text != null ? this.text.getTextEncoding() : (byte)0;
        if (this.text != null && this.text.toBytes().length > 0) {
            BufferTools.copyIntoByteBuffer(this.text.toBytes(), 0, this.text.toBytes().length, bytes, 1);
        }
        return bytes;
    }

    @Override
    protected int getLength() {
        int length = 1;
        if (this.text != null) {
            length += this.text.toBytes().length;
        }
        return length;
    }

    public EncodedText getText() {
        return this.text;
    }

    public void setText(EncodedText text) {
        this.text = text;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v2TextFrameData)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        ID3v2TextFrameData other = (ID3v2TextFrameData)obj;
        if (this.text == null) {
            if (other.text != null) {
                return false;
            }
        } else {
            if (other.text == null) {
                return false;
            }
            if (!this.text.equals(other.text)) {
                return false;
            }
        }
        return true;
    }
}

