/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.ID3v2PictureFrameData;
import com.frostwire.mp3.InvalidDataException;

public class ID3v2ObseletePictureFrameData
extends ID3v2PictureFrameData {
    public ID3v2ObseletePictureFrameData(boolean unsynchronisation) {
        super(unsynchronisation);
    }

    public ID3v2ObseletePictureFrameData(boolean unsynchronisation, String mimeType, byte pictureType, EncodedText description, byte[] imageData) {
        super(unsynchronisation, mimeType, pictureType, description, imageData);
    }

    public ID3v2ObseletePictureFrameData(boolean unsynchronisation, byte[] bytes) throws InvalidDataException {
        super(unsynchronisation, bytes);
    }

    @Override
    protected void unpackFrameData(byte[] bytes) throws InvalidDataException {
        int marker;
        this.mimeType = "image/" + BufferTools.byteBufferToString(bytes, 1, 3).toLowerCase();
        this.pictureType = bytes[4];
        for (marker = 5; marker < bytes.length && bytes[marker] != 0; ++marker) {
        }
        this.description = new EncodedText(bytes[0], BufferTools.copyBuffer(bytes, 5, marker - 5));
        this.imageData = BufferTools.copyBuffer(bytes, marker + 1, bytes.length - marker - 1);
    }
}

