/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.EncodedText;
import com.frostwire.mp3.ID3v1Genres;
import com.frostwire.mp3.ID3v2;
import com.frostwire.mp3.ID3v2CommentFrameData;
import com.frostwire.mp3.ID3v2Frame;
import com.frostwire.mp3.ID3v2FrameSet;
import com.frostwire.mp3.ID3v2ObseleteFrame;
import com.frostwire.mp3.ID3v2ObseletePictureFrameData;
import com.frostwire.mp3.ID3v2PictureFrameData;
import com.frostwire.mp3.ID3v2TagFactory;
import com.frostwire.mp3.ID3v2TextFrameData;
import com.frostwire.mp3.ID3v2UrlFrameData;
import com.frostwire.mp3.InvalidDataException;
import com.frostwire.mp3.NoSuchTagException;
import com.frostwire.mp3.NotSupportedException;
import com.frostwire.mp3.UnsupportedTagException;
import java.util.Map;
import java.util.TreeMap;

public abstract class AbstractID3v2Tag
implements ID3v2 {
    public static final String ID_IMAGE = "APIC";
    public static final String ID_ENCODER = "TENC";
    public static final String ID_URL = "WXXX";
    public static final String ID_COPYRIGHT = "TCOP";
    public static final String ID_ORIGINAL_ARTIST = "TOPE";
    public static final String ID_COMPOSER = "TCOM";
    public static final String ID_COMMENT = "COMM";
    public static final String ID_GENRE = "TCON";
    public static final String ID_YEAR = "TYER";
    public static final String ID_ALBUM = "TALB";
    public static final String ID_TITLE = "TIT2";
    public static final String ID_ARTIST = "TPE1";
    public static final String ID_TRACK = "TRCK";
    public static final String ID_IMAGE_OBSELETE = "PIC";
    public static final String ID_ENCODER_OBSELETE = "TEN";
    public static final String ID_URL_OBSELETE = "WXX";
    public static final String ID_COPYRIGHT_OBSELETE = "TCR";
    public static final String ID_ORIGINAL_ARTIST_OBSELETE = "TOA";
    public static final String ID_COMPOSER_OBSELETE = "TCM";
    public static final String ID_COMMENT_OBSELETE = "COM";
    public static final String ID_GENRE_OBSELETE = "TCO";
    public static final String ID_YEAR_OBSELETE = "TYE";
    public static final String ID_ALBUM_OBSELETE = "TAL";
    public static final String ID_TITLE_OBSELETE = "TT2";
    public static final String ID_ARTIST_OBSELETE = "TP1";
    public static final String ID_TRACK_OBSELETE = "TRK";
    protected static final String TAG = "ID3";
    protected static final String FOOTER_TAG = "3DI";
    protected static final int HEADER_LENGTH = 10;
    protected static final int FOOTER_LENGTH = 10;
    protected static final int MAJOR_VERSION_OFFSET = 3;
    protected static final int MINOR_VERSION_OFFSET = 4;
    protected static final int FLAGS_OFFSET = 5;
    protected static final int DATA_LENGTH_OFFSET = 6;
    protected static final int FOOTER_BIT = 4;
    protected static final int EXPERIMENTAL_BIT = 5;
    protected static final int EXTENDED_HEADER_BIT = 6;
    protected static final int COMPRESSION_BIT = 6;
    protected static final int UNSYNCHRONISATION_BIT = 7;
    protected static final int PADDING_LENGTH = 256;
    private static final String ITUNES_COMMENT_DESCRIPTION = "iTunNORM";
    protected boolean unsynchronisation = false;
    protected boolean extendedHeader = false;
    protected boolean experimental = false;
    protected boolean footer = false;
    protected boolean compression = false;
    protected boolean padding = false;
    protected String version = null;
    private int dataLength = 0;
    private int extendedHeaderLength;
    private byte[] extendedHeaderData;
    private boolean obseleteFormat = false;
    private final Map<String, ID3v2FrameSet> frameSets = new TreeMap<String, ID3v2FrameSet>();

    public AbstractID3v2Tag() {
    }

    public AbstractID3v2Tag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this(bytes, false);
    }

    public AbstractID3v2Tag(byte[] bytes, boolean obseleteFormat) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        this.obseleteFormat = obseleteFormat;
        this.unpackTag(bytes);
    }

    private void unpackTag(byte[] bytes) throws NoSuchTagException, UnsupportedTagException, InvalidDataException {
        ID3v2TagFactory.sanityCheckTag(bytes);
        int offset = this.unpackHeader(bytes);
        try {
            if (this.extendedHeader) {
                offset = this.unpackExtendedHeader(bytes, offset);
            }
            int framesLength = this.dataLength;
            if (this.footer) {
                framesLength -= 10;
            }
            offset = this.unpackFrames(bytes, offset, framesLength);
            if (this.footer) {
                offset = this.unpackFooter(bytes, this.dataLength);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new InvalidDataException("Premature end of tag", e);
        }
    }

    private int unpackHeader(byte[] bytes) throws UnsupportedTagException, InvalidDataException {
        byte majorVersion = bytes[3];
        byte minorVersion = bytes[4];
        this.version = majorVersion + "." + minorVersion;
        if (majorVersion != 2 && majorVersion != 3 && majorVersion != 4) {
            throw new UnsupportedTagException("Unsupported version " + this.version);
        }
        this.unpackFlags(bytes);
        if ((bytes[5] & 0xF) != 0) {
            throw new UnsupportedTagException("Unrecognised bits in header");
        }
        this.dataLength = BufferTools.unpackSynchsafeInteger(bytes[6], bytes[7], bytes[8], bytes[9]);
        if (this.dataLength < 1) {
            throw new InvalidDataException("Zero size tag");
        }
        return 10;
    }

    protected abstract void unpackFlags(byte[] var1);

    private int unpackExtendedHeader(byte[] bytes, int offset) {
        this.extendedHeaderLength = BufferTools.unpackSynchsafeInteger(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]) + 4;
        this.extendedHeaderData = BufferTools.copyBuffer(bytes, offset + 4, this.extendedHeaderLength);
        return this.extendedHeaderLength;
    }

    protected int unpackFrames(byte[] bytes, int offset, int framesLength) {
        int currentOffset;
        ID3v2Frame frame;
        for (currentOffset = offset; currentOffset <= framesLength; currentOffset += frame.getLength()) {
            try {
                frame = this.createFrame(bytes, currentOffset);
                this.addFrame(frame, false);
                continue;
            }
            catch (InvalidDataException e) {
                break;
            }
        }
        return currentOffset;
    }

    private void addFrame(ID3v2Frame frame, boolean replace) {
        ID3v2FrameSet frameSet = this.frameSets.get(frame.getId());
        if (frameSet == null) {
            frameSet = new ID3v2FrameSet(frame.getId());
            frameSet.addFrame(frame);
            this.frameSets.put(frame.getId(), frameSet);
        } else if (replace) {
            frameSet.clear();
            frameSet.addFrame(frame);
        } else {
            frameSet.addFrame(frame);
        }
    }

    protected ID3v2Frame createFrame(byte[] bytes, int currentOffset) throws InvalidDataException {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(bytes, currentOffset);
        }
        return new ID3v2Frame(bytes, currentOffset);
    }

    protected ID3v2Frame createFrame(String id, byte[] data) {
        if (this.obseleteFormat) {
            return new ID3v2ObseleteFrame(id, data);
        }
        return new ID3v2Frame(id, data);
    }

    private int unpackFooter(byte[] bytes, int offset) throws InvalidDataException {
        if (!FOOTER_TAG.equals(BufferTools.byteBufferToString(bytes, offset, FOOTER_TAG.length()))) {
            throw new InvalidDataException("Invalid footer");
        }
        return 10;
    }

    @Override
    public byte[] toBytes() throws NotSupportedException {
        byte[] bytes = new byte[this.getLength()];
        this.packTag(bytes);
        return bytes;
    }

    public void packTag(byte[] bytes) throws NotSupportedException {
        int offset = this.packHeader(bytes, 0);
        if (this.extendedHeader) {
            offset = this.packExtendedHeader(bytes, offset);
        }
        offset = this.packFrames(bytes, offset);
        if (this.footer) {
            offset = this.packFooter(bytes, this.dataLength);
        }
    }

    private int packHeader(byte[] bytes, int offset) {
        BufferTools.stringIntoByteBuffer(TAG, 0, TAG.length(), bytes, offset);
        String[] s = this.version.split("\\.");
        if (s.length > 0) {
            byte majorVersion;
            bytes[offset + 3] = majorVersion = Byte.parseByte(s[0]);
        }
        if (s.length > 1) {
            byte minorVersion;
            bytes[offset + 4] = minorVersion = Byte.parseByte(s[1]);
        }
        this.packFlags(bytes, offset);
        BufferTools.packSynchsafeInteger(this.getDataLength(), bytes, offset + 6);
        return offset + 10;
    }

    protected abstract void packFlags(byte[] var1, int var2);

    private int packExtendedHeader(byte[] bytes, int offset) {
        BufferTools.packSynchsafeInteger(this.extendedHeaderLength, bytes, offset);
        BufferTools.copyIntoByteBuffer(this.extendedHeaderData, 0, this.extendedHeaderData.length, bytes, offset + 4);
        return offset + 4 + this.extendedHeaderData.length;
    }

    public int packFrames(byte[] bytes, int offset) throws NotSupportedException {
        int newOffset = this.packSpecifiedFrames(bytes, offset, null, ID_IMAGE);
        newOffset = this.packSpecifiedFrames(bytes, newOffset, ID_IMAGE, null);
        return newOffset;
    }

    private int packSpecifiedFrames(byte[] bytes, int offset, String onlyId, String notId) throws NotSupportedException {
        for (ID3v2FrameSet frameSet : this.frameSets.values()) {
            if (onlyId != null && !onlyId.equals(frameSet.getId()) || notId != null && notId.equals(frameSet.getId())) continue;
            for (ID3v2Frame frame : frameSet.getFrames()) {
                if (frame.getDataLength() <= 0) continue;
                byte[] frameData = frame.toBytes();
                BufferTools.copyIntoByteBuffer(frameData, 0, frameData.length, bytes, offset);
                offset += frameData.length;
            }
        }
        return offset;
    }

    private int packFooter(byte[] bytes, int offset) {
        BufferTools.stringIntoByteBuffer(FOOTER_TAG, 0, FOOTER_TAG.length(), bytes, offset);
        String[] s = this.version.split(".");
        if (s.length > 0) {
            byte majorVersion;
            bytes[offset + 3] = majorVersion = Byte.parseByte(s[0]);
        }
        if (s.length > 1) {
            byte minorVersion;
            bytes[offset + 4] = minorVersion = Byte.parseByte(s[0]);
        }
        this.packFlags(bytes, offset);
        BufferTools.packSynchsafeInteger(this.getDataLength(), bytes, offset + 6);
        return offset + 10;
    }

    private int calculateDataLength() {
        int length = 0;
        if (this.extendedHeader) {
            length += this.extendedHeaderLength;
        }
        if (this.footer) {
            length += 10;
        } else if (this.padding) {
            length += 256;
        }
        for (ID3v2FrameSet frameSet : this.frameSets.values()) {
            for (ID3v2Frame frame : frameSet.getFrames()) {
                length += frame.getLength();
            }
        }
        return length;
    }

    protected boolean useFrameUnsynchronisation() {
        return false;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    private void invalidateDataLength() {
        this.dataLength = 0;
    }

    @Override
    public int getDataLength() {
        if (this.dataLength == 0) {
            this.dataLength = this.calculateDataLength();
        }
        return this.dataLength;
    }

    @Override
    public int getLength() {
        return this.getDataLength() + 10;
    }

    @Override
    public Map<String, ID3v2FrameSet> getFrameSets() {
        return this.frameSets;
    }

    @Override
    public boolean getPadding() {
        return this.padding;
    }

    @Override
    public void setPadding(boolean padding) {
        if (this.padding != padding) {
            this.invalidateDataLength();
            this.padding = padding;
        }
    }

    @Override
    public boolean hasFooter() {
        return this.footer;
    }

    @Override
    public void setFooter(boolean footer) {
        if (this.footer != footer) {
            this.invalidateDataLength();
            this.footer = footer;
        }
    }

    @Override
    public boolean hasUnsynchronisation() {
        return this.unsynchronisation;
    }

    @Override
    public void setUnsynchronisation(boolean unsynchronisation) {
        if (this.unsynchronisation != unsynchronisation) {
            this.invalidateDataLength();
            this.unsynchronisation = unsynchronisation;
        }
    }

    @Override
    public boolean getObseleteFormat() {
        return this.obseleteFormat;
    }

    @Override
    public String getTrack() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_TRACK_OBSELETE) : this.extractTextFrameData(ID_TRACK);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTrack(String track) {
        if (track != null && track.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, track));
            this.addFrame(this.createFrame(ID_TRACK, frameData.toBytes()), true);
        }
    }

    @Override
    public String getArtist() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_ARTIST_OBSELETE) : this.extractTextFrameData(ID_ARTIST);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setArtist(String artist) {
        if (artist != null && artist.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, artist));
            this.addFrame(this.createFrame(ID_ARTIST, frameData.toBytes()), true);
        }
    }

    @Override
    public String getTitle() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_TITLE_OBSELETE) : this.extractTextFrameData(ID_TITLE);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setTitle(String title) {
        if (title != null && title.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, title));
            this.addFrame(this.createFrame(ID_TITLE, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbum() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_ALBUM_OBSELETE) : this.extractTextFrameData(ID_ALBUM);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setAlbum(String album) {
        if (album != null && album.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, album));
            this.addFrame(this.createFrame(ID_ALBUM, frameData.toBytes()), true);
        }
    }

    @Override
    public String getYear() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_YEAR_OBSELETE) : this.extractTextFrameData(ID_YEAR);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setYear(String year) {
        if (year != null && year.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, year));
            this.addFrame(this.createFrame(ID_YEAR, frameData.toBytes()), true);
        }
    }

    @Override
    public int getGenre() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_GENRE_OBSELETE) : this.extractTextFrameData(ID_GENRE);
        if (frameData == null || frameData.getText() == null) {
            return -1;
        }
        String text = frameData.getText().toString();
        if (text == null || text.length() == 0) {
            return -1;
        }
        try {
            return this.extractGenreNumber(text);
        }
        catch (NumberFormatException e) {
            String description = this.extractGenreDescription(text);
            if (description != null && description.length() > 0) {
                for (int i = 0; i < ID3v1Genres.GENRES.length; ++i) {
                    if (ID3v1Genres.GENRES[i].compareToIgnoreCase(description) != 0) continue;
                    return i;
                }
            }
            return -1;
        }
    }

    @Override
    public void setGenre(int genre) {
        if (genre >= 0) {
            String genreDescription;
            this.invalidateDataLength();
            try {
                genreDescription = ID3v1Genres.GENRES[genre];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                genreDescription = "";
            }
            String combinedGenre = "(" + Integer.toString(genre) + ")" + genreDescription;
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, combinedGenre));
            this.addFrame(this.createFrame(ID_GENRE, frameData.toBytes()), true);
        }
    }

    @Override
    public String getGenreDescription() {
        String description;
        String text;
        int genreNum = this.getGenre();
        if (genreNum >= 0) {
            try {
                return ID3v1Genres.GENRES[genreNum];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_GENRE_OBSELETE) : this.extractTextFrameData(ID_GENRE);
        if (frameData != null && frameData.getText() != null && (text = frameData.getText().toString()) != null && text.length() > 0 && (description = this.extractGenreDescription(text)) != null & description.length() > 0) {
            return description;
        }
        return null;
    }

    protected int extractGenreNumber(String genreValue) throws NumberFormatException {
        int pos;
        String value = genreValue.trim();
        if (value.length() > 0 && value.charAt(0) == '(' && (pos = value.indexOf(41)) > 0) {
            return Integer.parseInt(value.substring(1, pos));
        }
        return Integer.parseInt(value);
    }

    protected String extractGenreDescription(String genreValue) throws NumberFormatException {
        String value = genreValue.trim();
        if (value.length() > 0) {
            int pos;
            if (value.charAt(0) == '(' && (pos = value.indexOf(41)) > 0) {
                return value.substring(pos + 1);
            }
            return value;
        }
        return null;
    }

    @Override
    public String getComment() {
        ID3v2CommentFrameData frameData = this.obseleteFormat ? this.extractCommentFrameData(ID_COMMENT_OBSELETE, false) : this.extractCommentFrameData(ID_COMMENT, false);
        if (frameData != null && frameData.getComment() != null) {
            return frameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && comment.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), "eng", null, new EncodedText(0, comment));
            this.addFrame(this.createFrame(ID_COMMENT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getItunesComment() {
        ID3v2CommentFrameData frameData = this.obseleteFormat ? this.extractCommentFrameData(ID_COMMENT_OBSELETE, true) : this.extractCommentFrameData(ID_COMMENT, true);
        if (frameData != null && frameData.getComment() != null) {
            return frameData.getComment().toString();
        }
        return null;
    }

    @Override
    public void setItunesComment(String itunesComment) {
        if (itunesComment != null && itunesComment.length() > 0) {
            this.invalidateDataLength();
            ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), ITUNES_COMMENT_DESCRIPTION, null, new EncodedText(0, itunesComment));
            this.addFrame(this.createFrame(ID_COMMENT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getComposer() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_COMPOSER_OBSELETE) : this.extractTextFrameData(ID_COMPOSER);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setComposer(String composer) {
        if (composer != null && composer.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, composer));
            this.addFrame(this.createFrame(ID_COMPOSER, frameData.toBytes()), true);
        }
    }

    @Override
    public String getOriginalArtist() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_ORIGINAL_ARTIST_OBSELETE) : this.extractTextFrameData(ID_ORIGINAL_ARTIST);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setOriginalArtist(String originalArtist) {
        if (originalArtist != null && originalArtist.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, originalArtist));
            this.addFrame(this.createFrame(ID_ORIGINAL_ARTIST, frameData.toBytes()), true);
        }
    }

    @Override
    public String getCopyright() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_COPYRIGHT_OBSELETE) : this.extractTextFrameData(ID_COPYRIGHT);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setCopyright(String copyright) {
        if (copyright != null && copyright.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, copyright));
            this.addFrame(this.createFrame(ID_COPYRIGHT, frameData.toBytes()), true);
        }
    }

    @Override
    public String getUrl() {
        ID3v2UrlFrameData frameData = this.obseleteFormat ? this.extractUrlFrameData(ID_URL_OBSELETE) : this.extractUrlFrameData(ID_URL);
        if (frameData != null) {
            return frameData.getUrl();
        }
        return null;
    }

    @Override
    public void setUrl(String url) {
        if (url != null && url.length() > 0) {
            this.invalidateDataLength();
            ID3v2UrlFrameData frameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), null, url);
            this.addFrame(this.createFrame(ID_URL, frameData.toBytes()), true);
        }
    }

    @Override
    public String getEncoder() {
        ID3v2TextFrameData frameData = this.obseleteFormat ? this.extractTextFrameData(ID_ENCODER_OBSELETE) : this.extractTextFrameData(ID_ENCODER);
        if (frameData != null && frameData.getText() != null) {
            return frameData.getText().toString();
        }
        return null;
    }

    @Override
    public void setEncoder(String encoder) {
        if (encoder != null && encoder.length() > 0) {
            this.invalidateDataLength();
            ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), new EncodedText(0, encoder));
            this.addFrame(this.createFrame(ID_ENCODER, frameData.toBytes()), true);
        }
    }

    @Override
    public byte[] getAlbumImage() {
        ID3v2PictureFrameData frameData = this.obseleteFormat ? this.createPictureFrameData(ID_IMAGE_OBSELETE) : this.createPictureFrameData(ID_IMAGE);
        if (frameData != null) {
            return frameData.getImageData();
        }
        return null;
    }

    @Override
    public void setAlbumImage(byte[] albumImage, String mimeType) {
        if (albumImage != null && albumImage.length > 0 && mimeType != null && mimeType.length() > 0) {
            this.invalidateDataLength();
            ID3v2PictureFrameData frameData = new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), mimeType, 0, null, albumImage);
            this.addFrame(this.createFrame(ID_IMAGE, frameData.toBytes()), true);
        }
    }

    @Override
    public String getAlbumImageMimeType() {
        ID3v2PictureFrameData frameData = this.obseleteFormat ? this.createPictureFrameData(ID_IMAGE_OBSELETE) : this.createPictureFrameData(ID_IMAGE);
        if (frameData != null && frameData.getMimeType() != null) {
            return frameData.getMimeType();
        }
        return null;
    }

    @Override
    public void clearFrameSet(String id) {
        if (this.frameSets.remove(id) != null) {
            this.invalidateDataLength();
        }
    }

    private ID3v2TextFrameData extractTextFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2TextFrameData frameData = new ID3v2TextFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2UrlFrameData extractUrlFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2UrlFrameData frameData = new ID3v2UrlFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    private ID3v2CommentFrameData extractCommentFrameData(String id, boolean itunes) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            for (ID3v2Frame frame : frameSet.getFrames()) {
                try {
                    ID3v2CommentFrameData frameData = new ID3v2CommentFrameData(this.useFrameUnsynchronisation(), frame.getData());
                    if (!itunes && frameData.getDescription().toString().startsWith("iTun")) continue;
                    if (itunes && ITUNES_COMMENT_DESCRIPTION.equals(frameData.getDescription().toString())) {
                        return frameData;
                    }
                    if (itunes) continue;
                    return frameData;
                }
                catch (InvalidDataException invalidDataException) {
                }
            }
        }
        return null;
    }

    private ID3v2PictureFrameData createPictureFrameData(String id) {
        ID3v2FrameSet frameSet = this.frameSets.get(id);
        if (frameSet != null) {
            ID3v2Frame frame = frameSet.getFrames().get(0);
            try {
                ID3v2PictureFrameData frameData = this.obseleteFormat ? new ID3v2ObseletePictureFrameData(this.useFrameUnsynchronisation(), frame.getData()) : new ID3v2PictureFrameData(this.useFrameUnsynchronisation(), frame.getData());
                return frameData;
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2Tag)) {
            return false;
        }
        if (super.equals(obj)) {
            return true;
        }
        AbstractID3v2Tag other = (AbstractID3v2Tag)obj;
        if (this.unsynchronisation != other.unsynchronisation) {
            return false;
        }
        if (this.extendedHeader != other.extendedHeader) {
            return false;
        }
        if (this.experimental != other.experimental) {
            return false;
        }
        if (this.footer != other.footer) {
            return false;
        }
        if (this.compression != other.compression) {
            return false;
        }
        if (this.dataLength != other.dataLength) {
            return false;
        }
        if (this.extendedHeaderLength != other.extendedHeaderLength) {
            return false;
        }
        if (this.version == null) {
            if (other.version != null) {
                return false;
            }
        } else {
            if (other.version == null) {
                return false;
            }
            if (!this.version.equals(other.version)) {
                return false;
            }
        }
        if (this.frameSets == null) {
            if (other.frameSets != null) {
                return false;
            }
        } else {
            if (other.frameSets == null) {
                return false;
            }
            if (!this.frameSets.equals(other.frameSets)) {
                return false;
            }
        }
        return true;
    }
}

