/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mp3;

import com.frostwire.mp3.BufferTools;
import com.frostwire.mp3.InvalidDataException;

public abstract class AbstractID3v2FrameData {
    boolean unsynchronisation;

    public AbstractID3v2FrameData(boolean unsynchronisation) {
        this.unsynchronisation = unsynchronisation;
    }

    protected void synchroniseAndUnpackFrameData(byte[] bytes) throws InvalidDataException {
        if (this.unsynchronisation && BufferTools.sizeSynchronisationWouldSubtract(bytes) > 0) {
            byte[] synchronisedBytes = BufferTools.synchroniseBuffer(bytes);
            this.unpackFrameData(synchronisedBytes);
        } else {
            this.unpackFrameData(bytes);
        }
    }

    protected byte[] packAndUnsynchroniseFrameData() {
        byte[] bytes = this.packFrameData();
        if (this.unsynchronisation && BufferTools.sizeUnsynchronisationWouldAdd(bytes) > 0) {
            return BufferTools.unsynchroniseBuffer(bytes);
        }
        return bytes;
    }

    protected byte[] toBytes() {
        return this.packAndUnsynchroniseFrameData();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractID3v2FrameData)) {
            return false;
        }
        AbstractID3v2FrameData other = (AbstractID3v2FrameData)obj;
        return this.unsynchronisation == other.unsynchronisation;
    }

    protected abstract void unpackFrameData(byte[] var1) throws InvalidDataException;

    protected abstract byte[] packFrameData();

    protected abstract int getLength();
}

