/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent.alerts;

import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.announce_entry;
import com.frostwire.jlibtorrent.swig.announce_entry_vector;
import com.frostwire.jlibtorrent.swig.create_torrent;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.metadata_received_alert;
import com.frostwire.jlibtorrent.swig.string_vector;
import com.frostwire.jlibtorrent.swig.torrent_handle;
import com.frostwire.jlibtorrent.swig.torrent_info;
import java.util.concurrent.locks.ReentrantLock;

public final class MetadataReceivedAlert
extends TorrentAlert<metadata_received_alert> {
    private final ReentrantLock sync = new ReentrantLock();
    private int size;
    private byte[] data;
    private boolean invalid;

    MetadataReceivedAlert(metadata_received_alert alert2) {
        super(alert2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int metadataSize() {
        if (this.invalid) {
            return -1;
        }
        if (this.size > 0) {
            return this.size;
        }
        this.sync.lock();
        try {
            if (this.invalid) {
                int n = -1;
                return n;
            }
            if (this.size > 0) {
                int n = this.size;
                return n;
            }
            torrent_handle th = ((metadata_received_alert)this.alert).getHandle();
            if (th == null || !th.is_valid()) {
                this.invalid = true;
                int n = -1;
                return n;
            }
            torrent_info ti = th.torrent_file_ptr();
            if (ti == null || !ti.is_valid()) {
                this.invalid = true;
                int n = -1;
                return n;
            }
            this.size = ti.metadata_size();
        }
        catch (Throwable e) {
            this.invalid = true;
        }
        finally {
            this.sync.unlock();
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] torrentData(boolean extra) {
        if (this.invalid) {
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        this.sync.lock();
        try {
            if (this.invalid) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.data != null) {
                byte[] byArray = this.data;
                return byArray;
            }
            torrent_handle th = ((metadata_received_alert)this.alert).getHandle();
            if (th == null || !th.is_valid()) {
                this.invalid = true;
                byte[] byArray = null;
                return byArray;
            }
            torrent_info ti = th.torrent_file_ptr();
            if (ti == null || !ti.is_valid()) {
                this.invalid = true;
                byte[] byArray = null;
                return byArray;
            }
            this.size = ti.metadata_size();
            this.data = MetadataReceivedAlert.createTorrent(th, ti, extra);
        }
        catch (Throwable e) {
            this.invalid = true;
        }
        finally {
            this.sync.unlock();
        }
        return this.data;
    }

    public byte[] torrentData() {
        return this.torrentData(false);
    }

    private static byte[] createTorrent(torrent_handle th, torrent_info ti, boolean extra) {
        create_torrent ct = new create_torrent(ti);
        if (extra) {
            int i;
            string_vector v = th.get_url_seeds();
            int size = (int)v.size();
            for (i = 0; i < size; ++i) {
                ct.add_url_seed(v.get(i));
            }
            v = th.get_http_seeds();
            size = (int)v.size();
            for (i = 0; i < size; ++i) {
                ct.add_http_seed(v.get(i));
            }
            announce_entry_vector trackers = th.trackers();
            size = (int)trackers.size();
            for (int i2 = 0; i2 < size; ++i2) {
                announce_entry t = trackers.get(i2);
                ct.add_tracker(Vectors.byte_vector2ascii(t.get_url()), t.getTier());
            }
        }
        entry e = ct.generate();
        return Vectors.byte_vector2bytes(e.bencode());
    }
}

