/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.IntSeries;
import com.frostwire.jlibtorrent.Sha1Hash;
import com.frostwire.jlibtorrent.TorrentFlags;
import com.frostwire.jlibtorrent.TorrentStatus;
import com.frostwire.jlibtorrent.swig.torrent_status;

public final class TorrentStats {
    private final Sha1Hash ih;
    private final int maxSamples;
    private final IntSeries time;
    private final IntSeries downloadRateSeries;
    private final IntSeries uploadRateSeries;
    private long totalDownload;
    private long totalUpload;
    private long totalPayloadDownload;
    private long totalPayloadUpload;
    private long totalDone;
    private long totalWantedDone;
    private long totalWanted;
    private long allTimeUpload;
    private long allTimeDownload;
    private float progress;
    private int progressPpm;
    private int downloadRate;
    private int uploadRate;
    private int downloadPayloadRate;
    private int uploadPayloadRate;
    private int numSeeds;
    private int numPeers;
    private int listSeeds;
    private int listPeers;
    private int numPieces;
    private int numConnections;
    private TorrentStatus.State state;
    private boolean needSaveResume;
    private boolean isPaused;
    private boolean isSequentialDownload;
    private boolean isSeeding;
    private boolean isFinished;

    public TorrentStats(Sha1Hash infoHash, int maxSamples) {
        this.ih = infoHash.clone();
        this.maxSamples = maxSamples;
        this.time = new IntSeries(maxSamples);
        this.downloadRateSeries = new IntSeries(maxSamples);
        this.uploadRateSeries = new IntSeries(maxSamples);
    }

    public int maxSamples() {
        return this.maxSamples;
    }

    public IntSeries series(SeriesMetric metric) {
        switch (metric) {
            case TIME: {
                return this.time;
            }
            case DOWNLOAD_RATE: {
                return this.downloadRateSeries;
            }
            case UPLOAD_RATE: {
                return this.uploadRateSeries;
            }
        }
        throw new UnsupportedOperationException("metric type not supported");
    }

    public long last(SeriesMetric metric) {
        return this.series(metric).last();
    }

    public long totalDownload() {
        return this.totalDownload;
    }

    public long totalUpload() {
        return this.totalUpload;
    }

    public long totalPayloadDownload() {
        return this.totalPayloadDownload;
    }

    public long totalPayloadUpload() {
        return this.totalPayloadUpload;
    }

    public long totalDone() {
        return this.totalDone;
    }

    public long totalWantedDone() {
        return this.totalWantedDone;
    }

    public long totalWanted() {
        return this.totalWanted;
    }

    public long allTimeUpload() {
        return this.allTimeUpload;
    }

    public long allTimeDownload() {
        return this.allTimeDownload;
    }

    public float progress() {
        return this.progress;
    }

    public int progressPpm() {
        return this.progressPpm;
    }

    public int downloadRate() {
        return this.downloadRate;
    }

    public int uploadRate() {
        return this.uploadRate;
    }

    public int downloadPayloadRate() {
        return this.downloadPayloadRate;
    }

    public int uploadPayloadRate() {
        return this.uploadPayloadRate;
    }

    public int numSeeds() {
        return this.numSeeds;
    }

    public int numPeers() {
        return this.numPeers;
    }

    public int listSeeds() {
        return this.listSeeds;
    }

    public int listPeers() {
        return this.listPeers;
    }

    public int numPieces() {
        return this.numPieces;
    }

    public int numConnections() {
        return this.numConnections;
    }

    public TorrentStatus.State state() {
        return this.state;
    }

    public boolean needSaveResume() {
        return this.needSaveResume;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isSequentialDownload() {
        return this.isSequentialDownload;
    }

    public boolean isSeeding() {
        return this.isSeeding;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public void update(TorrentStatus status) {
        if (!this.ih.equals(status.infoHash())) {
            return;
        }
        this.time.add(System.currentTimeMillis());
        torrent_status st = status.swig();
        this.downloadRateSeries.add(st.getDownload_rate());
        this.uploadRateSeries.add(st.getUpload_rate());
        this.totalDownload = st.getTotal_download();
        this.totalUpload = st.getTotal_upload();
        this.totalPayloadDownload = st.getTotal_payload_download();
        this.totalPayloadUpload = st.getTotal_payload_upload();
        this.totalDone = st.getTotal_done();
        this.totalWantedDone = st.getTotal_wanted_done();
        this.totalWanted = st.getTotal_wanted();
        this.allTimeUpload = st.getAll_time_upload();
        this.allTimeDownload = st.getAll_time_download();
        this.progress = st.getProgress();
        this.progressPpm = st.getProgress_ppm();
        this.downloadRate = st.getDownload_rate();
        this.uploadRate = st.getUpload_rate();
        this.downloadPayloadRate = st.getDownload_payload_rate();
        this.uploadPayloadRate = st.getUpload_payload_rate();
        this.numSeeds = st.getNum_seeds();
        this.numPeers = st.getNum_peers();
        this.listSeeds = st.getList_seeds();
        this.listPeers = st.getList_peers();
        this.numPieces = st.getNum_pieces();
        this.numConnections = st.getNum_connections();
        this.state = status.state();
        this.needSaveResume = st.getNeed_save_resume();
        this.isPaused = st.getFlags().and_(TorrentFlags.PAUSED).nonZero();
        this.isSequentialDownload = st.getFlags().and_(TorrentFlags.SEQUENTIAL_DOWNLOAD).nonZero();
        this.isSeeding = st.getIs_seeding();
        this.isFinished = st.getIs_finished();
    }

    public static enum SeriesMetric {
        TIME,
        DOWNLOAD_RATE,
        UPLOAD_RATE;

    }
}

