/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.jlibtorrent;

import com.frostwire.jlibtorrent.Address;
import com.frostwire.jlibtorrent.swig.address;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.tcp_endpoint;

public final class TcpEndpoint
implements Cloneable {
    private final tcp_endpoint endp;

    public TcpEndpoint(tcp_endpoint endp) {
        this.endp = endp;
    }

    public TcpEndpoint() {
        this(new tcp_endpoint());
    }

    public TcpEndpoint(Address address2, int port) {
        this(new tcp_endpoint(address2.swig(), port));
    }

    public TcpEndpoint(String ip, int port) {
        error_code ec = new error_code();
        address addr = address.from_string(ip, ec);
        if (ec.value() != 0) {
            throw new IllegalArgumentException(ec.message());
        }
        this.endp = new tcp_endpoint(addr, port);
    }

    public tcp_endpoint swig() {
        return this.endp;
    }

    public Address address() {
        return new Address(this.endp.address());
    }

    public int port() {
        return this.endp.port();
    }

    public String toString() {
        address addr = this.endp.address();
        String s = Address.toString(addr);
        return (addr.is_v4() ? s : "[" + s + "]") + ":" + this.endp.port();
    }

    public TcpEndpoint clone() {
        return new TcpEndpoint(new tcp_endpoint(this.endp));
    }
}

