/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.UpdateManager;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.util.Logger;
import com.frostwire.uxstats.UXStats;
import com.frostwire.uxstats.UXStatsConf;
import com.limegroup.gnutella.gui.search.SearchEngine;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.limewire.util.OSUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class UpdateMessageReader
implements ContentHandler {
    private static final Logger LOG = Logger.getLogger(UpdateMessageReader.class);
    private static final String DEFAULT_UPDATE_URL = "http://update.frostwire.com";
    private HashSet<UpdateMessage> _announcements = null;
    private UpdateMessage _bufferMessage = null;
    private LinkedList<UpdateMessage> _overlays = null;
    private UpdateMessage _updateMessage = null;
    private String _updateURL = "http://update.frostwire.com";

    UpdateMessageReader() {
    }

    private void addAnnouncement(UpdateMessage msg) {
        if (this._announcements == null) {
            this._announcements = new HashSet();
        }
        if (msg.getMessageType().equals("announcement") && !msg.hasExpired()) {
            this._announcements.add(msg);
        }
    }

    private void addOverlay(UpdateMessage msg) {
        if (msg != null && msg.getMessageType().equals("overlay")) {
            if (this._overlays == null) {
                this._overlays = new LinkedList();
            }
            if (!this._overlays.isEmpty()) {
                for (UpdateMessage m : this._overlays) {
                    if (m.isIntro() != msg.isIntro()) continue;
                    this._overlays.remove(m);
                    this._overlays.add(msg);
                    return;
                }
            }
            this._overlays.add(msg);
        } else {
            System.out.println("UpdateManager.addOverlay() - The message given wasn't good.");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXException {
        if (!this.isMessageForMe(this._bufferMessage)) {
            this._bufferMessage = null;
            return;
        }
        if (this._bufferMessage != null && name.equalsIgnoreCase("message")) {
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("update")) {
                this.setUpdateMessage(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                this.addAnnouncement(this._bufferMessage);
            } else if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                this.addOverlay(this._bufferMessage);
            }
            this._bufferMessage = null;
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    HashSet<UpdateMessage> getAnnouncements() {
        return this._announcements;
    }

    UpdateMessage getUpdateMessage() {
        return this._updateMessage;
    }

    private String getUpdateURL() {
        return this._updateURL;
    }

    boolean hasAnnouncements() {
        return this._announcements != null && this._announcements.size() > 0;
    }

    boolean hasUpdateMessage() {
        return this._updateMessage != null;
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    private boolean isMessageEligibleForMyLang(UpdateMessage msg) {
        String langinmsg = msg.getLanguage();
        if (langinmsg == null || langinmsg.equals("*")) {
            return true;
        }
        String langinapp = ApplicationSettings.getLanguage().toLowerCase();
        if (langinmsg.length() == 2) {
            return langinapp.toLowerCase().startsWith(langinmsg.toLowerCase());
        }
        if (langinmsg.endsWith("*")) {
            langinapp = ApplicationSettings.getLanguage().substring(0, 2);
            langinmsg = langinmsg.substring(0, langinmsg.indexOf("*"));
        }
        return langinmsg.equalsIgnoreCase(langinapp);
    }

    private boolean isMessageEligibleForMyOs(UpdateMessage msg) {
        if (msg.getOs() == null) {
            return true;
        }
        boolean im_mac_msg_for_me = msg.getOs().equals("mac") && OSUtils.isMacOSX();
        boolean im_windows_msg_for_me = msg.getOs().equals("windows") && (OSUtils.isWindows() || OSUtils.isWindowsXP() || OSUtils.isWindowsNT() || OSUtils.isWindows98() || OSUtils.isWindows95() || OSUtils.isWindowsMe() || OSUtils.isWindowsVista());
        boolean im_linux_msg_for_me = msg.getOs().equals("linux") && OSUtils.isLinux();
        return im_mac_msg_for_me || im_windows_msg_for_me || im_linux_msg_for_me;
    }

    private boolean isMessageEligibleForMyVersion(UpdateMessage msg) {
        return msg.getVersion() == null || msg.getMessageType().equalsIgnoreCase("update") || !UpdateManager.isFrostWireOld(msg);
    }

    private boolean isMessageForMe(UpdateMessage msg) {
        if (msg == null) {
            return false;
        }
        return this.isMessageEligibleForMyOs(msg) && this.isMessageEligibleForMyLang(msg) && this.isMessageEligibleForMyVersion(msg);
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readUpdateFile() {
        URLConnection connection = null;
        try {
            String userAgent = "FrostWire/" + OSUtils.getOS() + "-" + OSUtils.getArchitecture() + "/" + FrostWireUtils.getFrostWireVersion() + "/build-" + FrostWireUtils.getBuildNumber();
            connection = (HttpURLConnection)new URL(this.getUpdateURL()).openConnection();
            connection.setRequestProperty("User-Agent", userAgent);
            connection.setRequestProperty("Connection", "close");
            connection.setReadTimeout(10000);
            if (((HttpURLConnection)connection).getResponseCode() >= 400) {
                ((HttpURLConnection)connection).disconnect();
                return;
            }
            InputSource src = new InputSource(connection.getInputStream());
            XMLReader rdr = XMLReaderFactory.createXMLReader("com.sun.org.apache.xerces.internal.parsers.SAXParser");
            rdr.setContentHandler(this);
            rdr.parse(src);
        }
        catch (SocketTimeoutException e3) {
            System.err.println("UpdateMessageReader.readUpdateFile() Socket Timeout Exception " + e3.toString());
        }
        catch (IOException e) {
            System.err.println("UpdateMessageReader.readUpdateFile() IO exception " + e.toString());
        }
        catch (SAXException e2) {
            System.err.println("UpdateMessageReader.readUpdateFile() SAX exception " + e2.toString());
        }
        finally {
            if (connection != null) {
                try {
                    connection.getInputStream().close();
                    ((HttpURLConnection)connection).disconnect();
                }
                catch (Throwable e3) {}
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    private void setUpdateMessage(UpdateMessage msg) {
        if (this._updateMessage == null && msg != null && msg.getMessageType().equals("update")) {
            this._updateMessage = msg;
        }
    }

    void setUpdateURL(String updateURL) {
        this._updateURL = updateURL == null ? DEFAULT_UPDATE_URL : updateURL;
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (localName.equalsIgnoreCase("update")) {
            UpdateManager.getInstance().setServerTime(atts.getValue("time"));
            if (atts.getValue("torrentDetailsUrl") != null && atts.getValue("torrentDetailsUrl").length() > 0) {
                String torrentDetailsUrl = atts.getValue("torrentDetailsUrl");
                List<SearchEngine> searchEngines = SearchEngine.getEngines();
                for (SearchEngine searchEngine : searchEngines) {
                    searchEngine.redirectUrl = torrentDetailsUrl;
                }
            }
        } else if (localName.equalsIgnoreCase("message")) {
            String type = atts.getValue("type");
            String message = atts.getValue("value");
            String url = atts.getValue("url");
            String torrent = atts.getValue("torrent");
            String installerUrl = atts.getValue("installerUrl");
            String os = atts.getValue("os");
            String showOnce = atts.getValue("showOnce");
            String version = atts.getValue("version");
            String build = atts.getValue("build");
            String src = atts.getValue("src");
            String saveAs = atts.getValue("saveAs");
            this._bufferMessage = new UpdateMessage(type, message);
            this._bufferMessage.setUrl(url);
            this._bufferMessage.setTorrent(torrent);
            this._bufferMessage.setInstallerUrl(installerUrl);
            this._bufferMessage.setOs(os);
            this._bufferMessage.setShowOnce(showOnce);
            this._bufferMessage.setVersion(version);
            this._bufferMessage.setBuild(build);
            this._bufferMessage.setSaveAs(saveAs);
            if (atts.getValue("md5") != null) {
                this._bufferMessage.setRemoteMD5(atts.getValue("md5"));
            }
            if (atts.getValue("language") != null) {
                this._bufferMessage.setLanguage(atts.getValue("language"));
            }
            if (atts.getValue("valueInstallerReady") != null) {
                this._bufferMessage.setMessageInstallerReady(atts.getValue("valueInstallerReady"));
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("announcement")) {
                this._bufferMessage.setExpiration(atts.getValue("expiration"));
            }
            if (this._bufferMessage.getMessageType().equalsIgnoreCase("overlay")) {
                this._bufferMessage.setSrc(src);
                if (atts.getValue("intro") != null && (atts.getValue("intro").equals("1") || atts.getValue("intro").equalsIgnoreCase("true") || atts.getValue("intro").equalsIgnoreCase("yes"))) {
                    this._bufferMessage.setIntro(true);
                } else {
                    this._bufferMessage.setIntro(false);
                }
            }
            if (this._bufferMessage.getMessageType().equals("uxstats")) {
                this.processUXStatsMsg(atts);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private void processUXStatsMsg(Attributes atts) {
        try {
            String enabled = atts.getValue("enabled");
            if (enabled != null && enabled.equals("true") && ApplicationSettings.UX_STATS_ENABLED.getValue()) {
                String url = "http://ux.frostwire.com/dux";
                String os = OSUtils.getFullOS();
                String fwversion = FrostWireUtils.getFrostWireVersion();
                String fwbuild = String.valueOf(FrostWireUtils.getBuildNumber());
                int period = Integer.parseInt(atts.getValue("period"));
                int minEntries = Integer.parseInt(atts.getValue("minEntries"));
                int maxEntries = Integer.parseInt(atts.getValue("maxEntries"));
                UXStatsConf context = new UXStatsConf(url, os, fwversion, fwbuild, period, minEntries, maxEntries);
                UXStats.instance().setContext(context);
            }
        }
        catch (Throwable e) {
            LOG.warn("Unable to process uxstats message from server", e);
        }
    }
}

