/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.updates;

import com.frostwire.gui.updates.InstallerUpdater;
import com.frostwire.gui.updates.UpdateMediator;
import com.frostwire.gui.updates.UpdateMessage;
import com.frostwire.gui.updates.UpdateMessageReader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public final class UpdateManager
implements Serializable {
    private static final int OPTION_OPEN_URL = 1;
    private static final int OPTION_LATER = 0;
    private static final int OPTION_DOWNLOAD_TORRENT = 2;
    private static transient HashSet<UpdateMessage> _seenMessages;
    private static UpdateManager INSTANCE;
    private Date _serverTime = null;

    private static void scheduleUpdateCheckTask(final int secondsAfter, final String updateURL, final boolean force) {
        Runnable checkForUpdatesTask = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(secondsAfter * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                UpdateManager um = UpdateManager.getInstance();
                um.checkForUpdates(updateURL, force);
            }
        };
        new Thread(checkForUpdatesTask).start();
    }

    public static void scheduleUpdateCheckTask(int secondsAfter) {
        UpdateManager.scheduleUpdateCheckTask(secondsAfter, false);
    }

    static void scheduleUpdateCheckTask(int secondsAfter, boolean force) {
        UpdateManager.scheduleUpdateCheckTask(secondsAfter, null, force);
    }

    private UpdateManager() {
    }

    void setServerTime(String serverTime) {
        this._serverTime = null;
        try {
            this._serverTime = new Date(Long.parseLong(serverTime));
        }
        catch (Exception e) {
            System.out.println("Warning: UpdateManager.setServerTime(): Could not set time from server, using local time");
        }
        if (this._serverTime == null) {
            this._serverTime = Calendar.getInstance().getTime();
        }
    }

    Date getServerTime() {
        return this._serverTime;
    }

    private void checkForUpdates(String updateURL, boolean force) {
        UpdateMessageReader umr = new UpdateMessageReader();
        umr.setUpdateURL(updateURL);
        umr.readUpdateFile();
        this.handlePossibleUpdateMessage(umr, force);
        if (umr.hasAnnouncements()) {
            this.attemptShowAnnouncements(umr.getAnnouncements());
        }
    }

    private void handlePossibleUpdateMessage(UpdateMessageReader umr, boolean force) {
        boolean forceUpdateMessage;
        UpdateMessage updateMessage = umr.getUpdateMessage();
        if (updateMessage == null) {
            return;
        }
        UpdateMediator.instance().setUpdateMessage(updateMessage);
        boolean bl = forceUpdateMessage = System.getenv().get("FROSTWIRE_FORCE_UPDATE_MESSAGE") != null;
        if (umr.hasUpdateMessage() && (updateMessage.getBuild() != null && !updateMessage.getBuild().trim().equals("") || updateMessage.getVersion() != null && !updateMessage.getVersion().trim().equals("")) && (forceUpdateMessage || UpdateManager.isFrostWireOld(updateMessage))) {
            boolean hasInstallerUrl;
            boolean hasUrl = updateMessage.getUrl() != null;
            boolean hasTorrent = updateMessage.getTorrent() != null;
            boolean bl2 = hasInstallerUrl = updateMessage.getInstallerUrl() != null;
            if (forceUpdateMessage) {
                System.out.println("FROSTWIRE_FORCE_UPDATE_MESSAGE env found, testing update message. (turn off with `unset FROSTWIRE_FORCE_UPDATE_MESSAGE`)");
            }
            if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
                if (hasUrl && !hasTorrent && !hasInstallerUrl) {
                    this.showUpdateMessage(updateMessage);
                } else if (hasTorrent || hasInstallerUrl) {
                    new InstallerUpdater(updateMessage, force).start();
                }
            } else if (OSUtils.isLinux()) {
                if (OSUtils.isUbuntu()) {
                    if (hasTorrent || hasInstallerUrl) {
                        new InstallerUpdater(updateMessage, force).start();
                    } else {
                        this.showUpdateMessage(updateMessage);
                    }
                } else if (hasUrl) {
                    this.showUpdateMessage(updateMessage);
                }
            }
        }
    }

    private void showUpdateMessage(final UpdateMessage msg) {
        final String title = msg.getMessageType().equals("update") ? I18n.tr("New FrostWire Update Available") : I18n.tr("FrostWire Team Announcement");
        int optionType = 2;
        if (msg.getUrl() != null && !msg.getUrl().trim().equals("")) {
            System.out.println("\t" + msg.getUrl());
            optionType |= 0;
        }
        String[] options = new String[3];
        if (msg.getTorrent() != null) {
            options[2] = I18n.tr("Download Torrent");
        } else {
            options = new String[]{I18n.tr("Thanks, but not now"), I18n.tr("Go to webpage")};
        }
        final int finalOptionType = optionType;
        final String[] finalOptions = options;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int result = JOptionPane.showOptionDialog(null, msg.getMessage(), title, finalOptionType, 1, null, finalOptions, null);
                if (result == 1) {
                    GUIMediator.openURL(msg.getUrl());
                } else if (result == 2) {
                    UpdateManager.openTorrent(msg.getTorrent());
                }
            }
        });
    }

    private void attemptShowAnnouncements(HashSet<UpdateMessage> announcements) {
        for (UpdateMessage msg : announcements) {
            if (msg.isShownOnce() && this.haveShownMessageBefore(msg) || msg.getUrl() == null || msg.getUrl().trim().equals("")) continue;
            this.showUpdateMessage(msg);
        }
    }

    private void loadSeenMessages() {
        File f = new File(CommonUtils.getUserSettingsDir(), "seenMessages.dat");
        _seenMessages = new HashSet();
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                System.out.println("UpdateManager.loadSeenMessages() - Cannot create file to deserialize");
            }
            return;
        }
        if (f.length() == 0L) {
            return;
        }
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            _seenMessages = (HashSet)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            System.out.println("UpdateManager.loadSeenMessages() - Cannot deserialize - ");
            System.out.println(e);
        }
    }

    private void saveSeenMessages() {
        if (_seenMessages == null || _seenMessages.size() < 1) {
            return;
        }
        File f = new File(CommonUtils.getUserSettingsDir(), "seenMessages.dat");
        if (!f.exists()) {
            try {
                f.createNewFile();
            }
            catch (Exception e) {
                System.out.println("UpdateManager.saveSeenMessages() cannot create file to serialize seen messages");
            }
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(_seenMessages);
            oos.close();
        }
        catch (Exception e) {
            System.out.println("UpdateManager.saveSeenMessages() - Cannot serialize.");
            e.printStackTrace();
        }
    }

    private boolean haveShownMessageBefore(UpdateMessage msg) {
        if (!msg.isShownOnce()) {
            return false;
        }
        this.loadSeenMessages();
        if (_seenMessages == null || _seenMessages.size() == 0 || !_seenMessages.contains(msg)) {
            if (_seenMessages == null) {
                _seenMessages = new HashSet();
            }
            _seenMessages.add(msg);
            this.saveSeenMessages();
            return false;
        }
        return true;
    }

    static boolean isFrostWireOld(UpdateMessage message) {
        if (message.getBuild() != null) {
            try {
                int buildNumber = Integer.parseInt(message.getBuild());
                return buildNumber > FrostWireUtils.getBuildNumber();
            }
            catch (Throwable t) {
                System.err.println("UpdateManager::isFrostWireOld() invalid buildNumber ('" + message.getBuild() + "'), falling back to version check");
                t.printStackTrace();
            }
        }
        return UpdateManager.isFrostWireOld(message.getVersion());
    }

    private static boolean isFrostWireOld(String messageVersion) {
        if (messageVersion == null) {
            return false;
        }
        String currentVersion = FrostWireUtils.getFrostWireVersion();
        if (currentVersion.equals(messageVersion)) {
            return false;
        }
        try {
            String[] fwVersionParts = currentVersion.split("\\.");
            int fw_major = Integer.parseInt(fwVersionParts[0]);
            int fw_release = Integer.parseInt(fwVersionParts[1]);
            int fw_service = Integer.parseInt(fwVersionParts[2]);
            String[] msgVersionParts = messageVersion.split("\\.");
            int msg_major = Integer.parseInt(msgVersionParts[0]);
            int msg_release = Integer.parseInt(msgVersionParts[1]);
            int msg_service = Integer.parseInt(msgVersionParts[2]);
            if (fw_major < msg_major) {
                return true;
            }
            if (fw_major == msg_major && fw_release < msg_release) {
                return true;
            }
            if (fw_major == msg_major && fw_release == msg_release && fw_service < msg_service) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static synchronized UpdateManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new UpdateManager();
        }
        return INSTANCE;
    }

    private static void openTorrent(String uriStr) {
        try {
            URI uri = new URI(uriStr);
            String scheme = uri.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http")) {
                return;
            }
            String authority = uri.getAuthority();
            if (authority == null || authority.equals("") || authority.indexOf(32) != -1) {
                return;
            }
            GUIMediator.instance().openTorrentURI(uri.toString(), false);
        }
        catch (URISyntaxException e) {
            System.out.println(e);
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
    }

    static {
        INSTANCE = null;
    }
}

