/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.AbstractSkinPainter;
import com.frostwire.gui.theme.SkinColors;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SkinScrollBarButtonPainter
extends AbstractSkinPainter {
    private final State state;

    public SkinScrollBarButtonPainter(State state) {
        this.state = state;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        this.paintBox(g, width, height);
        this.paintArrowButton(g, (double)width / 2.0 - 4.0, (double)height / 2.0 - 4.0);
    }

    private void paintBox(Graphics2D g, int width, int height) {
        if (this.testValid(0, 0, width - 1, height)) {
            Shape s = this.shapeGenerator.createRectangle(0, 0, width - 1, height);
            g.setPaint(this.getScrollBarButtonBoxPaint(s));
            g.fill(s);
            g.setPaint(this.getScrollBarButtonBoxBorderColor());
            g.draw(s);
        }
    }

    private void paintArrowButton(Graphics2D g, double x, double y) {
        Shape s = this.shapeGenerator.createArrowLeft(x, y, 7.0, 8.0);
        g.setPaint(this.getScrollBarButtonArrowColor());
        g.fill(s);
    }

    private Color getScrollBarButtonArrowColor() {
        switch (this.state) {
            case Disabled: {
                return SkinColors.SCROLL_BUTTON_ARROW_DISABLED_COLOR;
            }
            case Enabled: {
                return SkinColors.SCROLL_BUTTON_ARROW_ENABLED_COLOR;
            }
            case MouseOver: {
                return SkinColors.SCROLL_BUTTON_ARROW_ENABLED_COLOR;
            }
            case Pressed: {
                return SkinColors.SCROLL_BUTTON_ARROW_ENABLED_COLOR;
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    private Paint getScrollBarButtonBoxPaint(Shape s) {
        switch (this.state) {
            case Disabled: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_BUTTON_ARROW_BOX_DISABLED_COLORS);
            }
            case Enabled: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_BUTTON_ARROW_BOX_ENABLED_COLORS);
            }
            case MouseOver: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_BUTTON_ARROW_BOX_MOUSEOVER_COLORS);
            }
            case Pressed: {
                return this.createVerticalGradient(s, SkinColors.SCROLL_BUTTON_ARROW_BOX_PRESSED_COLORS);
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    private Paint getScrollBarButtonBoxBorderColor() {
        switch (this.state) {
            case Disabled: {
                return SkinColors.SCROLL_BUTTON_ARROW_BOX_BORDER_COLOR;
            }
            case Enabled: {
                return SkinColors.SCROLL_BUTTON_ARROW_BOX_BORDER_COLOR;
            }
            case MouseOver: {
                return SkinColors.SCROLL_BUTTON_ARROW_BOX_BORDER_COLOR;
            }
            case Pressed: {
                return SkinColors.SCROLL_BUTTON_ARROW_BOX_BORDER_COLOR;
            }
        }
        throw new IllegalArgumentException("Not supported state");
    }

    public static enum State {
        Disabled,
        Enabled,
        MouseOver,
        Pressed;

    }
}

