/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;

public final class ShapeGenerator {
    private static final double baseRadius = 4.0;
    private final Path2D path = new Path2D.Double(0);
    private final Ellipse2D ellipse = new Ellipse2D.Float();

    public Shape createRectangle(int x, int y, int w, int h) {
        return this.createRoundRectangleInternal(x, y, w, h, 0.0, CornerStyle.SQUARE, CornerStyle.SQUARE, CornerStyle.SQUARE, CornerStyle.SQUARE);
    }

    public Shape createRoundRectangle(int x, int y, int w, int h, CornerSize size) {
        return this.createRoundRectangle(x, y, w, h, size, CornerStyle.ROUNDED, CornerStyle.ROUNDED, CornerStyle.ROUNDED, CornerStyle.ROUNDED);
    }

    public Shape createRoundRectangle(int x, int y, int w, int h, CornerSize size, CornerStyle topLeft, CornerStyle bottomLeft, CornerStyle bottomRight, CornerStyle topRight) {
        return this.createRoundRectangleInternal(x, y, w, h, size.getRadius(w, h), topLeft, bottomLeft, bottomRight, topRight);
    }

    public Shape createOpenRectangle(int x, int y, int w, int h) {
        this.path.reset();
        this.path.moveTo(x + w, y);
        this.path.lineTo(x, y);
        this.path.lineTo(x, y + h);
        this.path.lineTo(x + w, y + h);
        return this.path;
    }

    public Shape createCheckMark(int x, int y, int w, int h) {
        double xf = (double)w / 12.0;
        double hf = (double)h / 12.0;
        this.path.reset();
        this.path.moveTo(x, (double)y + 7.0 * hf);
        this.path.lineTo((double)x + 2.0 * xf, (double)y + 7.0 * hf);
        this.path.lineTo((double)x + 4.75 * xf, (double)y + 10.0 * hf);
        this.path.lineTo((double)x + 9.0 * xf, y);
        this.path.lineTo((double)x + 11.0 * xf, y);
        this.path.lineTo((double)x + 5.0 * xf, (double)y + 12.0 * hf);
        this.path.closePath();
        return this.path;
    }

    public Shape createArrowLeft(double x, double y, double w, double h) {
        this.path.reset();
        this.path.moveTo(x + w, y);
        this.path.lineTo(x, y + h / 2.0);
        this.path.lineTo(x + w, y + h);
        this.path.closePath();
        return this.path;
    }

    public Shape createArrowRight(double x, double y, double w, double h) {
        this.path.reset();
        this.path.moveTo(x, y);
        this.path.lineTo(x + w, y + h / 2.0);
        this.path.lineTo(x, y + h);
        this.path.closePath();
        return this.path;
    }

    public Shape createArrowUp(double x, double y, double w, double h) {
        this.path.reset();
        this.path.moveTo(x, y + h);
        this.path.lineTo(x + w / 2.0, y);
        this.path.lineTo(x + w, y + h);
        this.path.closePath();
        return this.path;
    }

    public Shape createArrowDown(double x, double y, double w, double h) {
        this.path.reset();
        this.path.moveTo(x, y);
        this.path.lineTo(x + w / 2.0, y + h);
        this.path.lineTo(x + w, y);
        this.path.closePath();
        return this.path;
    }

    public Shape createProgressBarIndeterminatePattern(int x, int y, int w, int h) {
        double wHalf = (double)w / 2.0;
        double xOffset = 5.0;
        this.path.reset();
        this.path.moveTo(5.0, 0.0);
        this.path.lineTo(5.0 + wHalf, 0.0);
        this.path.curveTo(5.0 + wHalf - 5.0, h / 2 - 4, 5.0 + wHalf + 5.0, h / 2 + 4, 5.0 + wHalf, h);
        this.path.lineTo(5.0, h);
        this.path.curveTo(10.0, h / 2 + 4, 0.0, h / 2 - 4, 5.0, 0.0);
        this.path.closePath();
        return this.path;
    }

    public Shape createInternalDropShadowRounded(int x, int y, int w, int h) {
        double radius = h / 2;
        int right = x + w;
        double bottom = (double)y + radius;
        this.path.reset();
        this.path.moveTo(x, bottom);
        this.path.quadTo(x, y, (double)x + radius, y);
        this.path.lineTo((double)right - radius, y);
        this.path.quadTo(right, y, right, bottom);
        this.path.lineTo(right - 1, bottom);
        this.path.quadTo(right - 2, y + 2, (double)right - radius - 1.0, y + 2);
        this.path.lineTo((double)x + radius + 1.0, y + 2);
        this.path.quadTo(x + 2, y + 2, x + 1, bottom);
        this.path.closePath();
        return this.path;
    }

    public Shape createFillableFocusRectangle(int x, int y, int w, int h) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        this.path.reset();
        this.path.moveTo(left, top);
        this.path.lineTo(left, bottom);
        this.path.lineTo(right, bottom);
        this.path.lineTo(right, top);
        float offset = 1.4f;
        float left2 = (float)left + 1.4f;
        float top2 = (float)top + 1.4f;
        float right2 = (float)right - 1.4f;
        float bottom2 = (float)bottom - 1.4f;
        this.path.lineTo(right2, top);
        this.path.lineTo(right2, bottom2);
        this.path.lineTo(left2, bottom2);
        this.path.lineTo(left2, top2);
        this.path.lineTo(right2, top2);
        this.path.lineTo(right2, top);
        this.path.closePath();
        return this.path;
    }

    public Shape createBullet(int x, int y, int diameter) {
        return this.createEllipseInternal(x, y, diameter, diameter);
    }

    public Shape createRadioButton(int x, int y, int diameter) {
        return this.createEllipseInternal(x, y, diameter, diameter);
    }

    public Shape createSliderThumbContinuous(int x, int y, int diameter) {
        return this.createEllipseInternal(x, y, diameter, diameter);
    }

    public Shape createSliderThumbDiscrete(int x, int y, int w, int h, CornerSize size) {
        double topArc = size.getRadius(w, h);
        double bottomArcH = size == CornerSize.INTERIOR ? 0.0 : 1.0;
        double bottomArcW = 3.0;
        this.path.reset();
        this.path.moveTo(x, (double)y + topArc);
        this.path.quadTo(x, y, (double)x + topArc, y);
        this.path.lineTo((double)(x + w) - topArc, y);
        this.path.quadTo(x + w, y, x + w, (double)y + topArc);
        this.path.lineTo(x + w, (double)y + (double)h / 2.0);
        this.path.quadTo((double)(x + w) - 3.0, (double)(y + h) - bottomArcH, (double)x + (double)w / 2.0, y + h);
        this.path.quadTo((double)x + 3.0, (double)(y + h) - bottomArcH, x, (double)y + (double)h / 2.0);
        this.path.closePath();
        return this.path;
    }

    public Shape createCancelIcon(int x, int y, int w, int h) {
        double xMid = (double)x + (double)w / 2.0;
        double yMid = (double)y + (double)h / 2.0;
        this.path.reset();
        this.path.moveTo(xMid, y);
        this.path.quadTo(x, y, x, yMid);
        this.path.quadTo(x, y + h, xMid, y + h);
        this.path.quadTo(x + w, y + h, x + w, yMid);
        this.path.quadTo(x + w, y, xMid, y);
        this.path.closePath();
        double xOffsetL = (double)w / 2.0 - 3.0;
        double xOffsetS = (double)w / 2.0 - 4.0;
        double yOffsetL = (double)h / 2.0 - 3.0;
        double yOffsetS = (double)h / 2.0 - 4.0;
        double offsetC = 1.5;
        this.path.moveTo(xMid, yMid - 1.5);
        this.path.lineTo(xMid + xOffsetS, yMid - yOffsetL);
        this.path.lineTo(yMid + xOffsetL, yMid - yOffsetS);
        this.path.lineTo(xMid + 1.5, yMid);
        this.path.lineTo(xMid + xOffsetL, yMid + yOffsetS);
        this.path.lineTo(xMid + xOffsetS, yMid + yOffsetL);
        this.path.lineTo(xMid, yMid + 1.5);
        this.path.lineTo(xMid - xOffsetS, yMid + yOffsetL);
        this.path.lineTo(xMid - xOffsetL, yMid + yOffsetS);
        this.path.lineTo(xMid - 1.5, yMid);
        this.path.lineTo(xMid - xOffsetL, yMid - yOffsetS);
        this.path.lineTo(xMid - xOffsetS, yMid - yOffsetL);
        this.path.closePath();
        return this.path;
    }

    public Shape createTabCloseIcon(int x, int y, int w, int h) {
        double xMid = (double)x + (double)w / 2.0;
        double yMid = (double)y + (double)h / 2.0;
        this.path.reset();
        double xOffsetL = (double)w / 2.0;
        double xOffsetS = (double)w / 2.0 - 1.0;
        double yOffsetL = (double)h / 2.0;
        double yOffsetS = (double)h / 2.0 - 1.0;
        double offsetC = 1.0;
        this.path.moveTo(xMid, yMid - 1.0);
        this.path.lineTo(xMid + xOffsetS, yMid - yOffsetL);
        this.path.lineTo(yMid + xOffsetL, yMid - yOffsetS);
        this.path.lineTo(xMid + 1.0, yMid);
        this.path.lineTo(xMid + xOffsetL, yMid + yOffsetS);
        this.path.lineTo(xMid + xOffsetS, yMid + yOffsetL);
        this.path.lineTo(xMid, yMid + 1.0);
        this.path.lineTo(xMid - xOffsetS, yMid + yOffsetL);
        this.path.lineTo(xMid - xOffsetL, yMid + yOffsetS);
        this.path.lineTo(xMid - 1.0, yMid);
        this.path.lineTo(xMid - xOffsetL, yMid - yOffsetS);
        this.path.lineTo(xMid - xOffsetS, yMid - yOffsetL);
        this.path.closePath();
        return this.path;
    }

    public Shape createScrollCap(int x, int y, int w, int h) {
        this.path.reset();
        this.path.moveTo(x, y);
        this.path.lineTo(x, y + h);
        this.path.lineTo(x + w, y + h);
        this.addScrollGapPath(x, y, w, h, true);
        this.path.closePath();
        return this.path;
    }

    public Shape createScrollButtonApart(int x, int y, int w, int h) {
        this.path.reset();
        this.path.moveTo(x, y);
        this.path.lineTo(x, y + h);
        this.path.lineTo(x + w, y + h);
        this.addScrollGapPath(x, y, w, h, true);
        this.path.closePath();
        return this.path;
    }

    public Shape createScrollButtonTogetherDecrease(int x, int y, int w, int h) {
        this.path.reset();
        this.path.moveTo(x + w, y);
        this.path.lineTo(x + w, y + h);
        this.path.lineTo(x, y + h);
        this.addScrollGapPath(x, y, w, h, false);
        this.path.closePath();
        return this.path;
    }

    public Shape createScrollButtonTogetherIncrease(int x, int y, int w, int h) {
        return this.createRectangle(x, y, w, h);
    }

    private void addScrollGapPath(int x, int y, int w, int h, boolean isAtLeft) {
        double hHalf = (double)h / 2.0;
        double wFull = isAtLeft ? (double)w : 0.0;
        double wHalfOff = isAtLeft ? (double)w - hHalf : hHalf;
        this.path.quadTo((double)x + wHalfOff, y + h, (double)x + wHalfOff, (double)y + hHalf);
        this.path.quadTo((double)x + wHalfOff, y, (double)x + wFull, y);
    }

    private Shape createEllipseInternal(int x, int y, int w, int h) {
        this.ellipse.setFrame(x, y, w, h);
        return this.ellipse;
    }

    private Shape createRoundRectangleInternal(int x, int y, int w, int h, double radius, CornerStyle topLeft, CornerStyle bottomLeft, CornerStyle bottomRight, CornerStyle topRight) {
        int left = x;
        int top = y;
        int right = x + w;
        int bottom = y + h;
        this.path.reset();
        switch (topLeft) {
            case SQUARE: {
                this.path.moveTo(left, top);
                break;
            }
            case ROUNDED: {
                this.path.moveTo((double)left + radius, top);
                this.path.quadTo(left, top, left, (double)top + radius);
            }
        }
        switch (bottomLeft) {
            case SQUARE: {
                this.path.lineTo(left, bottom);
                break;
            }
            case ROUNDED: {
                this.path.lineTo(left, (double)bottom - radius);
                this.path.quadTo(left, bottom, (double)left + radius, bottom);
            }
        }
        switch (bottomRight) {
            case SQUARE: {
                this.path.lineTo(right, bottom);
                break;
            }
            case ROUNDED: {
                this.path.lineTo((double)right - radius, bottom);
                this.path.quadTo(right, bottom, right, (double)bottom - radius);
            }
        }
        switch (topRight) {
            case SQUARE: {
                this.path.lineTo(right, top);
                break;
            }
            case ROUNDED: {
                this.path.lineTo(right, (double)top + radius);
                this.path.quadTo(right, top, (double)right - radius, top);
            }
        }
        this.path.closePath();
        return this.path;
    }

    public static enum CornerSize {
        ROUND_HEIGHT(0.0),
        ROUND_HEIGHT_DRAW(0.0),
        ROUND_WIDTH(0.0),
        ROUND_WIDTH_DRAW(0.0),
        INTERIOR(3.0),
        BORDER(4.0),
        INNER_FOCUS(5.0),
        OUTER_FOCUS(6.0),
        SLIDER_INTERIOR(2.0),
        SLIDER_BORDER(3.0),
        SLIDER_INNER_FOCUS(4.0),
        SLIDER_OUTER_FOCUS(5.0),
        CHECKBOX_INTERIOR(2.0),
        CHECKBOX_BORDER(2.5),
        CHECKBOX_INNER_FOCUS(3.0),
        CHECKBOX_OUTER_FOCUS(3.5),
        POPUP_BORDER(3.0),
        POPUP_INTERIOR(2.5),
        FRAME_BORDER(5.0),
        FRAME_INNER_HIGHLIGHT(4.0),
        FRAME_INTERIOR(3.0);

        private double radius;

        private CornerSize(double radius) {
            this.radius = radius;
        }

        public double getRadius(int w, int h) {
            switch (this) {
                case ROUND_HEIGHT: {
                    return (double)h / 2.0;
                }
                case ROUND_HEIGHT_DRAW: {
                    return (double)(h + 1) / 2.0;
                }
                case ROUND_WIDTH: {
                    return (double)w / 2.0;
                }
                case ROUND_WIDTH_DRAW: {
                    return (double)(w + 1) / 2.0;
                }
            }
            return this.radius;
        }
    }

    public static enum CornerStyle {
        SQUARE,
        ROUNDED;

    }
}

