/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.theme;

import com.frostwire.gui.theme.FilePane;
import com.frostwire.gui.theme.FilePaneEx;
import com.frostwire.gui.theme.ShellFolder;
import com.frostwire.gui.theme.ThemeMediator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.plaf.basic.BasicFileChooserUI;
import org.limewire.util.OSUtils;

public class BaseFileChooserUI
extends BasicFileChooserUI {
    private JLabel lookInLabel;
    private JComboBox<Object> directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField fileNameTextField;
    private FilePaneEx filePane;
    private JToggleButton listViewButton;
    private JToggleButton detailsViewButton;
    private boolean useShellFolder;
    private JButton approveButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JPanel bottomPanel;
    private JComboBox<Object> filterComboBox;
    private static final Dimension hstrut5 = new Dimension(5, 1);
    private static final Dimension vstrut5 = new Dimension(1, 5);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 326;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 500;
    private static int MIN_HEIGHT = 326;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_PREF_WIDTH = 405;
    private static int LIST_PREF_HEIGHT = 135;
    private static Dimension LIST_PREF_SIZE = new Dimension(LIST_PREF_WIDTH, LIST_PREF_HEIGHT);
    private int lookInLabelMnemonic = 0;
    private String lookInLabelText = null;
    private String saveInLabelText = null;
    private int fileNameLabelMnemonic = 0;
    private String fileNameLabelText = null;
    private int folderNameLabelMnemonic = 0;
    private String folderNameLabelText = null;
    private int filesOfTypeLabelMnemonic = 0;
    private String filesOfTypeLabelText = null;
    private String upFolderToolTipText = null;
    private String upFolderAccessibleName = null;
    private String homeFolderToolTipText = null;
    private String homeFolderAccessibleName = null;
    private String newFolderToolTipText = null;
    private String newFolderAccessibleName = null;
    private String listViewButtonToolTipText = null;
    private String listViewButtonAccessibleName = null;
    private String detailsViewButtonToolTipText = null;
    private String detailsViewButtonAccessibleName = null;
    private AlignedLabel fileNameLabel;
    static final int space = 10;

    private void populateFileNameLabel() {
        if (this.getFileChooser().getFileSelectionMode() == 1) {
            this.fileNameLabel.setText(this.folderNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.folderNameLabelMnemonic);
        } else {
            this.fileNameLabel.setText(this.fileNameLabelText);
            this.fileNameLabel.setDisplayedMnemonic(this.fileNameLabelMnemonic);
        }
    }

    public static ComponentUI createUI(JComponent c) {
        ThemeMediator.testComponentCreationThreadingViolation();
        return new BaseFileChooserUI((JFileChooser)c);
    }

    public BaseFileChooserUI(JFileChooser filechooser) {
        super(filechooser);
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
    }

    @Override
    public void uninstallComponents(JFileChooser fc) {
        fc.removeAll();
        this.bottomPanel = null;
        this.buttonPanel = null;
    }

    @Override
    public void installComponents(JFileChooser fc) {
        FileSystemView fsv = fc.getFileSystemView();
        fc.setBorder(new EmptyBorder(12, 12, 11, 11));
        fc.setLayout(new BorderLayout(0, 11));
        this.filePane = new FilePaneEx(new MetalFileChooserUIAccessor());
        fc.addPropertyChangeListener(this.filePane);
        this.updateUseShellFolder();
        JPanel topPanel = new JPanel(new BorderLayout(11, 0));
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BoxLayout(topButtonPanel, 2));
        topPanel.add((Component)topButtonPanel, "After");
        fc.add((Component)topPanel, "North");
        this.lookInLabel = new JLabel(this.lookInLabelText);
        this.lookInLabel.setDisplayedMnemonic(this.lookInLabelMnemonic);
        topPanel.add((Component)this.lookInLabel, "Before");
        this.directoryComboBox = new JComboBox<Object>(){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width = 150;
                return d;
            }
        };
        this.directoryComboBox.putClientProperty("AccessibleDescription", this.lookInLabelText);
        this.directoryComboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.lookInLabel.setLabelFor(this.directoryComboBox);
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel(fc);
        this.directoryComboBox.setModel(this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener(this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer(this.createDirectoryComboBoxRenderer(fc));
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.0f);
        this.directoryComboBox.setMaximumRowCount(8);
        topPanel.add(this.directoryComboBox, "Center");
        JButton upFolderButton = new JButton(this.getChangeToParentDirectoryAction());
        upFolderButton.setText(null);
        upFolderButton.setIcon(this.upFolderIcon);
        upFolderButton.setToolTipText(this.upFolderToolTipText);
        upFolderButton.putClientProperty("AccessibleName", this.upFolderAccessibleName);
        upFolderButton.setAlignmentX(0.0f);
        upFolderButton.setAlignmentY(0.5f);
        upFolderButton.setMargin(shrinkwrap);
        topButtonPanel.add(upFolderButton);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        File homeDir = fsv.getHomeDirectory();
        String toolTipText = this.homeFolderToolTipText;
        if (fsv.isRoot(homeDir)) {
            toolTipText = this.getFileView(fc).getName(homeDir);
        }
        JButton b = new JButton(this.homeFolderIcon);
        b.setToolTipText(toolTipText);
        b.putClientProperty("AccessibleName", this.homeFolderAccessibleName);
        b.setAlignmentX(0.0f);
        b.setAlignmentY(0.5f);
        b.setMargin(shrinkwrap);
        b.addActionListener(this.getGoHomeAction());
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        if (!UIManager.getBoolean("FileChooser.readOnly")) {
            b = new JButton(this.filePane.getNewFolderAction());
            b.setText(null);
            b.setIcon(this.newFolderIcon);
            b.setToolTipText(this.newFolderToolTipText);
            b.putClientProperty("AccessibleName", this.newFolderAccessibleName);
            b.setAlignmentX(0.0f);
            b.setAlignmentY(0.5f);
            b.setMargin(shrinkwrap);
        }
        topButtonPanel.add(b);
        topButtonPanel.add(Box.createRigidArea(hstrut5));
        ButtonGroup viewButtonGroup = new ButtonGroup();
        this.listViewButton = new JToggleButton(this.listViewIcon);
        this.listViewButton.setToolTipText(this.listViewButtonToolTipText);
        this.listViewButton.putClientProperty("AccessibleName", this.listViewButtonAccessibleName);
        this.listViewButton.setSelected(true);
        this.listViewButton.setAlignmentX(0.0f);
        this.listViewButton.setAlignmentY(0.5f);
        this.listViewButton.setMargin(shrinkwrap);
        this.listViewButton.addActionListener(this.filePane.getViewTypeAction(0));
        topButtonPanel.add(this.listViewButton);
        viewButtonGroup.add(this.listViewButton);
        this.detailsViewButton = new JToggleButton(this.detailsViewIcon);
        this.detailsViewButton.setToolTipText(this.detailsViewButtonToolTipText);
        this.detailsViewButton.putClientProperty("AccessibleName", this.detailsViewButtonAccessibleName);
        this.detailsViewButton.setAlignmentX(0.0f);
        this.detailsViewButton.setAlignmentY(0.5f);
        this.detailsViewButton.setMargin(shrinkwrap);
        this.detailsViewButton.addActionListener(this.filePane.getViewTypeAction(1));
        topButtonPanel.add(this.detailsViewButton);
        viewButtonGroup.add(this.detailsViewButton);
        this.filePane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("viewType".equals(e.getPropertyName())) {
                    int viewType = BaseFileChooserUI.this.filePane.getViewType();
                    switch (viewType) {
                        case 0: {
                            BaseFileChooserUI.this.listViewButton.setSelected(true);
                            break;
                        }
                        case 1: {
                            BaseFileChooserUI.this.detailsViewButton.setSelected(true);
                        }
                    }
                }
            }
        });
        fc.add((Component)this.getAccessoryPanel(), "After");
        JComponent accessory = fc.getAccessory();
        if (accessory != null) {
            this.getAccessoryPanel().add(accessory);
        }
        this.filePane.setPreferredSize(LIST_PREF_SIZE);
        fc.add((Component)this.filePane, "Center");
        JPanel bottomPanel = this.getBottomPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        fc.add((Component)bottomPanel, "South");
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new BoxLayout(fileNamePanel, 2));
        bottomPanel.add(fileNamePanel);
        bottomPanel.add(Box.createRigidArea(vstrut5));
        this.fileNameLabel = new AlignedLabel();
        this.populateFileNameLabel();
        fileNamePanel.add(this.fileNameLabel);
        this.fileNameTextField = new JTextField(35){
            private static final long serialVersionUID = -8830541272140418635L;

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(Short.MAX_VALUE, super.getPreferredSize().height);
            }
        };
        fileNamePanel.add(this.fileNameTextField);
        this.fileNameLabel.setLabelFor(this.fileNameTextField);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!BaseFileChooserUI.this.getFileChooser().isMultiSelectionEnabled()) {
                    BaseFileChooserUI.this.filePane.clearSelection();
                }
            }
        });
        if (fc.isMultiSelectionEnabled()) {
            this.setFileName(this.fileNameString(fc.getSelectedFiles()));
        } else {
            this.setFileName(this.fileNameString(fc.getSelectedFile()));
        }
        JPanel filesOfTypePanel = new JPanel();
        filesOfTypePanel.setLayout(new BoxLayout(filesOfTypePanel, 2));
        bottomPanel.add(filesOfTypePanel);
        AlignedLabel filesOfTypeLabel = new AlignedLabel(this.filesOfTypeLabelText);
        filesOfTypeLabel.setDisplayedMnemonic(this.filesOfTypeLabelMnemonic);
        filesOfTypePanel.add(filesOfTypeLabel);
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        fc.addPropertyChangeListener(this.filterComboBoxModel);
        this.filterComboBox = new JComboBox<Object>(this.filterComboBoxModel);
        this.filterComboBox.putClientProperty("AccessibleDescription", this.filesOfTypeLabelText);
        filesOfTypeLabel.setLabelFor(this.filterComboBox);
        this.filterComboBox.setRenderer(this.createFilterComboBoxRenderer());
        filesOfTypePanel.add(this.filterComboBox);
        this.getButtonPanel().setLayout(new ButtonAreaLayout());
        this.approveButton = new JButton(this.getApproveButtonText(fc));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(fc));
        this.getButtonPanel().add(this.approveButton);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.getButtonPanel().add(this.cancelButton);
        if (fc.getControlButtonsAreShown()) {
            this.addControlButtons();
        }
        BaseFileChooserUI.groupLabels(new AlignedLabel[]{this.fileNameLabel, filesOfTypeLabel});
    }

    private void updateUseShellFolder() {
        JFileChooser fc = this.getFileChooser();
        Boolean prop = (Boolean)fc.getClientProperty("FileChooser.useShellFolder");
        this.useShellFolder = prop != null ? prop.booleanValue() : fc.getFileSystemView().equals(FileSystemView.getFileSystemView());
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
        }
        return this.buttonPanel;
    }

    protected JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
        }
        return this.bottomPanel;
    }

    @Override
    protected void installStrings(JFileChooser fc) {
        super.installStrings(fc);
        Locale l = fc.getLocale();
        this.lookInLabelMnemonic = UIManager.getInt("FileChooser.lookInLabelMnemonic");
        this.lookInLabelText = UIManager.getString((Object)"FileChooser.lookInLabelText", l);
        this.saveInLabelText = UIManager.getString((Object)"FileChooser.saveInLabelText", l);
        this.fileNameLabelMnemonic = UIManager.getInt("FileChooser.fileNameLabelMnemonic");
        this.fileNameLabelText = UIManager.getString((Object)"FileChooser.fileNameLabelText", l);
        this.folderNameLabelMnemonic = UIManager.getInt("FileChooser.folderNameLabelMnemonic");
        this.folderNameLabelText = UIManager.getString((Object)"FileChooser.folderNameLabelText", l);
        this.filesOfTypeLabelMnemonic = UIManager.getInt("FileChooser.filesOfTypeLabelMnemonic");
        this.filesOfTypeLabelText = UIManager.getString((Object)"FileChooser.filesOfTypeLabelText", l);
        this.upFolderToolTipText = UIManager.getString((Object)"FileChooser.upFolderToolTipText", l);
        this.upFolderAccessibleName = UIManager.getString((Object)"FileChooser.upFolderAccessibleName", l);
        this.homeFolderToolTipText = UIManager.getString((Object)"FileChooser.homeFolderToolTipText", l);
        this.homeFolderAccessibleName = UIManager.getString((Object)"FileChooser.homeFolderAccessibleName", l);
        this.newFolderToolTipText = UIManager.getString((Object)"FileChooser.newFolderToolTipText", l);
        this.newFolderAccessibleName = UIManager.getString((Object)"FileChooser.newFolderAccessibleName", l);
        this.listViewButtonToolTipText = UIManager.getString((Object)"FileChooser.listViewButtonToolTipText", l);
        this.listViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.listViewButtonAccessibleName", l);
        this.detailsViewButtonToolTipText = UIManager.getString((Object)"FileChooser.detailsViewButtonToolTipText", l);
        this.detailsViewButtonAccessibleName = UIManager.getString((Object)"FileChooser.detailsViewButtonAccessibleName", l);
    }

    @Override
    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        ActionMap actionMap = this.getActionMap2();
        SwingUtilities.replaceUIActionMap(fc, actionMap);
    }

    protected ActionMap getActionMap2() {
        return this.createActionMap2();
    }

    protected ActionMap createActionMap2() {
        ActionMapUIResource map = new ActionMapUIResource();
        FilePane.addActionsToMap(map, this.filePane.getActions());
        return map;
    }

    protected JPanel createList(JFileChooser fc) {
        return this.filePane.createList();
    }

    protected JPanel createDetailsView(JFileChooser fc) {
        return this.filePane.createDetailsView();
    }

    @Override
    public ListSelectionListener createListSelectionListener(JFileChooser fc) {
        return super.createListSelectionListener(fc);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.removePropertyChangeListener(this.filterComboBoxModel);
        c.removePropertyChangeListener(this.filePane);
        this.cancelButton.removeActionListener(this.getCancelSelectionAction());
        this.approveButton.removeActionListener(this.getApproveSelectionAction());
        this.fileNameTextField.removeActionListener(this.getApproveSelectionAction());
        if (this.filePane != null) {
            this.filePane.uninstallUI();
            this.filePane = null;
        }
        super.uninstallUI(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        int prefWidth = BaseFileChooserUI.PREF_SIZE.width;
        Dimension d = c.getLayout().preferredLayoutSize(c);
        if (d != null) {
            return new Dimension(d.width < prefWidth ? prefWidth : d.width, d.height < BaseFileChooserUI.PREF_SIZE.height ? BaseFileChooserUI.PREF_SIZE.height : d.height);
        }
        return new Dimension(prefWidth, BaseFileChooserUI.PREF_SIZE.height);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return MIN_SIZE;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private String fileNameString(File file) {
        if (file == null) {
            return null;
        }
        JFileChooser fc = this.getFileChooser();
        if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() || fc.isDirectorySelectionEnabled() && fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystemRoot(file)) {
            return file.getPath();
        }
        return file.getName();
    }

    private String fileNameString(File[] files) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            if (files.length > 1) {
                buf.append("\"");
            }
            buf.append(this.fileNameString(files[i]));
            if (files.length <= 1) continue;
            buf.append("\"");
        }
        return buf.toString();
    }

    private void doSelectedFileChanged(PropertyChangeEvent e) {
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileName(this.fileNameString(f));
        }
    }

    private void doSelectedFilesChanged(PropertyChangeEvent e) {
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileName(this.fileNameString(files));
        }
    }

    private void doDirectoryChanged(PropertyChangeEvent e) {
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.clearIconCache();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            this.directoryComboBoxModel.addItem(currentDirectory);
            if (fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled()) {
                if (fsv.isFileSystem(currentDirectory)) {
                    this.setFileName(currentDirectory.getPath());
                } else {
                    this.setFileName(null);
                }
            }
        }
    }

    private void doFilterChanged(PropertyChangeEvent e) {
        this.clearIconCache();
    }

    private void doFileSelectionModeChanged(PropertyChangeEvent e) {
        if (this.fileNameLabel != null) {
            this.populateFileNameLabel();
        }
        this.clearIconCache();
        JFileChooser fc = this.getFileChooser();
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null && fc.isDirectorySelectionEnabled() && !fc.isFileSelectionEnabled() && fc.getFileSystemView().isFileSystem(currentDirectory)) {
            this.setFileName(currentDirectory.getPath());
        } else {
            this.setFileName(null);
        }
    }

    private void doAccessoryChanged(PropertyChangeEvent e) {
        if (this.getAccessoryPanel() != null) {
            JComponent accessory;
            if (e.getOldValue() != null) {
                this.getAccessoryPanel().remove((JComponent)e.getOldValue());
            }
            if ((accessory = (JComponent)e.getNewValue()) != null) {
                this.getAccessoryPanel().add((Component)accessory, "Center");
            }
        }
    }

    private void doApproveButtonTextChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
    }

    private void doDialogTypeChanged(PropertyChangeEvent e) {
        JFileChooser chooser = this.getFileChooser();
        this.approveButton.setText(this.getApproveButtonText(chooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        if (chooser.getDialogType() == 1) {
            this.lookInLabel.setText(this.saveInLabelText);
        } else {
            this.lookInLabel.setText(this.lookInLabelText);
        }
    }

    private void doApproveButtonMnemonicChanged(PropertyChangeEvent e) {
    }

    private void doControlButtonsChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().getControlButtonsAreShown()) {
            this.addControlButtons();
        } else {
            this.removeControlButtons();
        }
    }

    @Override
    public PropertyChangeListener createPropertyChangeListener(JFileChooser fc) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String s = e.getPropertyName();
                if (s.equals("SelectedFileChangedProperty")) {
                    BaseFileChooserUI.this.doSelectedFileChanged(e);
                } else if (s.equals("SelectedFilesChangedProperty")) {
                    BaseFileChooserUI.this.doSelectedFilesChanged(e);
                } else if (s.equals("directoryChanged")) {
                    BaseFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("fileFilterChanged")) {
                    BaseFileChooserUI.this.doFilterChanged(e);
                } else if (s.equals("fileSelectionChanged")) {
                    BaseFileChooserUI.this.doFileSelectionModeChanged(e);
                } else if (s.equals("AccessoryChangedProperty")) {
                    BaseFileChooserUI.this.doAccessoryChanged(e);
                } else if (s.equals("ApproveButtonTextChangedProperty") || s.equals("ApproveButtonToolTipTextChangedProperty")) {
                    BaseFileChooserUI.this.doApproveButtonTextChanged(e);
                } else if (s.equals("DialogTypeChangedProperty")) {
                    BaseFileChooserUI.this.doDialogTypeChanged(e);
                } else if (s.equals("ApproveButtonMnemonicChangedProperty")) {
                    BaseFileChooserUI.this.doApproveButtonMnemonicChanged(e);
                } else if (s.equals("ControlButtonsAreShownChangedProperty")) {
                    BaseFileChooserUI.this.doControlButtonsChanged(e);
                } else if (s.equals("componentOrientation")) {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JFileChooser cc = (JFileChooser)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        cc.applyComponentOrientation(o);
                    }
                } else if (s == "FileChooser.useShellFolder") {
                    BaseFileChooserUI.this.updateUseShellFolder();
                    BaseFileChooserUI.this.doDirectoryChanged(e);
                } else if (s.equals("ancestor") && e.getOldValue() == null && e.getNewValue() != null) {
                    BaseFileChooserUI.this.fileNameTextField.selectAll();
                    BaseFileChooserUI.this.fileNameTextField.requestFocus();
                }
            }
        };
    }

    protected void removeControlButtons() {
        this.getBottomPanel().remove(this.getButtonPanel());
    }

    protected void addControlButtons() {
        this.getBottomPanel().add(this.getButtonPanel());
    }

    @Override
    public void ensureFileIsVisible(JFileChooser fc, File f) {
        this.filePane.ensureFileIsVisible(fc, f);
    }

    @Override
    public void rescanCurrentDirectory(JFileChooser fc) {
        this.filePane.rescanCurrentDirectory();
    }

    @Override
    public String getFileName() {
        if (this.fileNameTextField != null) {
            return this.fileNameTextField.getText();
        }
        return null;
    }

    @Override
    public void setFileName(String filename) {
        if (this.fileNameTextField != null) {
            this.fileNameTextField.setText(filename);
        }
    }

    @Override
    protected void setDirectorySelected(boolean directorySelected) {
        super.setDirectorySelected(directorySelected);
        JFileChooser chooser = this.getFileChooser();
        if (directorySelected) {
            if (this.approveButton != null) {
                this.approveButton.setText(this.directoryOpenButtonText);
                this.approveButton.setToolTipText(this.directoryOpenButtonToolTipText);
            }
        } else if (this.approveButton != null) {
            this.approveButton.setText(this.getApproveButtonText(chooser));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(chooser));
        }
    }

    @Override
    public String getDirectoryName() {
        return null;
    }

    @Override
    public void setDirectoryName(String dirname) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer(JFileChooser fc) {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel(JFileChooser fc) {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent e) {
        JFileChooser fc = this.getFileChooser();
        File f = fc.getSelectedFile();
        if (!e.getValueIsAdjusting() && f != null && !this.getFileChooser().isTraversable(f)) {
            this.setFileName(this.fileNameString(f));
        }
    }

    @Override
    protected JButton getApproveButton(JFileChooser fc) {
        return this.approveButton;
    }

    private static void groupLabels(AlignedLabel[] group) {
        for (int i = 0; i < group.length; ++i) {
            AlignedLabel.access$2402(group[i], group);
        }
    }

    private class AlignedLabel
    extends JLabel {
        private static final long serialVersionUID = 5729395346234189975L;
        private AlignedLabel[] group;
        private int maxWidth;

        AlignedLabel() {
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        AlignedLabel(String text) {
            super(text);
            this.maxWidth = 0;
            this.setAlignmentX(0.0f);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(this.getMaxWidth() + 11, d.height);
        }

        private int getMaxWidth() {
            if (this.maxWidth == 0 && this.group != null) {
                int i;
                int max = 0;
                for (i = 0; i < this.group.length; ++i) {
                    max = Math.max(this.group[i].getSuperPreferredWidth(), max);
                }
                for (i = 0; i < this.group.length; ++i) {
                    this.group[i].maxWidth = max;
                }
            }
            return this.maxWidth;
        }

        private int getSuperPreferredWidth() {
            return super.getPreferredSize().width;
        }

        static /* synthetic */ AlignedLabel[] access$2402(AlignedLabel x0, AlignedLabel[] x1) {
            x0.group = x1;
            return x1;
        }
    }

    private static class ButtonAreaLayout
    implements LayoutManager {
        private int hGap = 5;
        private int topMargin = 17;

        private ButtonAreaLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component comp) {
        }

        @Override
        public void layoutContainer(Container container) {
            Component[] children = container.getComponents();
            if (children != null && children.length > 0) {
                int xOffset;
                int xLocation;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top + this.topMargin;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    sizes[counter] = children[counter].getPreferredSize();
                    maxWidth = Math.max(maxWidth, sizes[counter].width);
                }
                if (container.getComponentOrientation().isLeftToRight()) {
                    xLocation = container.getSize().width - insets.left - maxWidth;
                    xOffset = this.hGap + maxWidth;
                } else {
                    xLocation = insets.left;
                    xOffset = -(this.hGap + maxWidth);
                }
                for (int counter = numChildren - 1; counter >= 0; --counter) {
                    children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                    xLocation -= xOffset;
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = this.topMargin + cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                int maxWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    maxWidth = Math.max(maxWidth, aSize.width);
                }
                return new Dimension(extraWidth + numChildren * maxWidth + (numChildren - 1) * this.hGap, extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        private static final long serialVersionUID = -372782296185641300L;

        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseFileChooserUI.this.directoryComboBox.hidePopup();
            File f = (File)BaseFileChooserUI.this.directoryComboBox.getSelectedItem();
            if (!BaseFileChooserUI.this.getFileChooser().getCurrentDirectory().equals(f)) {
                BaseFileChooserUI.this.getFileChooser().setCurrentDirectory(f);
            }
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object>,
    PropertyChangeListener {
        private static final long serialVersionUID = -1131578002217361954L;
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            this.filters = BaseFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])e.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            } else if (prop == "fileFilterChanged") {
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public void setSelectedItem(Object filter) {
            if (filter != null) {
                BaseFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)filter);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            FileFilter currentFilter = BaseFileChooserUI.this.getFileChooser().getFileFilter();
            boolean found = false;
            if (currentFilter != null) {
                for (int i = 0; i < this.filters.length; ++i) {
                    if (this.filters[i] != currentFilter) continue;
                    found = true;
                }
                if (!found) {
                    BaseFileChooserUI.this.getFileChooser().addChoosableFileFilter(currentFilter);
                }
            }
            return BaseFileChooserUI.this.getFileChooser().getFileFilter();
        }

        @Override
        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            if (index > this.getSize() - 1) {
                return BaseFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[index];
            }
            return null;
        }
    }

    public class FilterComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -33803419008776614L;

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value != null && value instanceof FileFilter) {
                this.setText(((FileFilter)value).getDescription());
            }
            return this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel<Object>
    implements ComboBoxModel<Object> {
        private static final long serialVersionUID = -4248097879659126453L;
        Vector<File> directories = new Vector();
        int[] depths = null;
        File selectedDirectory = null;
        JFileChooser chooser = BaseFileChooserUI.this.getFileChooser();
        FileSystemView fsv = this.chooser.getFileSystemView();

        public DirectoryComboBoxModel() {
            File dir = BaseFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (dir != null) {
                this.addItem(dir);
            }
        }

        private void addItem(File directory) {
            if (directory == null) {
                return;
            }
            this.directories.clear();
            File[] baseFolders = BaseFileChooserUI.this.useShellFolder ? AccessController.doPrivileged(new PrivilegedAction<File[]>(){

                @Override
                public File[] run() {
                    return (File[])ShellFolder.get("fileChooserComboBoxFolders");
                }
            }) : this.fsv.getRoots();
            if (OSUtils.isMacOSX()) {
                File volumes = new File("/Volumes");
                for (File f : volumes.listFiles()) {
                    if (!f.isDirectory() || !f.canRead()) continue;
                    this.directories.add(f);
                }
            }
            this.directories.addAll(Arrays.asList(baseFolders));
            File canonical = null;
            try {
                canonical = ShellFolder.getNormalizedFile(directory);
            }
            catch (IOException e) {
                canonical = directory;
            }
            try {
                File sf;
                File f = sf = BaseFileChooserUI.this.useShellFolder ? ShellFolder.getShellFolder(canonical) : canonical;
                Vector<File> path = new Vector<File>(10);
                do {
                    path.addElement(f);
                } while ((f = f.getParentFile()) != null);
                int pathCount = path.size();
                for (int i = 0; i < pathCount; ++i) {
                    f = (File)path.get(i);
                    if (!this.directories.contains(f)) continue;
                    int topIndex = this.directories.indexOf(f);
                    for (int j = i - 1; j >= 0; --j) {
                        this.directories.insertElementAt((File)path.get(j), topIndex + i - j);
                    }
                    break;
                }
                this.calculateDepths();
                this.setSelectedItem(sf);
            }
            catch (FileNotFoundException ex) {
                this.calculateDepths();
            }
        }

        private void calculateDepths() {
            this.depths = new int[this.directories.size()];
            block0: for (int i = 0; i < this.depths.length; ++i) {
                File dir = this.directories.get(i);
                File parent = dir.getParentFile();
                this.depths[i] = 0;
                if (parent == null) continue;
                for (int j = i - 1; j >= 0; --j) {
                    if (!parent.equals(this.directories.get(j))) continue;
                    this.depths[i] = this.depths[j] + 1;
                    continue block0;
                }
            }
        }

        public int getDepth(int i) {
            return this.depths != null && i >= 0 && i < this.depths.length ? this.depths[i] : 0;
        }

        @Override
        public void setSelectedItem(Object selectedDirectory) {
            this.selectedDirectory = (File)selectedDirectory;
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        @Override
        public int getSize() {
            return this.directories.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.directories.elementAt(index);
        }
    }

    class IndentIcon
    implements Icon {
        Icon icon = null;
        int depth = 0;

        IndentIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (c.getComponentOrientation().isLeftToRight()) {
                this.icon.paintIcon(c, g, x + this.depth * 10, y);
            } else {
                this.icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth() + this.depth * 10;
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    class DirectoryComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -8500297350257807164L;
        IndentIcon ii;

        DirectoryComboBoxRenderer() {
            this.ii = new IndentIcon();
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon icon;
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("");
                return this;
            }
            File directory = (File)value;
            this.setText(BaseFileChooserUI.this.getFileChooser().getName(directory));
            this.ii.icon = icon = BaseFileChooserUI.this.getFileChooser().getIcon(directory);
            this.ii.depth = BaseFileChooserUI.this.directoryComboBoxModel.getDepth(index);
            this.setIcon(this.ii);
            return this;
        }
    }

    protected class FileRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7138220426570463430L;

        protected FileRenderer() {
        }
    }

    protected class SingleClickListener
    extends MouseAdapter {
        public SingleClickListener(JList<Object> list) {
        }
    }

    private class MetalFileChooserUIAccessor
    implements FilePane.FileChooserUIAccessor {
        private MetalFileChooserUIAccessor() {
        }

        @Override
        public JFileChooser getFileChooser() {
            return BaseFileChooserUI.this.getFileChooser();
        }

        @Override
        public BasicDirectoryModel getModel() {
            return BaseFileChooserUI.this.getModel();
        }

        @Override
        public JPanel createList() {
            return BaseFileChooserUI.this.createList(this.getFileChooser());
        }

        @Override
        public JPanel createDetailsView() {
            return BaseFileChooserUI.this.createDetailsView(this.getFileChooser());
        }

        @Override
        public boolean isDirectorySelected() {
            return BaseFileChooserUI.this.isDirectorySelected();
        }

        @Override
        public File getDirectory() {
            return BaseFileChooserUI.this.getDirectory();
        }

        @Override
        public Action getChangeToParentDirectoryAction() {
            return BaseFileChooserUI.this.getChangeToParentDirectoryAction();
        }

        @Override
        public Action getApproveSelectionAction() {
            return BaseFileChooserUI.this.getApproveSelectionAction();
        }

        @Override
        public Action getNewFolderAction() {
            return BaseFileChooserUI.this.getNewFolderAction();
        }

        @Override
        public MouseListener createDoubleClickListener(JList<Object> list) {
            return BaseFileChooserUI.this.createDoubleClickListener(this.getFileChooser(), list);
        }

        @Override
        public ListSelectionListener createListSelectionListener() {
            return BaseFileChooserUI.this.createListSelectionListener(this.getFileChooser());
        }

        @Override
        public boolean usesShellFolder() {
            return BaseFileChooserUI.this.useShellFolder;
        }
    }
}

