/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.searchfield;

import com.frostwire.gui.searchfield.JXSearchField;
import com.frostwire.gui.searchfield.SearchField;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.http.HttpClient;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.limewire.util.LCS;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public class GoogleSearchField
extends SearchField {
    private static final String SUGGESTIONS_URL = GoogleSearchField.buildSuggestionsUrl();
    private static final int HTTP_QUERY_TIMEOUT = 1000;
    private SuggestionsThread suggestionsThread;

    protected GoogleSearchField() {
        this.dict = this.createDefaultDictionary();
        this.setPrompt(I18n.tr("Hints by Google"));
        this.setSearchMode(JXSearchField.SearchMode.REGULAR);
    }

    @Override
    public void autoCompleteInput() {
        String input = this.getText();
        if (input != null && input.length() > 0) {
            if (this.suggestionsThread != null) {
                this.suggestionsThread.cancel();
            }
            if (this.getAutoComplete()) {
                this.suggestionsThread = new SuggestionsThread(input, this);
                this.suggestionsThread.start();
            }
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void setText(String t) {
        try {
            if (t != null) {
                t = t.replace("<html>", "").replace("</html>", "").replace("<b>", "").replace("</b>", "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.setText(t);
    }

    @Override
    protected JComponent getPopupComponent() {
        Font origFont;
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridwidth = 0;
        this.entryList = new SearchField.AutoCompleteList(this);
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, c);
        Font newFont = origFont = this.getFont();
        if (OSUtils.isWindows()) {
            newFont = ThemeMediator.DIALOG_FONT.deriveFont(origFont.getSize2D());
        }
        this.entryList.setFont(newFont);
        return this.entryPanel;
    }

    private static String buildSuggestionsUrl() {
        String lang = ApplicationSettings.LANGUAGE.getValue();
        if (StringUtils.isNullOrEmpty(lang)) {
            lang = "en";
        }
        return "https://clients1.google.com/complete/search?client=youtube&q=%s&hl=" + lang + "&gl=us&gs_rn=23&gs_ri=youtube&ds=yt&cp=2&gs_id=8&callback=google.sbox.p50";
    }

    private static final class SuggestionsThread
    extends Thread {
        private final String constraint;
        private final GoogleSearchField input;
        private boolean cancelled;

        public SuggestionsThread(String constraint, GoogleSearchField input) {
            this.constraint = constraint;
            this.input = input;
            this.setName("SuggestionsThread: " + constraint);
            this.setDaemon(true);
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public void run() {
            try {
                String url = String.format(SUGGESTIONS_URL, URLEncoder.encode(this.constraint, "UTF-8"));
                HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
                String js = httpClient.get(url, 1000);
                String json = this.stripJs(js);
                if (!this.isCancelled()) {
                    JsonArray arr = new JsonParser().parse(json).getAsJsonArray();
                    final List<String> suggestions = this.readSuggestions(arr.get(1).getAsJsonArray());
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Iterator<String> it = suggestions.iterator();
                            if (it.hasNext()) {
                                if (!StringUtils.isNullOrEmpty(input.getText(), true)) {
                                    input.showPopup(it);
                                } else {
                                    input.hidePopup();
                                }
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private List<String> readSuggestions(JsonArray array) {
            String t = this.input.getText();
            ArrayList<String> suggestions = new ArrayList<String>(array.size());
            if (!StringUtils.isNullOrEmpty(t, true)) {
                for (int i = 0; i < array.size(); ++i) {
                    try {
                        String s = LCS.lcsHtml(t, array.get(i).getAsJsonArray().get(0).getAsString());
                        suggestions.add(s);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            return suggestions;
        }

        private String stripJs(String js) {
            js = js.replace("google.sbox.p50 && google.sbox.p50(", "");
            js = js.replace("}])", "}]");
            return js;
        }
    }
}

