/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.AlphaAnimationThread;
import com.frostwire.gui.mplayer.MPlayerComponent;
import com.frostwire.gui.mplayer.MPlayerComponentFactory;
import com.frostwire.gui.mplayer.MPlayerOverlayControls;
import com.frostwire.gui.mplayer.MPlayerWindowLinux;
import com.frostwire.gui.mplayer.MPlayerWindowOSX;
import com.frostwire.gui.mplayer.MPlayerWindowWin32;
import com.frostwire.gui.player.MPlayerUIEventHandler;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaPlayerAdapter;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.player.ScreenSaverDisabler;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.LimeJFrame;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.Timer;
import org.limewire.util.OSUtils;

public class MPlayerWindow
extends JFrame {
    private static final long serialVersionUID = -9154474667503959284L;
    private MPlayerOverlayControls overlayControls;
    MPlayerComponent mplayerComponent;
    Component videoCanvas;
    private boolean isFullscreen = false;
    private AlphaAnimationThread animateAlphaThread;
    private Timer hideTimer;
    private static final int HIDE_DELAY = 3000;
    private final MediaPlayer player;
    private Point2D prevMousePosition = null;
    private boolean handleVideoResize = true;
    private final ScreenSaverDisabler screenSaverDisabler;
    private int visibleCounterFlag = 0;

    MPlayerWindow() {
        this.initializeUI();
        this.screenSaverDisabler = new ScreenSaverDisabler();
        this.player = MediaPlayer.instance();
        this.player.addMediaPlayerListener(new MediaPlayerAdapter(){

            @Override
            public void mediaOpened(MediaPlayer mediaPlayer, MediaSource mediaSource) {
                MPlayerWindow.this.setPlayerWindowTitle();
            }

            @Override
            public void stateChange(MediaPlayer audioPlayer, MediaPlaybackState state) {
                if (state == MediaPlaybackState.Playing && MPlayerWindow.this.handleVideoResize) {
                    MPlayerWindow.this.handleVideoResize = false;
                    MPlayerWindow.this.resizeCanvas();
                }
                if (state != MediaPlaybackState.Playing) {
                    MPlayerWindow.this.handleVideoResize = true;
                }
            }
        });
    }

    public static MPlayerWindow createMPlayerWindow() {
        if (OSUtils.isWindows()) {
            return new MPlayerWindowWin32();
        }
        if (OSUtils.isLinux()) {
            return new MPlayerWindowLinux();
        }
        if (OSUtils.isMacOSX()) {
            return new MPlayerWindowOSX();
        }
        return null;
    }

    public MediaPlayer getMediaPlayer() {
        return this.player;
    }

    private void initializeUI() {
        Dimension d = new Dimension(800, 600);
        this.hideTimer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MPlayerWindow.this.onHideTimerExpired();
            }
        });
        this.hideTimer.setRepeats(false);
        this.setDefaultCloseOperation(1);
        this.setPlayerWindowTitle();
        this.setBackground(new Color(0, 0, 0));
        this.initWindowIcon();
        this.addMouseMotionListener(new MPlayerMouseMotionAdapter());
        this.addComponentListener(new MPlayerComponentHandler());
        this.addWindowListener(new MPlayerWindowAdapter());
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new MPlayerKeyEventDispatcher());
        Container pane = this.getContentPane();
        pane.setBackground(Color.black);
        pane.setLayout(null);
        pane.setSize(d);
        pane.setPreferredSize(d);
        this.mplayerComponent = MPlayerComponentFactory.instance().createPlayerComponent();
        if (this.mplayerComponent == null) {
            throw new RuntimeException("MPlayerComponent instantiation isn't supported in your OS, or your OS hasn't correctly been detected by FrostWire");
        }
        this.videoCanvas = this.mplayerComponent.getComponent();
        this.videoCanvas.setBackground(Color.black);
        this.videoCanvas.setSize(d);
        this.videoCanvas.setPreferredSize(d);
        this.videoCanvas.addMouseMotionListener(new MPlayerMouseMotionAdapter());
        this.videoCanvas.addMouseListener(new MPlayerMouseAdapter());
        pane.add(this.videoCanvas);
        this.pack();
        this.overlayControls = new MPlayerOverlayControls(this.hideTimer);
        this.overlayControls.setVisible(false);
        this.overlayControls.setAlwaysOnTop(true);
        this.overlayControls.setIsFullscreen(this.isFullscreen);
        this.overlayControls.addMouseListener(new MPlayerMouseAdapter());
        this.overlayControls.addMouseMotionListener(new MPlayerMouseMotionAdapter());
        this.overlayControls.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (!OSUtils.isWindows()) {
                    if (MPlayerWindow.this.visibleCounterFlag > 0) {
                        MPlayerWindow.this.hideOverlay(OSUtils.isMacOSX());
                    }
                    MPlayerWindow.this.visibleCounterFlag++;
                }
            }
        });
        this.animateAlphaThread = new AlphaAnimationThread(this.overlayControls);
        this.animateAlphaThread.setDaemon(true);
        this.animateAlphaThread.start();
    }

    private void initWindowIcon() {
        if (OSUtils.isMacOSX()) {
            return;
        }
        for (Window w : MPlayerWindow.getWindows()) {
            List<Image> iconImages;
            if (w.getParent() != null || !(w instanceof LimeJFrame) || (iconImages = w.getIconImages()).size() <= 0) continue;
            Image image = iconImages.get(0);
            this.setIconImage(image);
            return;
        }
    }

    private void setPlayerWindowTitle() {
        MediaSource source = MediaPlayer.instance().getCurrentMedia();
        if (source != null) {
            this.setTitle("FrostWire Media Player -  " + source.getTitleText());
        } else {
            this.setTitle("FrostWire Media Player");
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.visibleCounterFlag = 0;
        if (this.isVisible() && visible) {
            this.visibleCounterFlag = 1;
        }
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            this.overlayControls.setVisible(visible);
            if (visible) {
                this.centerOnScreen();
                this.positionOverlayControls();
                this.showOverlay(false);
            } else {
                this.hideOverlay(OSUtils.isMacOSX());
            }
        }
        if (visible) {
            this.toFront();
            this.requestFocus();
            this.screenSaverDisabler.start();
        } else {
            this.screenSaverDisabler.stop();
        }
    }

    public void toggleFullScreen() {
        if (this.isVisible()) {
            this.isFullscreen = !this.isFullscreen;
            this.overlayControls.setIsFullscreen(this.isFullscreen);
            this.positionOverlayControls();
            UXStats.instance().log(4010);
        }
    }

    public long getCanvasComponentHwnd() {
        return 0L;
    }

    public long getHwnd() {
        return 0L;
    }

    private void resizeCanvas() {
        Dimension videoSize = MediaPlayer.instance().getCurrentVideoSize();
        Dimension contentSize = this.getContentPane().getSize();
        if (contentSize == null || videoSize == null) {
            return;
        }
        Dimension canvasSize = new Dimension(contentSize);
        float targetAspectRatio = (float)videoSize.width / (float)videoSize.height;
        if ((float)canvasSize.width / targetAspectRatio < (float)contentSize.height) {
            canvasSize.height = (int)((float)canvasSize.width / targetAspectRatio);
        } else {
            canvasSize.width = (int)((float)canvasSize.height * targetAspectRatio);
        }
        Point tl = new Point();
        tl.x = (int)((float)(contentSize.width - canvasSize.width) / 2.0f);
        tl.y = (int)((float)(contentSize.height - canvasSize.height) / 2.0f);
        this.videoCanvas.setBounds(tl.x, tl.y, canvasSize.width, canvasSize.height);
    }

    private void centerOnScreen() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = this.getSize();
        Point pos = new Point((screen.width - window.width) / 2, (screen.height - window.height) / 2);
        this.setLocation(pos);
    }

    private void positionOverlayControls() {
        if (this.isVisible()) {
            Dimension controlsSize = this.overlayControls.getSize();
            Dimension windowSize = this.getSize();
            Point windowPos = this.getLocationOnScreen();
            Point controlPos = new Point();
            controlPos.x = (int)((double)(windowSize.width - controlsSize.width) * 0.5 + (double)windowPos.x);
            controlPos.y = windowSize.height - controlsSize.height - 20 + windowPos.y;
            this.overlayControls.setLocation(controlPos);
        }
    }

    private void onHideTimerExpired() {
        this.animateAlphaThread.animateToTransparent();
    }

    @Override
    public void dispose() {
        this.animateAlphaThread.setDisposed();
        super.dispose();
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setComposite(AlphaComposite.getInstance(3, 0.0f));
        super.paint(g2);
        g2.dispose();
    }

    private void showOverlay(boolean animate) {
        if (animate) {
            this.animateAlphaThread.animateToOpaque();
        } else {
            this.overlayControls.setVisible(true);
        }
        this.hideTimer.restart();
    }

    private void hideOverlay(boolean animate) {
        if (animate) {
            this.animateAlphaThread.animateToTransparent();
        } else {
            this.overlayControls.setVisible(false);
        }
        this.hideTimer.stop();
    }

    void showOverlayControls() {
        this.showOverlay(true);
    }

    private class MPlayerWindowAdapter
    extends WindowAdapter {
        private MPlayerWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            MPlayerWindow.this.player.stop();
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            if (OSUtils.isWindows()) {
                if (e.getOppositeWindow() == MPlayerWindow.this.overlayControls) {
                    MPlayerWindow.this.requestFocus();
                } else {
                    MPlayerWindow.this.hideOverlay(OSUtils.isMacOSX());
                }
            }
        }

        @Override
        public void windowActivated(WindowEvent e) {
            if (e.getOppositeWindow() != MPlayerWindow.this.overlayControls) {
                MPlayerWindow.this.showOverlay(false);
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
            MPlayerWindow.this.hideOverlay(OSUtils.isMacOSX());
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            MPlayerWindow.this.showOverlay(false);
        }
    }

    private class MPlayerMouseMotionAdapter
    extends MouseMotionAdapter {
        private MPlayerMouseMotionAdapter() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (MPlayerWindow.this.isActive()) {
                double distance;
                Point currMousePosition = e.getPoint();
                if (MPlayerWindow.this.prevMousePosition == null) {
                    MPlayerWindow.this.prevMousePosition = currMousePosition;
                }
                if ((distance = currMousePosition.distance(MPlayerWindow.this.prevMousePosition)) > 10.0) {
                    MPlayerWindow.this.showOverlay(true);
                }
                MPlayerWindow.this.prevMousePosition = currMousePosition;
            }
        }
    }

    private class MPlayerMouseAdapter
    extends MouseAdapter {
        private MPlayerMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
            } else {
                MPlayerWindow.this.showOverlay(false);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MPlayerWindow.this.showOverlay(false);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MPlayerWindow.this.showOverlay(false);
        }
    }

    private class MPlayerKeyEventDispatcher
    implements KeyEventDispatcher {
        private MPlayerKeyEventDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent e) {
            if (!MPlayerWindow.this.isVisible()) {
                return false;
            }
            Window focusWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (focusWindow != MPlayerWindow.this && focusWindow != MPlayerWindow.this.overlayControls) {
                return false;
            }
            if (e.getID() == 401) {
                switch (e.getKeyCode()) {
                    case 32: 
                    case 80: {
                        MPlayerUIEventHandler.instance().onTogglePlayPausePressed();
                        return true;
                    }
                    case 87: {
                        if (OSUtils.isMacOSX() && e.isMetaDown()) {
                            MPlayerWindow.this.player.stop();
                            MPlayerWindow.this.setVisible(false);
                            return true;
                        }
                    }
                    case 70: {
                        MPlayerWindow.this.toggleFullScreen();
                        return true;
                    }
                    case 39: 
                    case 46: {
                        MPlayerUIEventHandler.instance().onFastForwardPressed();
                        return true;
                    }
                    case 37: 
                    case 44: {
                        MPlayerUIEventHandler.instance().onRewindPressed();
                        return true;
                    }
                    case 38: 
                    case 521: {
                        MPlayerUIEventHandler.instance().onVolumeIncremented();
                        return true;
                    }
                    case 40: 
                    case 45: {
                        MPlayerUIEventHandler.instance().onVolumeDecremented();
                        return true;
                    }
                    case 27: {
                        if (!MPlayerWindow.this.isFullscreen) break;
                        MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
                    }
                }
                if (e.getKeyCode() == 61) {
                    MPlayerUIEventHandler.instance().onVolumeIncremented();
                    return true;
                }
                if ((e.isAltDown() || e.isMetaDown() || e.isControlDown()) && e.getKeyCode() == 10) {
                    MPlayerUIEventHandler.instance().onToggleFullscreenPressed();
                    return true;
                }
            }
            return false;
        }
    }

    private class MPlayerComponentHandler
    extends ComponentAdapter {
        private MPlayerComponentHandler() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            MPlayerWindow.this.resizeCanvas();
            MPlayerWindow.this.positionOverlayControls();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            MPlayerWindow.this.positionOverlayControls();
        }
    }
}

