/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.MPlayerComponent;
import com.frostwire.gui.mplayer.MPlayerComponentJava;
import com.frostwire.gui.mplayer.MPlayerComponentOSX2;
import java.awt.Toolkit;

public final class MPlayerComponentFactory {
    private static final String JMPLAYER_LIBRARY = "JMPlayer";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_OS_WINDOWS = MPlayerComponentFactory.isCurrentOS("Windows");
    private static final boolean IS_OS_LINUX = MPlayerComponentFactory.isCurrentOS("Linux");
    private static final boolean IS_OS_MAC = MPlayerComponentFactory.isCurrentOS("Mac");
    private static boolean nativeLibLoaded = false;
    private static MPlayerComponentFactory instance;

    public static synchronized MPlayerComponentFactory instance() {
        if (instance == null) {
            instance = new MPlayerComponentFactory();
        }
        return instance;
    }

    private MPlayerComponentFactory() {
    }

    MPlayerComponent createPlayerComponent() {
        if (this.loadLibrary()) {
            if (IS_OS_WINDOWS) {
                return new MPlayerComponentJava();
            }
            if (IS_OS_MAC) {
                return new MPlayerComponentOSX2();
            }
            if (IS_OS_LINUX) {
                return new MPlayerComponentJava();
            }
        }
        return null;
    }

    private boolean loadLibrary() {
        if (!nativeLibLoaded) {
            try {
                Toolkit.getDefaultToolkit();
                if (IS_OS_MAC) {
                    System.loadLibrary(JMPLAYER_LIBRARY);
                }
                nativeLibLoaded = true;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return nativeLibLoaded;
    }

    private static boolean isCurrentOS(String osName) {
        return osName != null && OS_NAME.contains(osName);
    }
}

