/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.mplayer;

import com.frostwire.gui.mplayer.MPlayerInstance;
import com.frostwire.mplayer.BaseMediaPlayer;
import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.VolumeListener;
import com.frostwire.util.HttpClientFactory;
import com.frostwire.util.http.HttpClient;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.MessageText;

public class MPlayer
extends BaseMediaPlayer {
    private List<String> output = new LinkedList<String>();
    private volatile boolean disposed = false;
    private Thread outputParser = new Thread("MPlayer output parser"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (!MPlayer.this.disposed) {
                        String line = null;
                        List list = MPlayer.this.output;
                        synchronized (list) {
                            if (!MPlayer.this.output.isEmpty()) {
                                line = (String)MPlayer.this.output.remove(0);
                            } else {
                                MPlayer.this.output.wait();
                            }
                        }
                        if (line == null) continue;
                        try {
                            MPlayer.this.parseOutput(line);
                            continue block7;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    break;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    break;
                }
            }
        }
    };
    private Dimension videoSize = null;
    private boolean firstLengthReceived = false;
    private boolean firstVolumeReceived = false;
    private static final String ANS_LENGTH = "ANS_LENGTH=";
    private static final String ANS_POSITION = "ANS_TIME_POSITION=";
    private static final String ANS_VOLUME = "ANS_VOLUME=";
    private static final String ANS_SUB = "ANS_SUB=";
    private static final String ANS_WIDTH = "ANS_WIDTH=";
    private static final String ANS_HEIGHT = "ANS_HEIGHT=";
    private static final String ANS_ASPECT = "ANS_ASPECT=";
    private static final String ID_VIDEO_ASPECT = "ID_VIDEO_ASPECT=";
    private static final String ID_AUDIO_ID = "ID_AUDIO_ID=";
    private static final String ID_SUBTITLE_ID = "ID_SUBTITLE_ID=";
    private static final String ID_AUDIO_TRACK = "ID_AUDIO_TRACK=";
    private static final String ID_SUBTITLE_TRACK = "ID_SUBTITLE_TRACK=";
    private static final String ID_FILE_SUB_ID = "ID_FILE_SUB_ID=";
    private static final String ID_FILE_SUB_FILENAME = "ID_FILE_SUB_FILENAME=";
    private static final String ID_EXIT = "ID_EXIT=";
    private static final String ICY_INFO = "ICY Info:";
    private static final Pattern v_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) V:\\s*[0-9\\.]* .*");
    private static final Pattern a_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) .*");
    private MPlayerInstance current_instance;
    private boolean parsingLanguage;
    private boolean isAudioTrack;
    private Language language;
    private int width;
    private float aspect;
    private MetaDataListener metaDataListener;
    private StateListener stateListener;
    private VolumeListener volumeListener;
    private PositionListener positionListener;
    private IcyInfoListener icyInfoListener;

    public static void initialise(File path) {
        MPlayerInstance.initialise(path);
    }

    public MPlayer() {
        this(null);
    }

    public MPlayer(PlayerPreferences preferences) {
        super(preferences);
        this.outputParser.setDaemon(true);
        this.outputParser.start();
    }

    private void parseOutput(String line) {
        boolean stillParsing;
        block86: {
            stillParsing = false;
            Matcher v_matcher = v_timeInfo.matcher(line);
            Matcher a_matcher = a_timeInfo.matcher(line);
            if (v_matcher.matches()) {
                float time = Float.parseFloat(v_matcher.group(1));
                MPlayerInstance instance = this.getCurrentInstance();
                if (instance != null) {
                    instance.positioned(time);
                }
                this.reportPosition(time);
            } else if (a_matcher.matches()) {
                float time = Float.parseFloat(a_matcher.group(1));
                MPlayerInstance instance = this.getCurrentInstance();
                if (instance != null) {
                    instance.positioned(time);
                }
                this.reportPosition(time);
            } else if (!line.startsWith("VIDEO:")) {
                if (line.startsWith("Starting playback...")) {
                    this.stateListener.stateChanged(MediaPlaybackState.Playing);
                    MPlayerInstance instance = this.getCurrentInstance();
                    if (instance != null) {
                        instance.initialised();
                    }
                    this.reportNewState(MediaPlaybackState.Playing);
                } else if (line.startsWith(ANS_POSITION)) {
                    try {
                        MPlayerInstance instance = this.getCurrentInstance();
                        if (instance != null) {
                            instance.positioned();
                        }
                        float position = Float.parseFloat(line.substring(ANS_POSITION.length()));
                        this.reportPosition(position);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (line.startsWith(ANS_LENGTH)) {
                    try {
                        float duration = Float.parseFloat(line.substring(ANS_LENGTH.length()));
                        if (!this.firstLengthReceived) {
                            float seekTo;
                            this.firstLengthReceived = true;
                            if (this.preferences != null && (seekTo = this.preferences.getPositionForFile(this.getOpenedFile()) - 2.0f) > 0.0f && (double)seekTo < 0.99 * (double)duration && seekTo < duration - 20.0f) {
                                this.doSeek(seekTo);
                            }
                        }
                        this.reportDuration(duration);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (line.startsWith(ANS_VOLUME)) {
                    try {
                        int volume = (int)Float.parseFloat(line.substring(ANS_VOLUME.length()));
                        this.reportVolume(volume);
                        if (this.firstVolumeReceived) break block86;
                        this.firstVolumeReceived = true;
                        if (this.preferences != null && this.preferences.getVolume() != volume) {
                            this.setVolume(this.preferences.getVolume());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (!line.startsWith(ID_VIDEO_ASPECT)) {
                    if (line.startsWith(ANS_WIDTH)) {
                        try {
                            this.width = Integer.parseInt(line.substring(ANS_WIDTH.length()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ANS_HEIGHT)) {
                        try {
                            int videoWidth = this.width;
                            int videoHeight = Integer.parseInt(line.substring(ANS_HEIGHT.length()));
                            int displayWidth = videoWidth;
                            int displayHeight = videoHeight;
                            if (this.aspect > 0.0f && this.abs(this.aspect - (float)videoWidth / (float)videoHeight) > 0.1) {
                                displayWidth = (int)((float)displayHeight * this.aspect);
                            }
                            if (this.metaDataListener != null) {
                                this.metaDataListener.receivedVideoResolution(videoWidth, videoHeight);
                                this.metaDataListener.receivedDisplayResolution(displayWidth, displayHeight);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ANS_ASPECT)) {
                        try {
                            this.aspect = Float.parseFloat(line.substring(ANS_ASPECT.length()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ID_AUDIO_ID)) {
                        this.reportParsingDone();
                        try {
                            String audioId = line.substring(ID_AUDIO_ID.length());
                            this.language = new Language(LanguageSource.STREAM, "" + audioId);
                            this.parsingLanguage = true;
                            this.isAudioTrack = true;
                            stillParsing = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ID_SUBTITLE_ID)) {
                        this.reportParsingDone();
                        try {
                            String audioId = line.substring(ID_SUBTITLE_ID.length());
                            this.language = new Language(LanguageSource.STREAM, "" + audioId);
                            this.parsingLanguage = true;
                            this.isAudioTrack = false;
                            stillParsing = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ID_FILE_SUB_ID)) {
                        this.reportParsingDone();
                        try {
                            String subId = line.substring(ID_FILE_SUB_ID.length());
                            this.language = new Language(LanguageSource.FILE, "" + subId);
                            this.parsingLanguage = true;
                            this.isAudioTrack = false;
                            stillParsing = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (this.parsingLanguage && line.startsWith(ID_FILE_SUB_FILENAME)) {
                        try {
                            String fileName = line.substring(ID_FILE_SUB_FILENAME.length());
                            try {
                                File f = new File(fileName);
                                this.language.setSourceInfo(f.getAbsolutePath());
                                fileName = f.getName();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            this.language.setName(fileName);
                            stillParsing = false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (this.parsingLanguage && (line.startsWith("ID_AID_" + this.language.getId() + "_NAME=") || line.startsWith("ID_SID_" + this.language.getId() + "_NAME="))) {
                        String key = "ID_AID_" + this.language.getId() + "_NAME=";
                        String name = line.substring(key.length());
                        this.language.setName(name);
                        stillParsing = true;
                    } else if (this.parsingLanguage && (line.startsWith("ID_AID_" + this.language.getId() + "_LANG=") || line.startsWith("ID_SID_" + this.language.getId() + "_LANG="))) {
                        String key = "ID_AID_" + this.language.getId() + "_LANG=";
                        String isoCode = line.substring(key.length());
                        this.language.setLanguage(isoCode);
                        stillParsing = true;
                    } else if (this.parsingLanguage && (line.startsWith("ID_AID_" + this.language.getId()) || line.startsWith("ID_SID_" + this.language.getId()))) {
                        stillParsing = true;
                    } else if (line.startsWith(ID_AUDIO_TRACK)) {
                        try {
                            String audioId = line.substring(ID_AUDIO_TRACK.length());
                            this.reportAudioTrackChanged(audioId);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ID_SUBTITLE_TRACK)) {
                        try {
                            String subtitleId = line.substring(ID_SUBTITLE_TRACK.length());
                            this.reportSubtitleChanged(subtitleId, LanguageSource.STREAM);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith(ANS_SUB)) {
                        try {
                            String subtitleId = line.substring(ANS_SUB.length());
                            this.reportSubtitleChanged(subtitleId, LanguageSource.STREAM);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else if (line.startsWith("<vo_direct3d>Reading display capabilities failed")) {
                        MediaPlaybackState.Failed.setDetails(MessageText.getString("azemp.failed.d3dbad"));
                        this.reportNewState(MediaPlaybackState.Failed);
                    } else if (line.startsWith(ID_EXIT)) {
                        this.reportNewState(MediaPlaybackState.Closed);
                    } else if (line.startsWith(ICY_INFO)) {
                        String data = line.substring(ICY_INFO.length()).trim();
                        this.reportIcyInfo(data);
                    } else if (line.contains("VO: ")) {
                        this.parseVideoSize(line);
                    }
                }
            }
        }
        if (this.parsingLanguage && !stillParsing) {
            Language parsed = this.language;
            this.reportParsingDone();
            MPlayerInstance instance = this.getCurrentInstance();
            if (instance != null && instance.activateNextSubtitleLoaded) {
                instance.activateNextSubtitleLoaded = false;
                this.setSubtitles(parsed);
            }
        }
    }

    private double abs(float f) {
        return f > 0.0f ? (double)f : (double)(-f);
    }

    private void parseVideoSize(String line) {
        String[] arr = line.split(" ")[2].split("x");
        int w = Integer.parseInt(arr[0]);
        int h = Integer.parseInt(arr[1]);
        this.videoSize = new Dimension(w, h);
    }

    public Dimension getVideoSize() {
        return this.videoSize;
    }

    @Override
    public void doLoadSubtitlesFile(String file, boolean autoPlay) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doLoadSubtitlesFile(file, autoPlay);
        }
    }

    public void showMessage(String message, int duration) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.sendCommand("osd_show_text \"" + message + "\" " + duration + " " + 0);
        }
    }

    private void reportSubtitleChanged(String subtitleId, LanguageSource source) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeSubtitleChanged(subtitleId, source);
        }
    }

    private void reportAudioTrackChanged(String audioId) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeAudioTrackChanged(audioId);
        }
    }

    private void reportParsingDone() {
        if (this.parsingLanguage) {
            if (this.isAudioTrack) {
                this.reportFoundAudioTrack(this.language);
            } else {
                this.reportFoundSubtitle(this.language);
            }
            this.language = null;
            this.parsingLanguage = false;
            this.isAudioTrack = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOpen(String fileOrUrl, int initialVolume) {
        MPlayerInstance instance;
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            this.doStop(false);
            instance = this.current_instance = new MPlayerInstance();
        }
        this.reportNewState(MediaPlaybackState.Opening);
        this.firstLengthReceived = false;
        this.firstVolumeReceived = false;
        if (fileOrUrl.startsWith("http://")) {
            HttpClient httpClient = HttpClientFactory.getInstance(HttpClientFactory.HttpContext.MISC);
            HashMap<String, List<String>> responseHeaders = new HashMap<String, List<String>>();
            try {
                int responseCode = httpClient.head(fileOrUrl, 5000, responseHeaders);
                if (responseCode == 302 && responseHeaders.containsKey("Location") && ((List)responseHeaders.get("Location")).get(0) != null) {
                    fileOrUrl = (String)((List)responseHeaders.get("Location")).get(0);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        instance.doOpen(fileOrUrl, initialVolume, new MPlayerInstance.OutputConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(String line) {
                List list = MPlayer.this.output;
                synchronized (list) {
                    MPlayer.this.output.add(line);
                    MPlayer.this.output.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MPlayerInstance getCurrentInstance() {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            return this.current_instance;
        }
    }

    @Override
    public void doPause() {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doPause();
        }
        this.reportNewState(MediaPlaybackState.Paused);
    }

    @Override
    public void doResume() {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doResume();
        }
        this.reportNewState(MediaPlaybackState.Playing);
    }

    @Override
    public void doSeek(float timeInSecs) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doSeek(timeInSecs);
        }
    }

    @Override
    public void doSetVolume(int volume) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doSetVolume(volume);
        }
        this.reportVolume(volume);
    }

    @Override
    public void mute(boolean on) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doMute(on);
        }
    }

    public void doRedraw() {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.doRedraw();
        }
    }

    public void setAudioTrack(Language language) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            instance.setAudioTrack(language);
        }
    }

    public void setSubtitles(Language language) {
        MPlayerInstance instance = this.getCurrentInstance();
        if (instance != null) {
            this.reportSubtitleChanged(instance.setSubtitles(language), language != null ? language.getSource() : null);
        }
    }

    @Override
    public void doStop() {
        this.doStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(boolean report_state) {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            if (this.current_instance != null) {
                if (this.preferences != null) {
                    this.preferences.setPositionForFile(this.getOpenedFile(), this.getPositionInSecs());
                }
                this.current_instance.doStop();
                this.current_instance = null;
            }
            List<String> list = this.output;
            synchronized (list) {
                this.output.clear();
                this.output.notifyAll();
            }
        }
        if (report_state) {
            this.reportNewState(MediaPlaybackState.Stopped);
        }
    }

    @Override
    public void setMetaDataListener(MetaDataListener listener) {
        this.metaDataListener = listener;
    }

    @Override
    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    @Override
    public void setVolumeListener(VolumeListener listener) {
        this.volumeListener = listener;
    }

    @Override
    public void setPositionListener(PositionListener listener) {
        this.positionListener = listener;
    }

    @Override
    public void setIcyInfoListener(IcyInfoListener listener) {
        this.icyInfoListener = listener;
    }

    private void reportPosition(float position) {
        if (this.positionListener != null) {
            this.positionListener.positionChanged(position);
        }
    }

    private void reportVolume(int volume) {
        if (this.volumeListener != null) {
            this.volumeListener.volumeChanged(volume);
        }
    }

    private void reportDuration(float duration) {
        if (this.metaDataListener != null) {
            this.metaDataListener.receivedDuration(duration);
        }
    }

    private void reportFoundAudioTrack(Language audioTrack) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundAudioTrack(audioTrack);
        }
    }

    private void reportFoundSubtitle(Language subtitle) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundSubtitle(subtitle);
        }
    }

    private void reportNewState(MediaPlaybackState state) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(state);
        }
    }

    private void reportIcyInfo(String data) {
        if (this.icyInfoListener != null) {
            this.icyInfoListener.newIcyInfoData(data);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.doStop();
    }

    @Override
    public Map<String, String> getProperties(String fileOrUrl) {
        MPlayerInstance instance = new MPlayerInstance();
        final HashMap<String, String> properties = new HashMap<String, String>();
        instance.doGetProperties(fileOrUrl, new MPlayerInstance.OutputConsumer(){
            private String lastKey = null;

            @Override
            public void consume(String line) {
                if (line.split("=").length < 2) {
                    return;
                }
                if (line.startsWith("ID_CLIP_INFO_NAME")) {
                    this.lastKey = line.split("=")[1];
                } else if (line.startsWith("ID_CLIP_INFO_VALUE")) {
                    if (this.lastKey != null) {
                        properties.put(this.lastKey, line.split("=")[1]);
                        this.lastKey = null;
                    }
                } else if (line.startsWith("ID_")) {
                    String[] kv = line.split("=");
                    properties.put(kv[0], kv[1]);
                }
            }
        });
        return properties;
    }
}

