/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library.tags;

import com.frostwire.gui.library.tags.JaudiotaggerParser;
import com.frostwire.util.Logger;
import java.awt.image.BufferedImage;
import java.io.File;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.ogg.OggFileReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

class OggParser
extends JaudiotaggerParser {
    private static final Logger LOG = Logger.getLogger(OggParser.class);

    public OggParser(File file) {
        super(file, new OggFileReader());
    }

    @Override
    public BufferedImage getArtwork() {
        BufferedImage image = super.getArtwork();
        if (image == null) {
            try {
                byte[] data;
                AudioFile audioFile = AudioFileIO.read(this.file);
                VorbisCommentTag tag = (VorbisCommentTag)audioFile.getTag();
                if (tag != null && (data = tag.getArtworkBinaryData()) != null) {
                    image = OggParser.imageFromData(data);
                }
            }
            catch (Throwable e) {
                LOG.error("Unable to read cover art from ogg");
            }
        }
        return image;
    }
}

