/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.PlaylistItemProperty;
import com.frostwire.gui.library.PlaylistItemStarProperty;
import com.frostwire.gui.library.PlaylistItemStarRenderer;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractCellEditor;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class PlaylistItemStarEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 2484867032644699734L;
    private static final Icon starOn = GUIMediator.getThemeImage("star_on");
    private static final Icon starOff = GUIMediator.getThemeImage("star_off");
    private static final Icon exclamation = GUIMediator.getThemeImage("exclamation");

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, final Object value, boolean isSelected, int row, int column) {
        final LibraryPlaylistsTableDataLine line = ((PlaylistItemProperty)value).getLine();
        final JLabel component = (JLabel)new PlaylistItemStarRenderer().getTableCellRendererComponent(table, value, isSelected, true, row, column);
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!((PlaylistItemProperty)value).exists()) {
                    return;
                }
                PlaylistItem playlistItem = (PlaylistItem)line.getInitializeObject();
                if (((PlaylistItem)line.getInitializeObject()).isStarred()) {
                    playlistItem.setStarred(false);
                    playlistItem.save();
                    component.setIcon(starOff);
                } else {
                    playlistItem.setStarred(true);
                    playlistItem.save();
                    component.setIcon(starOn);
                }
            }
        });
        if (!((PlaylistItemStarProperty)value).exists()) {
            component.setIcon(exclamation);
        } else if (((PlaylistItem)line.getInitializeObject()).isStarred()) {
            component.setIcon(starOn);
        } else {
            component.setIcon(starOff);
        }
        return component;
    }
}

