/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.LibraryActionsRenderer;
import com.frostwire.gui.library.LibraryCoverArtPanel;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylists;
import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.LibraryPlaylistsTableModel;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferHandler;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.PlaylistItemBitRateProperty;
import com.frostwire.gui.library.PlaylistItemPropertyRenderer;
import com.frostwire.gui.library.PlaylistItemStarEditor;
import com.frostwire.gui.library.PlaylistItemStarProperty;
import com.frostwire.gui.library.PlaylistItemStarRenderer;
import com.frostwire.gui.library.PlaylistItemStringProperty;
import com.frostwire.gui.library.PlaylistItemTrackProperty;
import com.frostwire.gui.library.tags.TagsReader;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.search.GenericCellEditor;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.limewire.util.OSUtils;

final class LibraryPlaylistsTableMediator
extends AbstractLibraryTableMediator<LibraryPlaylistsTableModel, LibraryPlaylistsTableDataLine, PlaylistItem> {
    private Playlist currentPlaylist;
    private static Action LAUNCH_ACTION;
    private static Action LAUNCH_OS_ACTION;
    private static Action OPEN_IN_FOLDER_ACTION;
    private static Action CREATE_TORRENT_ACTION;
    private static Action DELETE_ACTION;
    private static Action SEND_TO_ITUNES_ACTION;
    private Action importToPlaylistAction = new ImportToPlaylistAction();
    private Action exportPlaylistAction = new ExportPlaylistAction();
    private Action cleanupPlaylistAction = new CleanupPlaylistAction();
    private Action refreshID3TagsAction = new RefreshID3TagsAction();
    private Action COPY_PLAYLIST_FILES_TO_FOLDER_ACTION = new LibraryPlaylists.CopyPlaylistFilesAction();
    private static LibraryPlaylistsTableMediator INSTANCE;
    private JPanel mainContainer;

    public static LibraryPlaylistsTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryPlaylistsTableMediator();
        }
        return INSTANCE;
    }

    Playlist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        LAUNCH_ACTION = new LaunchAction();
        LAUNCH_OS_ACTION = new LaunchOSAction();
        OPEN_IN_FOLDER_ACTION = new OpenInFolderAction();
        CREATE_TORRENT_ACTION = new CreateTorrentAction();
        DELETE_ACTION = new RemoveFromPlaylistAction();
        SEND_TO_ITUNES_ACTION = new SendAudioFilesToiTunes();
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new LibraryPlaylistsTableModel();
        ((LibraryPlaylistsTableModel)this.DATA_MODEL).sort(0);
        this.TABLE = new LimeJTable(this.DATA_MODEL){
            private final Image bigAudioIcon;
            {
                this.bigAudioIcon = GUIMediator.getThemeImage("audio128x128").getImage();
            }

            @Override
            protected void paintComponent(Graphics g) {
                if (LibraryPlaylistsTableMediator.this.TABLE.getRowCount() == 0) {
                    LibraryPlaylistsTableMediator.this.drawHelpGraphics(g, this.bigAudioIcon);
                } else {
                    super.paintComponent(g);
                }
            }
        };
        Action[] aa = new Action[]{LAUNCH_ACTION, OPEN_IN_FOLDER_ACTION, this.SEND_TO_FRIEND_ACTION, DELETE_ACTION, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(aa, 0, 14);
    }

    private void drawHelpGraphics(Graphics g, Image icon) {
        Graphics2D g2d = (Graphics2D)g;
        int helpPadding = 20;
        g2d.setStroke(new BasicStroke(6.0f, 1, 1, 10.0f, new float[]{16.0f, 20.0f}, 0.0f));
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, this.TABLE.getWidth(), this.TABLE.getHeight());
        g2d.setColor(ThemeMediator.LIGHT_BORDER_COLOR);
        g2d.drawRoundRect(helpPadding, helpPadding, this.TABLE.getWidth() - helpPadding * 2, this.TABLE.getHeight() - helpPadding * 2, 6, 6);
        try {
            if (this.TABLE.getHeight() - helpPadding * 3 < icon.getHeight(null)) {
                int newIconDimension = this.TABLE.getHeight() - helpPadding * 2 - 5;
                if (newIconDimension > 16) {
                    g2d.drawImage(icon, (this.TABLE.getWidth() - newIconDimension) / 2, (this.TABLE.getHeight() - newIconDimension) / 2, newIconDimension, newIconDimension, null);
                }
            } else {
                g2d.drawImage(icon, (this.TABLE.getWidth() - icon.getWidth(null)) / 2, (this.TABLE.getHeight() - icon.getHeight(null)) / 2, null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu menu = new SkinPopupMenu();
        menu.add(new SkinMenuItem(LAUNCH_ACTION));
        menu.add(new SkinMenuItem(LAUNCH_OS_ACTION));
        if (this.hasExploreAction()) {
            menu.add(new SkinMenuItem(OPEN_IN_FOLDER_ACTION));
        }
        menu.add(new SkinMenuItem(CREATE_TORRENT_ACTION));
        menu.add(this.createAddToPlaylistSubMenu());
        menu.add(new SkinMenuItem(this.SEND_TO_FRIEND_ACTION));
        menu.add(new SkinMenuItem(SEND_TO_ITUNES_ACTION));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.COPY_PLAYLIST_FILES_TO_FOLDER_ACTION));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(DELETE_ACTION));
        int[] rows = this.TABLE.getSelectedRows();
        boolean dirSelected = false;
        boolean fileSelected = false;
        for (int row : rows) {
            File f = ((LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(row)).getFile();
            if (f.isDirectory()) {
                dirSelected = true;
            } else {
                fileSelected = true;
            }
            if (dirSelected && fileSelected) break;
        }
        if (dirSelected) {
            DELETE_ACTION.setEnabled(true);
        } else {
            DELETE_ACTION.setEnabled(true);
        }
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.importToPlaylistAction));
        menu.add(new SkinMenuItem(this.exportPlaylistAction));
        menu.add(new SkinMenuItem(this.cleanupPlaylistAction));
        menu.add(new SkinMenuItem(this.refreshID3TagsAction));
        ((JPopupMenu)menu).addSeparator();
        LibraryPlaylistsTableDataLine line = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(rows[0]);
        menu.add(this.createSearchSubMenu(line));
        return menu;
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (LibraryUtils.isRefreshKeyEvent(e)) {
                    LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
                }
            }
        });
    }

    private JMenu createSearchSubMenu(LibraryPlaylistsTableDataLine dl) {
        File f;
        String keywords;
        SkinMenu menu = new SkinMenu(I18n.tr("Search"));
        if (dl != null && (keywords = QueryUtils.createQueryString((f = dl.getFile()).getName())).length() > 0) {
            menu.add(new SkinMenuItem(new SearchAction(keywords)));
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryPlaylistsTableMediator() {
        super("LIBRARY_PLAYLISTS_TABLE");
        this.setMediaType(MediaType.getAudioMediaType());
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setDropMode(DropMode.INSERT_ROWS);
        this.TABLE.setTransferHandler(new LibraryPlaylistsTableTransferHandler(this));
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PlaylistItemBitRateProperty.class, new PlaylistItemPropertyRenderer());
        this.TABLE.setDefaultRenderer(PlaylistItemTrackProperty.class, new PlaylistItemPropertyRenderer());
        this.TABLE.setDefaultRenderer(PlaylistItemStringProperty.class, new PlaylistItemPropertyRenderer());
        this.TABLE.setDefaultRenderer(PlaylistItemStarProperty.class, new PlaylistItemStarRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(2);
        tc.setCellEditor(new PlaylistItemStarEditor());
        this.TABLE.addMouseMotionListener(new MouseMotionAdapter(){
            int currentCellColumn = -1;
            int currentCellRow = -1;

            @Override
            public void mouseMoved(MouseEvent e) {
                Point hit = e.getPoint();
                int hitColumn = LibraryPlaylistsTableMediator.this.TABLE.columnAtPoint(hit);
                int hitRow = LibraryPlaylistsTableMediator.this.TABLE.rowAtPoint(hit);
                if (this.currentCellRow != hitRow || this.currentCellColumn != hitColumn) {
                    if (LibraryPlaylistsTableMediator.this.TABLE.getCellRenderer(hitRow, hitColumn) instanceof PlaylistItemStarRenderer) {
                        LibraryPlaylistsTableMediator.this.TABLE.editCellAt(hitRow, hitColumn);
                    }
                    this.currentCellColumn = hitColumn;
                    this.currentCellRow = hitRow;
                }
            }
        });
        tc = model.getColumn(1);
        tc.setCellEditor(new GenericCellEditor(new LibraryActionsRenderer()));
    }

    void updateTableItems(Playlist playlist) {
        if (playlist == null) {
            return;
        }
        this.currentPlaylist = playlist;
        List<PlaylistItem> items = this.currentPlaylist.getItems();
        this.clearTable();
        for (final PlaylistItem item : items) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    LibraryPlaylistsTableMediator.this.addUnsorted(item);
                }
            });
        }
        this.forceResort();
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                LibraryPlaylistsTableMediator.this.updatePlaylistComponentHeader(null);
                LibraryPlaylistsTableMediator.this.TABLE.requestFocusInWindow();
            }
        });
    }

    @Override
    public JComponent getComponent() {
        this.mainContainer = new JPanel(new MigLayout("fillx, wrap 1", "[]", "[][fill, grow]"));
        this.mainContainer.add((Component)new JPanel(), "wrap");
        this.mainContainer.add((Component)super.getComponent(), "grow");
        return this.mainContainer;
    }

    private void updatePlaylistComponentHeader(String lyrics) {
        PlaylistItem playlistItem;
        JPanel playlistHeaderRow = new JPanel(new MigLayout("insets 10, fillx", "[][grow][]"));
        LibraryCoverArtPanel artWorkLabel = new LibraryCoverArtPanel();
        if (this.currentPlaylist == null) {
            return;
        }
        if (!this.currentPlaylist.isStarred() && (playlistItem = this.currentPlaylist.getItems().get(0)) != null) {
            TagsReader tagsReader = new TagsReader(new File(playlistItem.getFilePath()));
            artWorkLabel.setTagsReader(tagsReader).asyncRetrieveImage();
        }
        Dimension artDimensions = new Dimension(210, 210);
        artWorkLabel.setPreferredSize(artDimensions);
        artWorkLabel.setMinimumSize(artDimensions);
        artWorkLabel.setMaximumSize(artDimensions);
        playlistHeaderRow.add(artWorkLabel);
        JPanel centerContainer = new JPanel(new MigLayout("fillx, wrap 1"));
        JLabel playlistSectionTitle = new JLabel(I18n.tr("Playlist"));
        JLabel playlistTitle = new JLabel(this.currentPlaylist.getName());
        Font font = new Font("Helvetica", 1, 30);
        playlistTitle.setFont(font);
        JLabel duration = new JLabel(LibraryUtils.getPlaylistDurationInDDHHMMSS(this.currentPlaylist) + ", " + this.currentPlaylist.getItems().size() + " " + I18n.tr("tracks"));
        centerContainer.add((Component)playlistSectionTitle, "wrap");
        centerContainer.add((Component)playlistTitle, "wrap");
        centerContainer.add(duration);
        playlistHeaderRow.add((Component)centerContainer, "alignx left, aligny top, growx, pushx");
        if (lyrics != null && !lyrics.isEmpty()) {
            JPanel lyricsPanel = this.createLyricsPanel(lyrics);
            playlistHeaderRow.add((Component)lyricsPanel, "aligny top");
        }
        this.mainContainer.removeAll();
        this.mainContainer.add((Component)playlistHeaderRow, "wrap, growx");
        this.mainContainer.add((Component)super.getComponent(), "grow");
        this.mainContainer.invalidate();
        this.mainContainer.repaint();
        this.mainContainer.updateUI();
    }

    private JPanel createLyricsPanel(String lyrics) {
        int[] sel = this.TABLE.getSelectedRows();
        String songTitle = "";
        if (sel.length == 1) {
            PlaylistItem playlistItem = this.currentPlaylist.getItems().get(sel[0]);
            songTitle = playlistItem.getTrackTitle() + " ";
        }
        JPanel lyricsPanel = new JPanel(new MigLayout("fillx, wrap 1, insets 0", "[]"));
        lyricsPanel.add((Component)new JLabel(songTitle + I18n.tr("Lyrics")), "wrap");
        JTextArea lyricsTextArea = new JTextArea(lyrics);
        lyricsTextArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane(lyricsTextArea);
        Dimension d = new Dimension(500, 210);
        scrollPane.setPreferredSize(d);
        scrollPane.setMaximumSize(d);
        scrollPane.setMaximumSize(d);
        lyricsPanel.add((Component)scrollPane, "growx");
        return lyricsPanel;
    }

    File getFile(int row) {
        return ((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(row);
    }

    JTable getTable() {
        return this.TABLE;
    }

    private LibraryPlaylistsTableDataLine[] getSelectedLibraryLines() {
        int[] selected = this.TABLE.getSelectedRows();
        LibraryPlaylistsTableDataLine[] lines = new LibraryPlaylistsTableDataLine[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            lines[i] = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(selected[i]);
        }
        return lines;
    }

    @Override
    public void removeSelection() {
        LibraryPlaylistsTableDataLine[] lines = this.getSelectedLibraryLines();
        if (this.currentPlaylist != null && this.currentPlaylist.getId() == -3) {
            for (LibraryPlaylistsTableDataLine line : lines) {
                PlaylistItem playlistItem = (PlaylistItem)line.getInitializeObject();
                playlistItem.setStarred(false);
                playlistItem.save(true);
            }
            LibraryMediator.instance().getLibraryExplorer().refreshSelection();
        } else {
            for (LibraryPlaylistsTableDataLine line : lines) {
                PlaylistItem playlistItem = (PlaylistItem)line.getInitializeObject();
                playlistItem.delete();
            }
            LibraryMediator.instance().getLibraryPlaylists().reselectPlaylist();
            this.clearSelection();
        }
        super.removeSelection();
    }

    @Override
    public void handleActionKey() {
        this.playMedia();
    }

    private void playMedia() {
        LibraryPlaylistsTableDataLine line = (LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (line == null || line.getPlayListItem() == null) {
            return;
        }
        MediaSource mediaSource = new MediaSource(line.getPlayListItem());
        if (MediaPlayer.isPlayableFile(mediaSource)) {
            MediaPlayer.instance().asyncLoadMedia(mediaSource, true, this.currentPlaylist, this.getFilesView());
            this.uxLogPlayFromPlaylists();
        }
    }

    private void launch(boolean playMedia) {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        File selectedFile = ((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(rows[0]);
        if (OSUtils.isWindows()) {
            if (selectedFile.isDirectory()) {
                GUIMediator.launchExplorer(selectedFile);
                return;
            }
            if (!MediaPlayer.isPlayableFile(selectedFile)) {
                GUIMediator.launchFile(selectedFile);
                return;
            }
        }
        GUILauncher.LaunchableProvider[] providers = new GUILauncher.LaunchableProvider[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            providers[i] = new FileProvider(((LibraryPlaylistsTableModel)this.DATA_MODEL).getFile(rows[i]));
        }
        if (!playMedia) {
            MediaPlayer.instance().stop();
        }
        if (playMedia) {
            GUILauncher.launch(providers);
            this.uxLogPlayFromPlaylists();
        } else {
            GUIMediator.launchFile(selectedFile);
        }
    }

    private void uxLogPlayFromPlaylists() {
        if (this.currentPlaylist != null) {
            UXStats.instance().log(this.currentPlaylist.isStarred() ? 4003 : 4002);
        }
    }

    @Override
    public void handleSelection(int row) {
        int[] sel = this.TABLE.getSelectedRows();
        if (sel.length == 0) {
            this.handleNoSelection();
            return;
        }
        File selectedFile = this.getFile(sel[0]);
        LAUNCH_ACTION.setEnabled(true);
        LAUNCH_OS_ACTION.setEnabled(true);
        DELETE_ACTION.setEnabled(true);
        SEND_TO_ITUNES_ACTION.setEnabled(true);
        if (!selectedFile.getName().endsWith(".torrent")) {
            CREATE_TORRENT_ACTION.setEnabled(sel.length == 1);
        }
        this.SEND_TO_FRIEND_ACTION.setEnabled(sel.length == 1);
        if (sel.length == 1 && selectedFile.isFile() && selectedFile.getParentFile() != null) {
            OPEN_IN_FOLDER_ACTION.setEnabled(true);
        } else {
            OPEN_IN_FOLDER_ACTION.setEnabled(false);
        }
        if (sel.length == 1) {
            TagsReader tagsReader = new TagsReader(selectedFile);
            LibraryMediator.instance().getLibraryCoverArtPanel().setTagsReader(tagsReader).asyncRetrieveImage();
            LibraryUtils.asyncParseLyrics(tagsReader, new LibraryUtils.OnLyricsParsedUICallback(){

                @Override
                public void run() {
                    LibraryPlaylistsTableMediator.this.updatePlaylistComponentHeader(this.getLyrics());
                    LibraryPlaylistsTableMediator.this.TABLE.requestFocusInWindow();
                }
            });
        }
        this.TABLE.requestFocusInWindow();
    }

    @Override
    public void handleNoSelection() {
        LAUNCH_ACTION.setEnabled(false);
        LAUNCH_OS_ACTION.setEnabled(false);
        OPEN_IN_FOLDER_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        CREATE_TORRENT_ACTION.setEnabled(false);
        DELETE_ACTION.setEnabled(false);
        SEND_TO_ITUNES_ACTION.setEnabled(false);
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    @Override
    public List<MediaSource> getFilesView() {
        int size = ((LibraryPlaylistsTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<MediaSource> result = new ArrayList<MediaSource>(size);
        for (int i = 0; i < size; ++i) {
            try {
                result.add(new MediaSource(((LibraryPlaylistsTableDataLine)((LibraryPlaylistsTableModel)this.DATA_MODEL).get(i)).getPlayListItem()));
                continue;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    @Override
    protected void sortAndMaintainSelection(int columnToSort) {
        super.sortAndMaintainSelection(columnToSort);
        this.resetAudioPlayerFileView();
    }

    private void resetAudioPlayerFileView() {
        Playlist playlist = MediaPlayer.instance().getCurrentPlaylist();
        if (playlist != null && playlist.equals(this.currentPlaylist) && MediaPlayer.instance().getPlaylistFilesView() != null) {
            MediaPlayer.instance().setPlaylistFilesView(this.getFilesView());
        }
    }

    @Override
    protected MediaSource createMediaSource(LibraryPlaylistsTableDataLine line) {
        return new MediaSource((PlaylistItem)line.getInitializeObject());
    }

    private final class RefreshID3TagsAction
    extends AbstractAction {
        private static final long serialVersionUID = 758150680592618044L;

        RefreshID3TagsAction() {
            this.putValue("Name", I18n.tr("Refresh Audio Properties"));
            this.putValue("ShortDescription", I18n.tr("Refresh the audio properties based on ID3 tags"));
            this.putValue("LimeIconName", "PLAYLIST_REFRESHID3TAGS");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylistsTableDataLine[] lines = LibraryPlaylistsTableMediator.this.getSelectedLibraryLines();
            ArrayList<PlaylistItem> items = new ArrayList<PlaylistItem>(lines.length);
            for (LibraryPlaylistsTableDataLine line : lines) {
                items.add((PlaylistItem)line.getInitializeObject());
            }
            LibraryUtils.refreshID3Tags(LibraryPlaylistsTableMediator.this.currentPlaylist, items);
        }
    }

    private final class CleanupPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 8400749433148927596L;

        CleanupPlaylistAction() {
            this.putValue("Name", I18n.tr("Cleanup playlist"));
            this.putValue("ShortDescription", I18n.tr("Remove the deleted items"));
            this.putValue("LimeIconName", "PLAYLIST_CLEANUP");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryUtils.cleanup(LibraryPlaylistsTableMediator.this.currentPlaylist);
            LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
        }
    }

    private final class ExportPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = 6149822357662730490L;

        ExportPlaylistAction() {
            this.putValue("Name", I18n.tr("Export Playlist to .m3u"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into a .m3u file"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryMediator.instance().getLibraryPlaylists().exportM3U(LibraryPlaylistsTableMediator.this.currentPlaylist);
        }
    }

    private final class ImportToPlaylistAction
    extends AbstractAction {
        private static final long serialVersionUID = -9099898749358019734L;

        ImportToPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file into the selected playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_TO");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryMediator.instance().getLibraryPlaylists().importM3U(LibraryPlaylistsTableMediator.this.currentPlaylist);
        }
    }

    private static class FileProvider
    implements GUILauncher.LaunchableProvider {
        private final File _file;

        FileProvider(File file) {
            this._file = file;
        }

        @Override
        public File getFile() {
            return this._file;
        }
    }

    private final class RemoveFromPlaylistAction
    extends AbstractAction {
        RemoveFromPlaylistAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files from this playlist"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryPlaylistsTableMediator.this.REMOVE_LISTENER.actionPerformed(ae);
        }
    }

    private class SendAudioFilesToiTunes
    extends AbstractAction {
        private static final long serialVersionUID = 4726989286129406765L;

        SendAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send audio files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = LibraryPlaylistsTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> files = new ArrayList<File>();
            for (int index : rows) {
                File file = ((LibraryPlaylistsTableModel)LibraryPlaylistsTableMediator.this.DATA_MODEL).getFile(index);
                files.add(file);
            }
            if (!files.isEmpty()) {
                iTunesMediator.instance().scanForSongs(files.toArray(new File[0]));
            }
        }
    }

    private final class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1898917632888388860L;

        CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            File selectedFile = ((LibraryPlaylistsTableModel)LibraryPlaylistsTableMediator.this.DATA_MODEL).getFile(LibraryPlaylistsTableMediator.this.TABLE.getSelectedRow());
            if (selectedFile.isDirectory() && selectedFile.listFiles() != null && selectedFile.listFiles().length == 0) {
                JOptionPane.showMessageDialog(null, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
                return;
            }
            if (!selectedFile.canRead()) {
                JOptionPane.showMessageDialog(null, I18n.tr("Error: You can't read on that file/folder."), I18n.tr("Error"), 0);
                return;
            }
            CreateTorrentDialog dlg = new CreateTorrentDialog(GUIMediator.getAppFrame());
            dlg.setChosenContent(selectedFile, selectedFile.isFile() ? 0 : 1);
            dlg.setVisible(true);
        }
    }

    private final class OpenInFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1693310684299300459L;

        OpenInFolderAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] sel = LibraryPlaylistsTableMediator.this.TABLE.getSelectedRows();
            if (sel.length == 0) {
                return;
            }
            File selectedFile = LibraryPlaylistsTableMediator.this.getFile(sel[0]);
            if (selectedFile.isFile() && selectedFile.getParentFile() != null) {
                GUIMediator.launchExplorer(selectedFile);
            }
        }
    }

    private final class LaunchOSAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392592L;

        LaunchOSAction() {
            String os = "OS";
            if (OSUtils.isWindows()) {
                os = "Windows";
            } else if (OSUtils.isMacOSX()) {
                os = "Mac";
            } else if (OSUtils.isLinux()) {
                os = "Linux";
            }
            this.putValue("Name", I18n.tr("Launch in") + " " + os);
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files in") + " " + os);
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryPlaylistsTableMediator.this.launch(false);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryPlaylistsTableMediator.this.launch(true);
        }
    }
}

