/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.AbstractLibraryListPanel;
import com.frostwire.gui.library.LibraryIconList;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTransferHandler;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.M3UPlaylist;
import com.frostwire.gui.library.SortedListModel;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.options.ConfigureOptionsAction;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.InsetsUIResource;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class LibraryPlaylists
extends AbstractLibraryListPanel {
    private DefaultListModel<Object> model;
    private int selectedIndexToRename;
    private LibraryPlaylistsListCell newPlaylistCell;
    private LibraryPlaylistsListCell starredPlaylistCell;
    private ActionListener selectedPlaylistAction;
    private ListSelectionListener listSelectionListener;
    private JList<Object> list;
    private JTextField textName;
    private final byte REFRESH_ACTION = 0;
    private final byte REFRESH_ID3_TAGS_ACTION = 1;
    private final byte DELETE_ACTION = (byte)2;
    private final byte CLEANUP_PLAYLIST_ACTION = (byte)3;
    private final byte RENAME_ACTION = (byte)4;
    private final byte IMPORT_TO_PLAYLIST_ACTION = (byte)5;
    private final byte IMPORT_TO_NEW_PLAYLIST_ACTION = (byte)6;
    private final byte CONFIGURE_OPTIONS_ACTION = (byte)10;
    private Action[] actions;
    private List<Playlist> importingPlaylists;

    LibraryPlaylists() {
        this.setupUI();
        this.importingPlaylists = new ArrayList<Playlist>();
    }

    void addPlaylist(Playlist playlist) {
        LibraryPlaylistsListCell cell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this.selectedPlaylistAction);
        this.model.addElement(cell);
    }

    public void clearSelection() {
        this.list.clearSelection();
    }

    Playlist getSelectedPlaylist() {
        LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)this.list.getSelectedValue();
        return cell != null ? cell.getPlaylist() : null;
    }

    protected void setupUI() {
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(177, 94));
        GUIMediator.addRefreshListener(this);
        this.initPopupMenuActions();
        LibraryUtils.getExecutor().execute(() -> {
            this.setupModel();
            GUIMediator.safeInvokeLater(() -> {
                this.setupList();
                JScrollPane _scrollPane = new JScrollPane(this.list);
                this.add(_scrollPane);
            });
        });
    }

    private void initPopupMenuActions() {
        this.actions = new Action[]{new RefreshAction(), new RefreshID3TagsAction(), new DeleteAction(), new CleanupPlaylistAction(), new StartRenamingPlaylistAction(), new ImportToPlaylistAction(), new ImportToNewPlaylistAction(), new CopyPlaylistFilesAction(), new ExportPlaylistAction(), new ExportToiTunesAction(), new ConfigureOptionsAction("OPTIONS_LIBRARY_MAIN_TITLE", I18n.tr("Configure Options"), I18n.tr("You can configure the FrostWire's Options."))};
    }

    private SkinPopupMenu getStarredPlaylistPopupMenu(Playlist playlist) {
        boolean playlistEmpty;
        SkinPopupMenu starredPlaylistPopupMenu = new SkinPopupMenu();
        List<PlaylistItem> items = playlist.getItems();
        boolean bl = playlistEmpty = items == null || items.size() == 0;
        if (!playlistEmpty) {
            starredPlaylistPopupMenu.add(new SkinMenuItem(this.actions[3]));
        }
        starredPlaylistPopupMenu.add(new SkinMenuItem(this.actions[0]));
        if (!playlistEmpty) {
            starredPlaylistPopupMenu.add(new SkinMenuItem(this.actions[1]));
        }
        starredPlaylistPopupMenu.addSeparator();
        starredPlaylistPopupMenu.add(new SkinMenuItem(this.actions[5]));
        this.addExportActionsToPopupMenu(starredPlaylistPopupMenu, playlistEmpty);
        starredPlaylistPopupMenu.addSeparator();
        starredPlaylistPopupMenu.add(new SkinMenuItem(this.actions[10]));
        return starredPlaylistPopupMenu;
    }

    private SkinPopupMenu getPlaylistPopupMenu(Playlist playlist) {
        SkinPopupMenu playlistPopup = new SkinPopupMenu();
        List<PlaylistItem> items = playlist.getItems();
        boolean playlistEmpty = items == null || items.size() == 0;
        playlistPopup.add(new SkinMenuItem(this.actions[0]));
        if (!playlistEmpty) {
            playlistPopup.add(new SkinMenuItem(this.actions[1]));
        }
        playlistPopup.addSeparator();
        playlistPopup.add(new SkinMenuItem(this.actions[4]));
        playlistPopup.add(new SkinMenuItem(this.actions[2]));
        if (!playlistEmpty) {
            playlistPopup.add(new SkinMenuItem(this.actions[3]));
        }
        playlistPopup.addSeparator();
        playlistPopup.add(new SkinMenuItem(this.actions[5]));
        playlistPopup.add(new SkinMenuItem(this.actions[6]));
        this.addExportActionsToPopupMenu(playlistPopup, playlistEmpty);
        playlistPopup.addSeparator();
        playlistPopup.add(new SkinMenuItem(this.actions[10]));
        return playlistPopup;
    }

    private SkinPopupMenu getNewPlaylistPopupMenu() {
        SkinPopupMenu popupMenu = new SkinPopupMenu();
        popupMenu.add(new SkinMenuItem(this.actions[6]));
        popupMenu.add(new SkinMenuItem(this.actions[10]));
        return popupMenu;
    }

    private void addExportActionsToPopupMenu(SkinPopupMenu playlistPopup, boolean playlistEmpty) {
        if (!playlistEmpty) {
            playlistPopup.addSeparator();
            int COPY_PLAYLIST_FILES_ACTION = 7;
            playlistPopup.add(new SkinMenuItem(this.actions[COPY_PLAYLIST_FILES_ACTION]));
            int EXPORT_PLAYLIST_ACTION = 8;
            playlistPopup.add(new SkinMenuItem(this.actions[EXPORT_PLAYLIST_ACTION]));
            playlistPopup.addSeparator();
            if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
                int EXPORT_TO_ITUNES_ACTION = 9;
                playlistPopup.add(new SkinMenuItem(this.actions[EXPORT_TO_ITUNES_ACTION]));
            }
        }
    }

    private void setupModel() {
        this.model = new DefaultListModel();
        this.newPlaylistCell = new LibraryPlaylistsListCell(I18n.tr("New Playlist"), I18n.tr("Creates a new Playlist"), GUIMediator.getThemeImage("playlist_plus"), null, null);
        Library library = LibraryMediator.getLibrary();
        this.selectedPlaylistAction = new SelectedPlaylistActionListener();
        Playlist starredPlaylist = LibraryMediator.getLibrary().getStarredPlaylist();
        this.starredPlaylistCell = new LibraryPlaylistsListCell(I18n.tr("Starred"), I18n.tr("Show all starred items"), GUIMediator.getThemeImage("star_on"), starredPlaylist, this.selectedPlaylistAction);
        this.model.addElement(this.newPlaylistCell);
        this.model.addElement(this.starredPlaylistCell);
        for (Playlist playlist : library.getPlaylists()) {
            LibraryPlaylistsListCell cell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this.selectedPlaylistAction);
            this.model.addElement(cell);
        }
    }

    private void setupList() {
        LibraryPlaylistsMouseObserver _listMouseObserver = new LibraryPlaylistsMouseObserver();
        this.listSelectionListener = new LibraryPlaylistsSelectionListener();
        SortedListModel sortedModel = new SortedListModel(this.model, SortedListModel.SortOrder.ASCENDING, (o1, o2) -> {
            if (o1 == this.newPlaylistCell || o1 == this.starredPlaylistCell) {
                return -1;
            }
            if (o2 == this.newPlaylistCell || o2 == this.starredPlaylistCell) {
                return 1;
            }
            return o1.getText().compareTo(o2.getText());
        });
        this.list = new LibraryIconList(sortedModel);
        this.list.setFixedCellHeight(TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue());
        this.list.setCellRenderer(new LibraryPlaylistsCellRenderer());
        this.list.addMouseListener(new DefaultMouseListener(_listMouseObserver));
        this.list.addListSelectionListener(this.listSelectionListener);
        this.list.setSelectionMode(2);
        this.list.setLayoutOrientation(0);
        this.list.setPrototypeCellValue(new LibraryPlaylistsListCell("test", "", GUIMediator.getThemeImage("playlist"), null, null));
        this.list.setVisibleRowCount(-1);
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new LibraryPlaylistsTransferHandler(this.list));
        ToolTipManager.sharedInstance().registerComponent(this.list);
        this.list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                LibraryPlaylists.this.list_keyPressed(e);
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    LibraryPlaylists.this.actionStartRename();
                }
            }
        });
        this.textName = new JTextField();
        ThemeMediator.fixKeyStrokes(this.textName);
        UIDefaults defaults = new UIDefaults();
        defaults.put("TextField.contentMargins", new InsetsUIResource(0, 4, 0, 4));
        this.textName.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
        this.textName.putClientProperty("Nimbus.Overrides", defaults);
        this.textName.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                LibraryPlaylists.this.textName_keyPressed(e);
            }
        });
        this.textName.setVisible(false);
        this.list.add(this.textName);
    }

    private void list_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 27) {
            this.cancelEdit();
        } else if (key == 10) {
            if (OSUtils.isMacOSX()) {
                this.actionStartRename();
            }
        } else if (key == 113) {
            if (!OSUtils.isMacOSX()) {
                this.actionStartRename();
            }
        } else if (key == 127 || OSUtils.isMacOSX() && key == 8) {
            this.actions[2].actionPerformed(null);
        }
        if (LibraryUtils.isRefreshKeyEvent(e)) {
            this.refreshSelection();
        }
    }

    private void textName_keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (this.selectedIndexToRename != -1 && key == 10) {
            this.renameSelectedItem();
        } else if (this.selectedIndexToRename == -1 && key == 10) {
            this.createNewPlaylist();
        } else if (key == 27) {
            this.textName.setVisible(false);
        }
    }

    void refreshSelection() {
        LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)this.list.getSelectedValue();
        if (cell == null) {
            if (this.model.getSize() == 2 && MediaPlayer.instance().getCurrentPlaylist() == null) {
                this.list.setSelectedIndex(1);
            }
            return;
        }
        Playlist playlist = cell.getPlaylist();
        if (playlist != null) {
            if (playlist.getId() == -3) {
                playlist = LibraryMediator.getLibrary().getStarredPlaylist();
            } else {
                playlist.refresh();
            }
            LibraryMediator.instance().updateTableItems(playlist);
            LibraryMediator.instance().getLibrarySearch().setStatus("");
        }
        this.executePendingRunnables();
    }

    private void actionStartRename() {
        this.cancelEdit();
        int index = this.list.getSelectedIndex();
        Playlist playlist = ((LibraryPlaylistsListCell)this.list.getSelectedValue()).getPlaylist();
        if (playlist != null && playlist.getId() == -3) {
            return;
        }
        if (index != -1) {
            this.startEdit(index);
        }
    }

    private void startEdit(int index) {
        if (index < 0) {
            return;
        }
        LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)this.model.getElementAt(index);
        this.selectedIndexToRename = cell.getPlaylist() != null ? index : -1;
        String text = cell.getText();
        Rectangle rect = this.list.getUI().getCellBounds(this.list, index, index);
        Dimension size = rect.getSize();
        Point location = rect.getLocation();
        this.textName.setSize(size);
        this.textName.setLocation(location);
        this.textName.setText(text);
        this.textName.setSelectionStart(0);
        this.textName.setSelectionEnd(text.length());
        this.textName.setVisible(true);
        this.textName.requestFocusInWindow();
        this.textName.requestFocus();
    }

    void selectPlaylist(Playlist playlist) {
        Object selectedValue = this.list.getSelectedValue();
        if (selectedValue != null && ((LibraryPlaylistsListCell)selectedValue).getPlaylist() != null && ((LibraryPlaylistsListCell)selectedValue).getPlaylist().equals(playlist)) {
            try {
                this.listSelectionListener.valueChanged(null);
            }
            catch (Exception e) {
                System.out.println();
            }
            return;
        }
        int size = this.model.getSize();
        for (int i = 0; i < size; ++i) {
            try {
                LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)this.model.get(i);
                if (cell.getPlaylist() == null || !cell.getPlaylist().equals(playlist)) continue;
                this.list.setSelectedValue(cell, true);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void renameSelectedItem() {
        if (!this.textName.isVisible() || this.textName.getText().trim().length() == 0) {
            return;
        }
        Playlist selectedPlaylist = this.getSelectedPlaylist();
        selectedPlaylist.setName(this.textName.getText().trim());
        selectedPlaylist.save();
        this.list.repaint();
        this.textName.setVisible(false);
        UXStats.instance().log(4008);
        LibraryPlaylistsTableMediator.instance().updateTableItems(selectedPlaylist);
    }

    private void createNewPlaylist() {
        if (!this.textName.isVisible()) {
            return;
        }
        String name = this.textName.getText();
        Library library = LibraryMediator.getLibrary();
        Playlist playlist = library.newPlaylist(name, name);
        playlist.save();
        LibraryPlaylistsListCell cell = new LibraryPlaylistsListCell(null, null, GUIMediator.getThemeImage("playlist"), playlist, this.selectedPlaylistAction);
        this.model.addElement(cell);
        this.list.setSelectedValue(cell, true);
        this.textName.setVisible(false);
        UXStats.instance().log(4006);
    }

    private void cancelEdit() {
        this.selectedIndexToRename = -1;
        this.textName.setVisible(false);
    }

    void importM3U(Playlist playlist) {
        File selFile;
        File parentFile = FileChooserHandler.getLastInputDirectory();
        if (parentFile == null) {
            parentFile = CommonUtils.getCurrentDirectory();
        }
        if ((selFile = FileChooserHandler.getInputFile((Component)GUIMediator.getAppFrame(), I18n.tr("Open Playlist (.m3u)"), parentFile, new PlaylistListFileFilter())) == null || !selFile.isFile()) {
            return;
        }
        String path = selFile.getPath();
        try {
            path = FileUtils.getCanonicalPath(selFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.loadM3U(playlist, path);
    }

    private void loadM3U(Playlist playlist, String path) {
        BackgroundExecutorService.schedule(() -> {
            try {
                List<File> files = M3UPlaylist.load(path);
                if (playlist != null) {
                    LibraryUtils.asyncAddToPlaylist(playlist, files.toArray(new File[0]));
                } else {
                    LibraryUtils.createNewPlaylist(files.toArray(new File[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIMediator.safeInvokeLater(() -> GUIMediator.showError("Unable to load playlist"));
            }
        });
    }

    void exportM3U(Playlist playlist) {
        DialogOption choice;
        if (playlist == null) {
            return;
        }
        String suggestedName = CommonUtils.convertFileName(playlist.getName());
        File suggestedDirectory = FileChooserHandler.getLastInputDirectory();
        if (suggestedDirectory.equals(CommonUtils.getCurrentDirectory())) {
            suggestedDirectory = new File(CommonUtils.getUserHomeDir(), "Desktop");
        }
        File suggested = new File(suggestedDirectory, suggestedName + ".m3u");
        File selFile = FileChooserHandler.getSaveAsFile(GUIMediator.getAppFrame(), I18n.tr("Save Playlist As"), suggested, new PlaylistListFileFilter());
        if (selFile == null) {
            return;
        }
        if (selFile.exists() && (choice = GUIMediator.showYesNoMessage(I18n.tr("Warning: a file with the name {0} already exists in the folder. Overwrite this file?", selFile.getName()), QuestionsHandler.PLAYLIST_OVERWRITE_OK, DialogOption.NO)) != DialogOption.YES) {
            return;
        }
        String path = selFile.getPath();
        try {
            path = FileUtils.getCanonicalPath(selFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!path.toLowerCase().endsWith(".m3u")) {
            path = path + ".m3u";
        }
        this.saveM3U(playlist, path);
    }

    private void saveM3U(Playlist playlist, String path) {
        BackgroundExecutorService.schedule(() -> {
            try {
                ArrayList<File> files = new ArrayList<File>();
                List<PlaylistItem> items = playlist.getItems();
                for (PlaylistItem item : items) {
                    File file = new File(item.getFilePath());
                    if (!file.exists()) continue;
                    files.add(file);
                }
                M3UPlaylist.save(path, files);
            }
            catch (Exception e) {
                e.printStackTrace();
                GUIMediator.safeInvokeLater(() -> GUIMediator.showError("Unable to save playlist"));
            }
        });
    }

    void reselectPlaylist() {
        this.listSelectionListener.valueChanged(null);
    }

    @Override
    public void refresh() {
        if (this.list != null) {
            this.list.repaint();
        }
    }

    void markBeginImport(Playlist playlist) {
        try {
            if (!this.importingPlaylists.contains(playlist)) {
                this.importingPlaylists.add(playlist);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void markEndImport(Playlist playlist) {
        try {
            this.importingPlaylists.remove(playlist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    boolean isPlaylistImporting(Playlist playlist) {
        try {
            return this.importingPlaylists.contains(playlist);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final class ExportToiTunesAction
    extends AbstractAction {
        ExportToiTunesAction() {
            this.putValue("Name", I18n.tr("Export Playlist to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into an iTunes playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                ArrayList<File> files = new ArrayList<File>();
                for (PlaylistItem item : playlist.getItems()) {
                    File file = new File(item.getFilePath());
                    files.add(file);
                }
                iTunesMediator.instance().addSongsiTunes(playlist.getName(), files.toArray(new File[0]));
            }
        }
    }

    private final class ExportPlaylistAction
    extends AbstractAction {
        ExportPlaylistAction() {
            this.putValue("Name", I18n.tr("Export Playlist to .m3u"));
            this.putValue("ShortDescription", I18n.tr("Export this playlist into a .m3u file"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylists.this.exportM3U(LibraryPlaylists.this.getSelectedPlaylist());
        }
    }

    public static final class CopyPlaylistFilesAction
    extends AbstractAction {
        CopyPlaylistFilesAction() {
            this.putValue("Name", I18n.tr("Export playlist files to folder"));
            this.putValue("ShortDescription", I18n.tr("Copy all playlist files to a folder of your choosing"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.copyPlaylistFilesToFolder(LibraryMediator.instance().getSelectedPlaylist());
        }

        private void copyPlaylistFilesToFolder(Playlist playlist) {
            File selFolder;
            if (playlist == null || playlist.getItems().isEmpty()) {
                return;
            }
            File suggestedDirectory = FileChooserHandler.getLastInputDirectory();
            if (suggestedDirectory.equals(CommonUtils.getCurrentDirectory())) {
                suggestedDirectory = new File(CommonUtils.getUserHomeDir(), "Desktop");
            }
            if ((selFolder = FileChooserHandler.getSaveAsDir(GUIMediator.getAppFrame(), I18n.tr("Where do you want the playlist files copied to?"), suggestedDirectory)) == null) {
                return;
            }
            final ArrayList<PlaylistItem> playlistItems = new ArrayList<PlaylistItem>(playlist.getItems());
            BackgroundExecutorService.schedule(new Thread("Library-copy-playlist-files"){

                @Override
                public void run() {
                    int n = 0;
                    int total = playlistItems.size();
                    String targetName = selFolder.getName();
                    for (PlaylistItem item : playlistItems) {
                        File f = new File(item.getFilePath());
                        if (!f.isFile() || !f.exists() || !f.canRead()) continue;
                        try {
                            Path source = f.toPath();
                            Path target = FileSystems.getDefault().getPath(selFolder.getAbsolutePath(), f.getName());
                            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                            String status = String.format("Copied %d of %d to %s", ++n, total, targetName);
                            LibraryMediator.instance().getLibrarySearch().pushStatus(status);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    GUIMediator.launchExplorer(selFolder);
                    try {
                        Thread.sleep(2000L);
                        LibraryMediator.instance().getLibrarySearch().pushStatus("");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private final class ImportToNewPlaylistAction
    extends AbstractAction {
        ImportToNewPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to New Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file to a new playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_NEW");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylists.this.importM3U(null);
        }
    }

    private final class ImportToPlaylistAction
    extends AbstractAction {
        ImportToPlaylistAction() {
            this.putValue("Name", I18n.tr("Import .m3u to Playlist"));
            this.putValue("ShortDescription", I18n.tr("Import a .m3u file into the selected playlist"));
            this.putValue("LimeIconName", "PLAYLIST_IMPORT_TO");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylists.this.importM3U(LibraryPlaylists.this.getSelectedPlaylist());
        }
    }

    private static class PlaylistListFileFilter
    extends FileFilter {
        private PlaylistListFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase().endsWith("m3u");
        }

        @Override
        public String getDescription() {
            return I18n.tr("Playlist Files (*.m3u)");
        }
    }

    private class StartRenamingPlaylistAction
    extends AbstractAction {
        StartRenamingPlaylistAction() {
            this.putValue("Name", I18n.tr("Rename"));
            this.putValue("ShortDescription", I18n.tr("Rename Playlist"));
            this.putValue("LimeIconName", "PLAYLIST_RENAME");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((LibraryPlaylistsListCell)LibraryPlaylists.this.list.getSelectedValue()).getPlaylist().getId() != -3) {
                LibraryPlaylists.this.startEdit(LibraryPlaylists.this.list.getSelectedIndex());
            }
        }
    }

    private final class CleanupPlaylistAction
    extends AbstractAction {
        CleanupPlaylistAction() {
            this.putValue("Name", I18n.tr("Cleanup playlist"));
            this.putValue("ShortDescription", I18n.tr("Remove the deleted items"));
            this.putValue("LimeIconName", "PLAYLIST_CLEANUP");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Playlist selectedPlaylist = LibraryPlaylists.this.getSelectedPlaylist();
            if (selectedPlaylist != null) {
                LibraryUtils.cleanup(selectedPlaylist);
                LibraryMediator.instance().getLibraryPlaylists().refreshSelection();
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        DeleteAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Playlist"));
            this.putValue("LimeIconName", "PLAYLIST_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Playlist selectedPlaylist = LibraryPlaylists.this.getSelectedPlaylist();
            if (selectedPlaylist != null && selectedPlaylist.getId() != -3) {
                DialogOption showConfirmDialog = GUIMediator.showYesNoMessage(I18n.tr("Are you sure you want to delete the playlist?\n(No files will be deleted)"), I18n.tr("Are you sure?"), 3);
                if (showConfirmDialog != DialogOption.YES) {
                    return;
                }
                selectedPlaylist.delete();
                LibraryPlaylists.this.model.removeElement(LibraryPlaylists.this.list.getSelectedValue());
                LibraryMediator.instance().clearLibraryTable();
                UXStats.instance().log(4007);
            }
        }
    }

    private class RefreshID3TagsAction
    extends AbstractAction {
        RefreshID3TagsAction() {
            this.putValue("Name", I18n.tr("Refresh Audio Properties"));
            this.putValue("ShortDescription", I18n.tr("Refresh the audio properties based on ID3 tags of selected items"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Playlist playlist = LibraryPlaylists.this.getSelectedPlaylist();
            if (playlist != null) {
                LibraryUtils.refreshID3Tags(playlist);
            }
        }
    }

    private class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            this.putValue("Name", I18n.tr("Refresh"));
            this.putValue("ShortDescription", I18n.tr("Refresh selected"));
            this.putValue("LimeIconName", "LIBRARY_REFRESH");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylists.this.refreshSelection();
        }
    }

    private class LibraryPlaylistsSelectionListener
    implements ListSelectionListener {
        private LibraryPlaylistsSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            LibraryPlaylists.this.cancelEdit();
            if (e != null && e.getValueIsAdjusting()) {
                return;
            }
            LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)LibraryPlaylists.this.list.getSelectedValue();
            if (cell == null) {
                return;
            }
            LibraryMediator.instance().getLibraryExplorer().clearSelection();
            if (cell.getAction() != null) {
                cell.getAction().actionPerformed(null);
            }
        }
    }

    private class LibraryPlaylistsMouseObserver
    implements MouseObserver {
        private LibraryPlaylistsMouseObserver() {
        }

        @Override
        public void handleMouseClick(MouseEvent e) {
            int index = LibraryPlaylists.this.list.locationToIndex(e.getPoint());
            LibraryPlaylists.this.list.setSelectedIndex(index);
            if (((LibraryPlaylistsListCell)LibraryPlaylists.this.list.getSelectedValue()).getPlaylist() == null) {
                LibraryPlaylists.this.actionStartRename();
            }
        }

        @Override
        public void handleMouseDoubleClick(MouseEvent e) {
        }

        @Override
        public void handleRightMouseClick(MouseEvent e) {
        }

        @Override
        public void handlePopupMenu(MouseEvent e) {
            LibraryPlaylists.this.list.setSelectedIndex(LibraryPlaylists.this.list.locationToIndex(e.getPoint()));
            LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)LibraryPlaylists.this.list.getSelectedValue();
            Playlist playlist = cell.getPlaylist();
            SkinPopupMenu popup = playlist == null ? LibraryPlaylists.this.getNewPlaylistPopupMenu() : (playlist.getId() == -3 ? LibraryPlaylists.this.getStarredPlaylistPopupMenu(playlist) : LibraryPlaylists.this.getPlaylistPopupMenu(playlist));
            popup.show(LibraryPlaylists.this.list, e.getX(), e.getY());
        }
    }

    private class SelectedPlaylistActionListener
    implements ActionListener {
        private SelectedPlaylistActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LibraryPlaylists.this.refreshSelection();
        }
    }

    private class LibraryPlaylistsCellRenderer
    extends DefaultListCellRenderer {
        private LibraryPlaylistsCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            LibraryPlaylistsListCell cell = (LibraryPlaylistsListCell)value;
            this.setText(cell.getText());
            this.setToolTipText(cell.getDescription());
            this.setPreferredSize(new Dimension(this.getSize().width, TableSettings.DEFAULT_TABLE_ROW_HEIGHT.getValue()));
            Icon icon = cell.getIcon();
            if (icon != null) {
                this.setIcon(icon);
                this.setBorder(new EmptyBorder(5, 5, 5, 5));
            }
            this.setFont(list.getFont());
            ThemeMediator.fixLabelFont(this);
            return this;
        }
    }

    public static class LibraryPlaylistsListCell {
        private final String _text;
        private final String _description;
        private final Icon _icon;
        private final Playlist _playlist;
        private final ActionListener _action;

        LibraryPlaylistsListCell(String text, String description, Icon icon, Playlist playlist, ActionListener action) {
            this._text = text;
            this._description = description;
            this._icon = icon;
            this._playlist = playlist;
            this._action = action;
        }

        public String getText() {
            if (this._text != null) {
                return this._text;
            }
            if (this._playlist != null && this._playlist.getName() != null) {
                return this._playlist.getName();
            }
            return "";
        }

        public String getDescription() {
            if (this._description != null) {
                return this._description;
            }
            if (this._playlist != null && this._playlist.getDescription() != null) {
                return this._playlist.getDescription();
            }
            return "";
        }

        public Icon getIcon() {
            return this._icon;
        }

        public Playlist getPlaylist() {
            return this._playlist;
        }

        public ActionListener getAction() {
            return this._action;
        }
    }
}

