/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.DirectoryHolderNode;
import com.frostwire.gui.library.FileSettingDirectoryHolder;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryNode;
import com.frostwire.gui.library.LibraryPlaylistsTableTransferable;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.StarredDirectoryHolder;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.settings.LibrarySettings;
import java.awt.datatransfer.Transferable;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.limewire.util.OSUtils;

final class LibraryFilesTransferHandler
extends TransferHandler {
    private static final Logger LOG = Logger.getLogger(LibraryFilesTransferHandler.class);
    private final JTree tree;

    LibraryFilesTransferHandler(JTree tree) {
        this.tree = tree;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        try {
            LibraryNode node = this.getNodeFromLocation(support.getDropLocation());
            if (!(node instanceof DirectoryHolderNode)) {
                return false;
            }
            DirectoryHolder dirHolder = ((DirectoryHolderNode)node).getDirectoryHolder();
            if (this.droppingFoldersToAddToLibrary(support, dirHolder, true)) {
                return true;
            }
            if (!(dirHolder instanceof MediaTypeSavedFilesDirectoryHolder)) {
                return false;
            }
            MediaTypeSavedFilesDirectoryHolder mediaTypeSavedFilesDirHolder = (MediaTypeSavedFilesDirectoryHolder)dirHolder;
            MediaType mt = mediaTypeSavedFilesDirHolder.getMediaType();
            return mt.equals(MediaType.getAudioMediaType()) && DNDUtils.supportCanImport(LibraryPlaylistsTableTransferable.ITEM_ARRAY, support, null, false);
        }
        catch (Throwable e) {
            LOG.error("Error in LibraryFilesTransferHandler processing", e);
            return false;
        }
    }

    private boolean droppingFoldersToAddToLibrary(TransferHandler.TransferSupport support, DirectoryHolder dirHolder, boolean invokingFromCanImport) {
        try {
            if (invokingFromCanImport && OSUtils.isMacOSX()) {
                return true;
            }
            return this.isSharedFolderReceiver(dirHolder) && DNDUtils.containsFileFlavors(support.getDataFlavors()) && this.areAllFilesDirectories(DNDUtils.getFiles(support.getTransferable()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean areAllFilesDirectories(File[] files) {
        boolean result = true;
        for (File f : files) {
            if (f.isDirectory()) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        try {
            Transferable transferable = support.getTransferable();
            LibraryNode node = this.getNodeFromLocation(support.getDropLocation());
            if (node instanceof DirectoryHolderNode) {
                DirectoryHolder dirHolder = ((DirectoryHolderNode)node).getDirectoryHolder();
                if (this.droppingFoldersToAddToLibrary(support, dirHolder, false)) {
                    try {
                        File[] files;
                        for (File f : files = DNDUtils.getFiles(support.getTransferable())) {
                            LibrarySettings.DIRECTORIES_TO_INCLUDE.add(f);
                            LibrarySettings.DIRECTORIES_NOT_TO_INCLUDE.remove(f);
                        }
                        LibraryMediator.instance().clearDirectoryHolderCaches();
                        GUIMediator.instance().setOptionsVisible(true, "OPTIONS_LIBRARY_MAIN_TITLE");
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            } else if (DNDUtils.contains(transferable.getTransferDataFlavors(), LibraryPlaylistsTableTransferable.ITEM_ARRAY)) {
                PlaylistItem[] playlistItems = LibraryUtils.convertToPlaylistItems((LibraryPlaylistsTableTransferable.Item[])transferable.getTransferData(LibraryPlaylistsTableTransferable.ITEM_ARRAY));
                LibraryUtils.createNewPlaylist(playlistItems, this.isStarredDirectoryHolder(support.getDropLocation()));
            } else {
                File[] files = DNDUtils.getFiles(support.getTransferable());
                if (files.length == 1 && files[0].getAbsolutePath().endsWith(".m3u")) {
                    LibraryUtils.createNewPlaylist(files[0], this.isStarredDirectoryHolder(support.getDropLocation()));
                } else {
                    LibraryUtils.createNewPlaylist(files, this.isStarredDirectoryHolder(support.getDropLocation()));
                }
            }
        }
        catch (Throwable e) {
            LOG.error("Error in LibraryFilesTransferHandler processing", e);
        }
        return false;
    }

    private boolean isSharedFolderReceiver(DirectoryHolder directoryHolder) {
        return directoryHolder instanceof MediaTypeSavedFilesDirectoryHolder || directoryHolder instanceof FileSettingDirectoryHolder;
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000003;
    }

    private boolean isStarredDirectoryHolder(TransferHandler.DropLocation location) {
        LibraryNode node = this.getNodeFromLocation(location);
        if (node instanceof DirectoryHolderNode) {
            DirectoryHolder dirHolder = ((DirectoryHolderNode)node).getDirectoryHolder();
            return dirHolder instanceof StarredDirectoryHolder;
        }
        return false;
    }

    private LibraryNode getNodeFromLocation(TransferHandler.DropLocation location) {
        TreePath path = this.tree.getUI().getClosestPathForLocation(this.tree, location.getDropPoint().x, location.getDropPoint().y);
        return path != null ? (LibraryNode)path.getLastPathComponent() : null;
    }
}

