/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.alexandria.Playlist;
import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.bittorrent.PaymentOptionsRenderer;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.AbstractLibraryTableMediator;
import com.frostwire.gui.library.DirectoryHolder;
import com.frostwire.gui.library.LibraryExplorer;
import com.frostwire.gui.library.LibraryFilesTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableModel;
import com.frostwire.gui.library.LibraryFilesTableTransferHandler;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.library.MediaTypeSavedFilesDirectoryHolder;
import com.frostwire.gui.library.PlayableCell;
import com.frostwire.gui.library.PlayableCellRenderer;
import com.frostwire.gui.library.PlayableIconCell;
import com.frostwire.gui.library.PlayableIconCellRenderer;
import com.frostwire.gui.library.tags.TagsReader;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.SkinPopupMenu;
import com.frostwire.mp4.Mp4Demuxer;
import com.frostwire.mp4.Mp4Info;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MPlayerMediator;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.SearchAction;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.search.GenericCellEditor;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.gui.util.GUILauncher;
import com.limegroup.gnutella.util.QueryUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.apache.commons.io.FilenameUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

final class LibraryFilesTableMediator
extends AbstractLibraryTableMediator<LibraryFilesTableModel, LibraryFilesTableDataLine, File> {
    private Action LAUNCH_ACTION;
    private Action LAUNCH_OS_ACTION;
    private Action OPEN_IN_FOLDER_ACTION;
    private Action DEMUX_MP4_AUDIO_ACTION;
    private Action CREATE_TORRENT_ACTION;
    private Action DELETE_ACTION;
    private Action SEND_TO_ITUNES_ACTION;
    private static LibraryFilesTableMediator INSTANCE;

    public static LibraryFilesTableMediator instance() {
        if (INSTANCE == null) {
            INSTANCE = new LibraryFilesTableMediator();
        }
        return INSTANCE;
    }

    @Override
    protected void buildListeners() {
        super.buildListeners();
        this.LAUNCH_ACTION = new LaunchAction();
        this.LAUNCH_OS_ACTION = new LaunchOSAction();
        this.OPEN_IN_FOLDER_ACTION = new OpenInFolderAction();
        this.DEMUX_MP4_AUDIO_ACTION = new DemuxMP4AudioAction();
        this.CREATE_TORRENT_ACTION = new CreateTorrentAction();
        this.DELETE_ACTION = new RemoveAction();
        this.SEND_TO_ITUNES_ACTION = new SendAudioFilesToiTunes();
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.TABLE.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (LibraryUtils.isRefreshKeyEvent(e)) {
                    LibraryMediator.instance().getLibraryExplorer().refreshSelection(true);
                }
            }
        });
    }

    @Override
    protected void setupConstants() {
        super.setupConstants();
        this.MAIN_PANEL = new PaddedPanel();
        this.DATA_MODEL = new LibraryFilesTableModel();
        ((LibraryFilesTableModel)this.DATA_MODEL).sort(6);
        ((LibraryFilesTableModel)this.DATA_MODEL).sort(6);
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        ((LibraryFilesTableModel)this.DATA_MODEL).setTable(this.TABLE);
        Action[] aa = new Action[]{this.LAUNCH_ACTION, this.OPEN_IN_FOLDER_ACTION, this.SEND_TO_FRIEND_ACTION, this.DELETE_ACTION, this.OPTIONS_ACTION};
        this.BUTTON_ROW = new ButtonRow(aa, 0, 14);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.TABLE.getSelectionModel().isSelectionEmpty()) {
            return null;
        }
        SkinPopupMenu menu = new SkinPopupMenu();
        menu.add(new SkinMenuItem(this.LAUNCH_ACTION));
        if (this.getMediaType().equals(MediaType.getAudioMediaType())) {
            menu.add(new SkinMenuItem(this.LAUNCH_OS_ACTION));
        }
        if (this.hasExploreAction()) {
            menu.add(new SkinMenuItem(this.OPEN_IN_FOLDER_ACTION));
        }
        if (this.areAllSelectedFilesMP4s()) {
            ((JPopupMenu)menu).add(this.DEMUX_MP4_AUDIO_ACTION);
            this.DEMUX_MP4_AUDIO_ACTION.setEnabled(!((DemuxMP4AudioAction)this.DEMUX_MP4_AUDIO_ACTION).isDemuxing());
        }
        menu.add(new SkinMenuItem(this.CREATE_TORRENT_ACTION));
        if (this.areAllSelectedFilesPlayable()) {
            menu.add(this.createAddToPlaylistSubMenu());
        }
        menu.add(new SkinMenuItem(this.SEND_TO_FRIEND_ACTION));
        menu.add(new SkinMenuItem(this.SEND_TO_ITUNES_ACTION));
        ((JPopupMenu)menu).addSeparator();
        menu.add(new SkinMenuItem(this.DELETE_ACTION));
        ((JPopupMenu)menu).addSeparator();
        int[] rows = this.TABLE.getSelectedRows();
        boolean dirSelected = false;
        boolean fileSelected = false;
        for (int row : rows) {
            File f = ((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(row)).getFile();
            if (f.isDirectory()) {
                dirSelected = true;
            } else {
                fileSelected = true;
            }
            if (dirSelected && fileSelected) break;
        }
        this.DELETE_ACTION.setEnabled(true);
        LibraryFilesTableDataLine line = (LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(rows[0]);
        menu.add(this.createSearchSubMenu(line));
        return menu;
    }

    private boolean areAllSelectedFilesMP4s() {
        int[] selectedRows;
        boolean selectionIsAllMP4 = true;
        for (int i : selectedRows = this.TABLE.getSelectedRows()) {
            if (((LibraryFilesTableModel)this.DATA_MODEL).getFile(i).getAbsolutePath().toLowerCase().endsWith("mp4")) continue;
            selectionIsAllMP4 = false;
            break;
        }
        return selectionIsAllMP4;
    }

    private boolean areAllSelectedFilesPlayable() {
        int[] selectedRows;
        boolean selectionIsAllAudio = true;
        for (int i : selectedRows = this.TABLE.getSelectedRows()) {
            if (MediaPlayer.isPlayableFile((File)((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(i)).getInitializeObject())) continue;
            selectionIsAllAudio = false;
            break;
        }
        return selectionIsAllAudio;
    }

    private JMenu createSearchSubMenu(LibraryFilesTableDataLine dl) {
        File f;
        String keywords;
        SkinMenu menu = new SkinMenu(I18n.tr("Search"));
        if (dl != null && (keywords = QueryUtils.createQueryString((f = (File)dl.getInitializeObject()).getName())).length() > 0) {
            menu.add(new SkinMenuItem(new SearchAction(keywords)));
        }
        if (menu.getItemCount() == 0) {
            menu.setEnabled(false);
        }
        return menu;
    }

    @Override
    public JComponent getScrolledTablePane() {
        return super.getScrolledTablePane();
    }

    @Override
    protected void updateSplashScreen() {
    }

    private LibraryFilesTableMediator() {
        super("LIBRARY_FILES_TABLE");
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setDragEnabled(true);
        this.TABLE.setTransferHandler(new LibraryFilesTableTransferHandler(this));
    }

    @Override
    protected void setDefaultRenderers() {
        super.setDefaultRenderers();
        this.TABLE.setDefaultRenderer(PlayableIconCell.class, new PlayableIconCellRenderer());
        this.TABLE.setDefaultRenderer(PlayableCell.class, new PlayableCellRenderer());
        this.TABLE.setDefaultRenderer(PaymentOptions.class, new PaymentOptionsRenderer());
    }

    @Override
    protected void setDefaultEditors() {
        TableColumnModel model = this.TABLE.getColumnModel();
        TableColumn tc = model.getColumn(0);
        tc.setCellEditor(new GenericCellEditor(this.getAbstractActionsRenderer()));
        tc = model.getColumn(7);
        tc.setCellEditor(new GenericCellEditor(new PaymentOptionsRenderer()));
    }

    void updateTableFiles(DirectoryHolder dirHolder) {
        if (dirHolder == null) {
            return;
        }
        if (dirHolder instanceof MediaTypeSavedFilesDirectoryHolder) {
            MediaType mediaType = ((MediaTypeSavedFilesDirectoryHolder)dirHolder).getMediaType();
            this.setMediaType(mediaType);
            if (mediaType.equals(MediaType.getAudioMediaType())) {
                UXStats.instance().log(4011);
            } else if (mediaType == MediaType.getImageMediaType()) {
                UXStats.instance().log(4014);
            } else if (mediaType == MediaType.getDocumentMediaType()) {
                UXStats.instance().log(4016);
            } else if (mediaType == MediaType.getVideoMediaType()) {
                UXStats.instance().log(4013);
            } else if (mediaType == MediaType.getTorrentMediaType()) {
                UXStats.instance().log(4017);
            } else if (mediaType == MediaType.getProgramMediaType()) {
                UXStats.instance().log(4015);
            }
        } else {
            this.setMediaType(MediaType.getAnyTypeMediaType());
        }
        this.clearTable();
        List<List<File>> partitionedFiles = LibraryFilesTableMediator.split(100, Arrays.asList(dirHolder.getFiles()));
        Iterator<List<File>> iterator = partitionedFiles.iterator();
        while (iterator.hasNext()) {
            List<File> partition;
            final List<File> fPartition = partition = iterator.next();
            BackgroundExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    for (final File file : fPartition) {
                        GUIMediator.safeInvokeLater(new Runnable(){

                            @Override
                            public void run() {
                                LibraryFilesTableMediator.this.addUnsorted(file);
                            }
                        });
                    }
                    GUIMediator.safeInvokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LibraryMediator.instance().getLibrarySearch().addResults(fPartition.size());
                        }
                    });
                }
            });
        }
        this.forceResort();
    }

    File getFile(int row) {
        return ((LibraryFilesTableModel)this.DATA_MODEL).getFile(row);
    }

    JTable getTable() {
        return this.TABLE;
    }

    private static Object[] createRemoveOptions() {
        if (OSUtils.supportsTrash()) {
            String trashLabel = OSUtils.isWindows() ? I18n.tr("Move to Recycle Bin") : I18n.tr("Move to Trash");
            return new Object[]{trashLabel, I18n.tr("Delete"), I18n.tr("Cancel")};
        }
        return new Object[]{I18n.tr("Delete"), I18n.tr("Cancel")};
    }

    @Override
    public List<MediaSource> getFilesView() {
        int size = ((LibraryFilesTableModel)this.DATA_MODEL).getRowCount();
        ArrayList<MediaSource> result = new ArrayList<MediaSource>(size);
        for (int i = 0; i < size; ++i) {
            try {
                File file = ((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(i)).getFile();
                if (!MediaPlayer.isPlayableFile(file)) continue;
                result.add(new MediaSource(((LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(i)).getFile()));
                continue;
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
        }
        return result;
    }

    @Override
    public void removeSelection() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        ArrayList<File> files = new ArrayList<File>(rows.length);
        Arrays.sort(rows);
        for (int i = rows.length - 1; i >= 0; --i) {
            File file = ((LibraryFilesTableModel)this.DATA_MODEL).getFile(rows[i]);
            files.add(file);
        }
        CheckBoxListPanel<File> listPanel = new CheckBoxListPanel<File>(files, new FileTextProvider(), true);
        listPanel.getList().setVisibleRowCount(4);
        Object[] message = new Object[]{new MultiLineLabel(I18n.tr("Are you sure you want to delete the selected file(s), thus removing it from your computer?"), 400), Box.createVerticalStrut(6), listPanel, Box.createVerticalStrut(6)};
        Object[] removeOptions = LibraryFilesTableMediator.createRemoveOptions();
        int option = JOptionPane.showOptionDialog(MessageService.getParentComponent(), message, I18n.tr("Message"), 0, 3, null, removeOptions, removeOptions[0]);
        if (option == removeOptions.length - 1 || option == -1) {
            return;
        }
        List<File> selected = listPanel.getSelectedElements();
        ArrayList<String> undeletedFileNames = new ArrayList<String>();
        boolean somethingWasRemoved = false;
        for (File file : selected) {
            boolean removed;
            BittorrentDownload dm = TorrentUtil.getDownloadManager(file);
            if (dm != null) {
                dm.setDeleteDataWhenRemove(false);
                dm.setDeleteTorrentWhenRemove(false);
                BTDownloadMediator.instance().remove(dm);
            }
            if (MediaPlayer.instance().isThisBeingPlayed(file)) {
                MediaPlayer.instance().stop();
                MPlayerMediator.instance().showPlayerWindow(false);
            }
            if (removed = FileUtils.delete(file, removeOptions.length > 2 && option == 0)) {
                somethingWasRemoved = true;
                ((LibraryFilesTableModel)this.DATA_MODEL).remove(((LibraryFilesTableModel)this.DATA_MODEL).getRow(file));
                continue;
            }
            undeletedFileNames.add(this.getCompleteFileName(file));
        }
        this.clearSelection();
        if (somethingWasRemoved) {
            LibraryMediator.instance().getLibraryExplorer().refreshSelection(true);
        }
        if (undeletedFileNames.isEmpty()) {
            return;
        }
        message = new Object[]{new MultiLineLabel(I18n.tr("The following files could not be deleted. They may be in use by another application or are currently being downloaded to."), 400), Box.createVerticalStrut(6), new JScrollPane(LibraryFilesTableMediator.createFileList(undeletedFileNames))};
        JOptionPane.showMessageDialog(MessageService.getParentComponent(), message, I18n.tr("Error"), 0);
        super.removeSelection();
    }

    private static JList<String> createFileList(List<String> fileNames) {
        JList<String> fileList = new JList<String>(fileNames.toArray(new String[0]));
        fileList.setVisibleRowCount(5);
        fileList.setCellRenderer(new FileNameListCellRenderer());
        fileList.setFocusable(false);
        return fileList;
    }

    private String getCompleteFileName(File file) {
        return file.getName();
    }

    @Override
    public void handleActionKey() {
        LibraryFilesTableDataLine line = (LibraryFilesTableDataLine)((LibraryFilesTableModel)this.DATA_MODEL).get(this.TABLE.getSelectedRow());
        if (line == null || line.getFile() == null) {
            return;
        }
        if (this.getMediaType().equals(MediaType.getAudioMediaType()) && MediaPlayer.isPlayableFile(line.getFile())) {
            MediaPlayer.instance().asyncLoadMedia(new MediaSource(line.getFile()), true, null, this.getFilesView());
            UXStats.instance().log(4001);
            return;
        }
        this.launch(true);
    }

    private void launch(boolean playAudio) {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        File selectedFile = ((LibraryFilesTableModel)this.DATA_MODEL).getFile(rows[0]);
        if (OSUtils.isWindows()) {
            if (selectedFile.isDirectory()) {
                GUIMediator.launchExplorer(selectedFile);
                return;
            }
            if (!MediaPlayer.isPlayableFile(selectedFile)) {
                String extension = FilenameUtils.getExtension(selectedFile.getName());
                if (extension != null && extension.toLowerCase().equals("torrent")) {
                    GUIMediator.instance().openTorrentFile(selectedFile, true);
                } else {
                    GUIMediator.launchFile(selectedFile);
                }
                return;
            }
        }
        GUILauncher.LaunchableProvider[] providers = new GUILauncher.LaunchableProvider[rows.length];
        boolean stopAudio = false;
        for (int i = 0; i < rows.length; ++i) {
            try {
                MediaType mt = MediaType.getMediaTypeForExtension(FilenameUtils.getExtension(((LibraryFilesTableModel)this.DATA_MODEL).getFile(rows[i]).getName()));
                if (mt != null && mt.equals(MediaType.getVideoMediaType())) {
                    stopAudio = true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            providers[i] = new FileProvider(((LibraryFilesTableModel)this.DATA_MODEL).getFile(rows[i]));
        }
        if (stopAudio || !playAudio) {
            MediaPlayer.instance().stop();
        }
        if (playAudio) {
            GUILauncher.launch(providers);
            UXStats.instance().log(stopAudio ? 4009 : 4001);
        } else {
            GUIMediator.launchFile(selectedFile);
        }
    }

    @Override
    public void handleSelection(int row) {
        int[] sel = this.TABLE.getSelectedRows();
        if (sel.length == 0) {
            this.handleNoSelection();
            return;
        }
        File selectedFile = this.getFile(sel[0]);
        this.LAUNCH_ACTION.setEnabled(true);
        this.LAUNCH_OS_ACTION.setEnabled(true);
        this.DELETE_ACTION.setEnabled(true);
        if (selectedFile != null && !selectedFile.getName().endsWith(".torrent")) {
            this.CREATE_TORRENT_ACTION.setEnabled(sel.length == 1);
        }
        if (selectedFile != null) {
            this.SEND_TO_FRIEND_ACTION.setEnabled(sel.length == 1);
            if (this.getMediaType().equals(MediaType.getAnyTypeMediaType())) {
                boolean atLeastOneIsPlayable = false;
                for (int i : sel) {
                    File f = this.getFile(i);
                    if (!MediaPlayer.isPlayableFile(f) && !LibraryFilesTableMediator.hasExtension(f.getAbsolutePath(), "mp4")) continue;
                    atLeastOneIsPlayable = true;
                    break;
                }
                this.SEND_TO_ITUNES_ACTION.setEnabled(atLeastOneIsPlayable);
            } else {
                this.SEND_TO_ITUNES_ACTION.setEnabled(this.getMediaType().equals(MediaType.getAudioMediaType()) || LibraryFilesTableMediator.hasExtension(selectedFile.getAbsolutePath(), "mp4"));
            }
        }
        if (sel.length == 1 && selectedFile != null && selectedFile.isFile() && selectedFile.getParentFile() != null) {
            this.OPEN_IN_FOLDER_ACTION.setEnabled(true);
        } else {
            this.OPEN_IN_FOLDER_ACTION.setEnabled(false);
        }
        if (sel.length == 1) {
            LibraryMediator.instance().getLibraryCoverArtPanel().setTagsReader(new TagsReader(selectedFile)).asyncRetrieveImage();
        }
    }

    @Override
    public void handleNoSelection() {
        this.LAUNCH_ACTION.setEnabled(false);
        this.LAUNCH_OS_ACTION.setEnabled(false);
        this.OPEN_IN_FOLDER_ACTION.setEnabled(false);
        this.SEND_TO_FRIEND_ACTION.setEnabled(false);
        this.CREATE_TORRENT_ACTION.setEnabled(false);
        this.DELETE_ACTION.setEnabled(false);
        this.SEND_TO_ITUNES_ACTION.setEnabled(false);
    }

    boolean setFileSelected(File file) {
        int i = ((LibraryFilesTableModel)this.DATA_MODEL).getRow(file);
        if (i != -1) {
            this.TABLE.setSelectedRow(i);
            this.TABLE.ensureSelectionVisible();
            return true;
        }
        return false;
    }

    private boolean hasExploreAction() {
        return OSUtils.isWindows() || OSUtils.isMacOSX();
    }

    public static <T> List<List<T>> split(int partitionSize, List<T> collection) {
        LinkedList<List<T>> lists = new LinkedList<List<T>>();
        for (int i = 0; i < collection.size(); i += partitionSize) {
            int jLimit = Math.min(collection.size(), i + partitionSize);
            LinkedList<T> newList = new LinkedList<T>();
            for (int j = i; j < jLimit; ++j) {
                newList.add(collection.get(j));
            }
            lists.add(newList);
        }
        return lists;
    }

    @Override
    protected void sortAndMaintainSelection(int columnToSort) {
        super.sortAndMaintainSelection(columnToSort);
        this.resetAudioPlayerFileView();
    }

    void resetAudioPlayerFileView() {
        Playlist playlist = MediaPlayer.instance().getCurrentPlaylist();
        if (playlist == null) {
            MediaPlayer.instance().setPlaylistFilesView(this.getFilesView());
        }
    }

    @Override
    protected MediaSource createMediaSource(LibraryFilesTableDataLine line) {
        if (MediaPlayer.isPlayableFile((File)line.getInitializeObject())) {
            return new MediaSource((File)line.getInitializeObject());
        }
        return null;
    }

    private static boolean hasExtension(String filename, String ... extensionsWithoutDot) {
        String extension = FilenameUtils.getExtension(filename).toLowerCase();
        for (String ext : extensionsWithoutDot) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    private static class FileProvider
    implements GUILauncher.LaunchableProvider {
        private final File _file;

        FileProvider(File file) {
            this._file = file;
        }

        @Override
        public File getFile() {
            return this._file;
        }
    }

    private class FileTextProvider
    implements CheckBoxList.TextProvider<File> {
        private FileTextProvider() {
        }

        @Override
        public Icon getIcon(File obj) {
            String extension = FilenameUtils.getExtension(obj.getName());
            if (extension != null) {
                return IconManager.instance().getIconForExtension(extension);
            }
            return null;
        }

        @Override
        public String getText(File obj) {
            return LibraryFilesTableMediator.this.getCompleteFileName(obj);
        }

        @Override
        public String getToolTipText(File obj) {
            return obj.getAbsolutePath();
        }
    }

    private static class FileNameListCellRenderer
    extends DefaultListCellRenderer {
        private FileNameListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            String extension = FilenameUtils.getExtension(value.toString());
            if (extension != null) {
                this.setIcon(IconManager.instance().getIconForExtension(extension));
            }
            return this;
        }
    }

    private class DemuxMP4AudioAction
    extends AbstractAction {
        private static final long serialVersionUID = 2994040746359495494L;
        private final ArrayList<File> demuxedFiles;
        private boolean isDemuxing = false;

        DemuxMP4AudioAction() {
            this.putValue("Name", I18n.tr("Extract Audio"));
            this.putValue("ShortDescription", I18n.tr("Extract .m4a Audio from this .mp4 video"));
            this.demuxedFiles = new ArrayList();
        }

        boolean isDemuxing() {
            return this.isDemuxing;
        }

        private List<File> getSelectedFiles() {
            int[] rows = LibraryFilesTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> files = new ArrayList<File>(rows.length);
            for (int index : rows) {
                File file = ((LibraryFilesTableModel)LibraryFilesTableMediator.this.DATA_MODEL).getFile(index);
                files.add(file);
            }
            return files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final short videoCount = (short)LibraryFilesTableMediator.this.TABLE.getSelectedRows().length;
            if (videoCount < 1) {
                return;
            }
            final List<File> selectedFiles = this.getSelectedFiles();
            this.selectAudio();
            String status = I18n.tr("Extracting audio from " + videoCount + " selected videos...");
            if (videoCount == 1) {
                status = I18n.tr("Extracting audio from selected video...");
            }
            LibraryMediator.instance().getLibrarySearch().pushStatus(status);
            SwingWorker<Void, Void> demuxWorker = new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    DemuxMP4AudioAction.this.isDemuxing = true;
                    DemuxMP4AudioAction.this.demuxFiles(selectedFiles);
                    DemuxMP4AudioAction.this.isDemuxing = false;
                    return null;
                }

                @Override
                protected void done() {
                    int failed = videoCount - DemuxMP4AudioAction.this.demuxedFiles.size();
                    String failedStr = failed > 0 ? " (" + failed + " " + I18n.tr("failed") + ")" : "";
                    LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Done extracting audio.") + failedStr);
                }
            };
            demuxWorker.execute();
        }

        private void selectAudio() {
            final LibraryExplorer explorer = LibraryMediator.instance().getLibraryExplorer();
            explorer.enqueueRunnable(new Runnable(){

                @Override
                public void run() {
                    explorer.selectAudio();
                }
            });
            explorer.executePendingRunnables();
        }

        private void demuxFiles(List<File> files) {
            this.demuxedFiles.clear();
            for (File file : files) {
                try {
                    System.out.println("Demuxing file " + file.getAbsolutePath());
                    File mp4 = file.getAbsoluteFile();
                    File m4a = new File(file.getParentFile(), FilenameUtils.getBaseName(mp4.getName()) + ".m4a").getAbsoluteFile();
                    try {
                        Mp4Info inf = Mp4Info.audio(null, null, null, null);
                        Mp4Demuxer.audio(mp4, m4a, inf, null);
                        this.demuxedFiles.add(m4a);
                        this.updateDemuxingStatus(m4a, files.size(), true);
                    }
                    catch (Throwable e) {
                        this.updateDemuxingStatus(file, files.size(), false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void updateDemuxingStatus(final File demuxed, final int totalDemuxed, final boolean demuxSuccess) {
            GUIMediator.safeInvokeAndWait(new Runnable(){

                @Override
                public void run() {
                    LibraryExplorer explorer = LibraryMediator.instance().getLibraryExplorer();
                    explorer.enqueueRunnable(new Runnable(){

                        @Override
                        public void run() {
                            if (demuxSuccess) {
                                LibraryFilesTableMediator.this.add(demuxed, 0);
                                LibraryFilesTableMediator.this.update(demuxed);
                                LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Finished") + " " + DemuxMP4AudioAction.this.demuxedFiles.size() + " " + I18n.tr("out of") + " " + totalDemuxed + ". Extracting audio...");
                                System.out.println("Finished" + DemuxMP4AudioAction.this.demuxedFiles.size() + " out of " + totalDemuxed + ". Extracting audio...");
                            } else {
                                LibraryMediator.instance().getLibrarySearch().pushStatus(I18n.tr("Could not extract audio from") + " " + demuxed.getName());
                            }
                        }
                    });
                    explorer.executePendingRunnables();
                }
            });
        }
    }

    private class SendAudioFilesToiTunes
    extends AbstractAction {
        private static final long serialVersionUID = 4726989286129406765L;

        SendAudioFilesToiTunes() {
            if (!OSUtils.isLinux()) {
                this.putValue("Name", I18n.tr("Send to iTunes"));
                this.putValue("ShortDescription", I18n.tr("Send audio files to iTunes"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = LibraryFilesTableMediator.this.TABLE.getSelectedRows();
            ArrayList<File> files = new ArrayList<File>();
            for (int index : rows) {
                File file = ((LibraryFilesTableModel)LibraryFilesTableMediator.this.DATA_MODEL).getFile(index);
                files.add(file);
            }
            iTunesMediator.instance().scanForSongs(files.toArray(new File[0]));
        }
    }

    private final class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = -8704093935791256631L;

        RemoveAction() {
            this.putValue("Name", I18n.tr("Delete"));
            this.putValue("ShortDescription", I18n.tr("Delete Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_DELETE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryFilesTableMediator.this.REMOVE_LISTENER.actionPerformed(ae);
        }
    }

    private final class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1898917632888388860L;

        CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            File selectedFile = ((LibraryFilesTableModel)LibraryFilesTableMediator.this.DATA_MODEL).getFile(LibraryFilesTableMediator.this.TABLE.getSelectedRow());
            if (selectedFile.isDirectory() && selectedFile.listFiles().length == 0) {
                JOptionPane.showMessageDialog(null, I18n.tr("The folder you selected is empty."), I18n.tr("Invalid Folder"), 0);
                return;
            }
            if (!selectedFile.canRead()) {
                JOptionPane.showMessageDialog(null, I18n.tr("Error: You can't read on that file/folder."), I18n.tr("Error"), 0);
                return;
            }
            CreateTorrentDialog dlg = new CreateTorrentDialog(GUIMediator.getAppFrame());
            dlg.setChosenContent(selectedFile, selectedFile.isFile() ? 0 : 1);
            dlg.setVisible(true);
        }
    }

    private final class OpenInFolderAction
    extends AbstractAction {
        private static final long serialVersionUID = 1693310684299300459L;

        OpenInFolderAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            int[] sel = LibraryFilesTableMediator.this.TABLE.getSelectedRows();
            if (sel.length == 0) {
                return;
            }
            File selectedFile = LibraryFilesTableMediator.this.getFile(sel[0]);
            if (selectedFile.isFile() && selectedFile.getParentFile() != null) {
                GUIMediator.launchExplorer(selectedFile);
            }
        }
    }

    private final class LaunchOSAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392592L;

        LaunchOSAction() {
            String os = "OS";
            if (OSUtils.isWindows()) {
                os = "Windows";
            } else if (OSUtils.isMacOSX()) {
                os = "Mac";
            } else if (OSUtils.isLinux()) {
                os = "Linux";
            }
            this.putValue("Name", I18n.tr("Launch in") + " " + os);
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files in") + " " + os);
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryFilesTableMediator.this.launch(false);
        }
    }

    private final class LaunchAction
    extends AbstractAction {
        private static final long serialVersionUID = 949208465372392591L;

        LaunchAction() {
            this.putValue("Name", I18n.tr("Launch"));
            this.putValue("ShortDescription", I18n.tr("Launch Selected Files"));
            this.putValue("LimeIconName", "LIBRARY_LAUNCH");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LibraryFilesTableMediator.this.launch(true);
        }
    }
}

