/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.library;

import com.frostwire.gui.library.LibraryFilesTableDataLine;
import com.frostwire.gui.library.LibraryFilesTableMediator;
import com.frostwire.gui.library.LibraryPlaylistsTableDataLine;
import com.frostwire.gui.library.LibraryPlaylistsTableMediator;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.gui.tables.AbstractActionsRenderer;
import com.limegroup.gnutella.gui.tables.DataLine;
import java.util.List;

public final class LibraryActionsRenderer
extends AbstractActionsRenderer {
    @Override
    protected void onPlayAction() {
        if (this.actionsHolder != null && this.actionsHolder.getDataLine() != null) {
            MediaSource mediaSource = null;
            List<MediaSource> filesView = null;
            DataLine<?> dataLine = this.actionsHolder.getDataLine();
            if (dataLine instanceof LibraryFilesTableDataLine) {
                mediaSource = new MediaSource(((LibraryFilesTableDataLine)dataLine).getFile());
                filesView = LibraryFilesTableMediator.instance().getFilesView();
            } else if (dataLine instanceof LibraryPlaylistsTableDataLine) {
                mediaSource = new MediaSource(((LibraryPlaylistsTableDataLine)dataLine).getPlayListItem());
                filesView = LibraryPlaylistsTableMediator.instance().getFilesView();
            }
            if (mediaSource != null && !this.actionsHolder.isPlaying()) {
                MediaPlayer.instance().asyncLoadMedia(mediaSource, true, null, filesView);
            }
        }
    }

    @Override
    protected void onDownloadAction() {
    }
}

