/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.transfers;

import com.frostwire.gui.components.transfers.TransferDetailPeers;
import com.frostwire.jlibtorrent.PeerInfo;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.tables.AbstractDataLine;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SizeHolder;
import com.limegroup.gnutella.gui.tables.SpeedRenderer;

public final class TransferDetailPeersDataLine
extends AbstractDataLine<TransferDetailPeers.PeerItemHolder> {
    private static final int IP_COLUMN_ID = 0;
    private static final int CLIENT_COLUMN_ID = 1;
    private static final int FLAGS_COLUMN_ID = 2;
    private static final int SOURCE_COLUMN_ID = 3;
    private static final int PROGRESS_COLUMN_ID = 4;
    private static final int DOWNLOADED_COLUMN_ID = 5;
    private static final int UPLOADED_COLUMN_ID = 6;
    private static final int DOWN_SPEED_COLUMN_ID = 7;
    private static final int UP_SPEED_COLUMN_ID = 8;
    private static final byte tracker = 1;
    private static final byte dht = 2;
    private static final byte pex = 4;
    private static final byte lsd = 8;
    private static final byte resume_data = 16;
    private static final byte incoming = 32;
    private static final int interesting = 1;
    private static final int choked = 2;
    private static final int remote_interested = 4;
    private static final int remote_choked = 8;
    private static final int local_connection = 32;
    private static final int handshake = 64;
    private static final int optimistic_unchoke = 2048;
    private static final int snubbed = 4096;
    private static final int utp_socket = 131072;
    private static final int ssl_socket = 262144;
    private static final int rc4_encrypted = 524288;
    private static final int plaintext_encrypted = 0x100000;
    private static LimeTableColumn[] columns = new LimeTableColumn[]{new LimeTableColumn(0, "IP", I18n.tr("IP"), 180, true, true, true, String.class), new LimeTableColumn(1, "CLIENT", I18n.tr("Client"), 120, true, true, true, String.class), new LimeTableColumn(2, "FLAGS", I18n.tr("Flags"), 70, true, true, true, String.class), new LimeTableColumn(3, "SOURCE", I18n.tr("Source"), 100, true, true, true, String.class), new LimeTableColumn(4, "PROGRESS", I18n.tr("Progress"), 100, true, true, false, String.class), new LimeTableColumn(5, "DOWNLOADED", I18n.tr("Downloaded"), 80, true, true, false, SizeHolder.class), new LimeTableColumn(6, "UPLOADED", I18n.tr("Uploaded"), 80, true, true, false, SizeHolder.class), new LimeTableColumn(7, "DOWN_SPEED", I18n.tr("Down Speed"), 130, true, true, false, SpeedRenderer.class), new LimeTableColumn(8, "UP_SPEED", I18n.tr("Up Speed"), 130, true, true, true, SpeedRenderer.class)};

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public LimeTableColumn getColumn(int col) {
        return columns[col];
    }

    @Override
    public boolean isDynamic(int col) {
        return false;
    }

    @Override
    public boolean isClippable(int col) {
        return false;
    }

    @Override
    public Object getValueAt(int col) {
        TransferDetailPeers.PeerItemHolder holder = (TransferDetailPeers.PeerItemHolder)this.getInitializeObject();
        if (holder == null) {
            return null;
        }
        PeerInfo peer = holder.peerItem;
        switch (col) {
            case 0: {
                String address2 = peer.ip();
                return this.connectionTypeAsString(peer.connectionType(), peer.flags()) + "://" + address2;
            }
            case 1: {
                String client = holder.peerItem.client();
                if (client == null || client.isEmpty()) {
                    client = I18n.tr("Unknown");
                }
                return client;
            }
            case 2: {
                return this.getFlagsAsString(peer.flags(), peer.source());
            }
            case 3: {
                return this.getSourceAsString(peer.source());
            }
            case 5: {
                return new SizeHolder(holder.peerItem.totalDownload());
            }
            case 4: {
                return 100.0f * peer.progress() + "%";
            }
            case 6: {
                return holder.peerItem.totalUpload();
            }
            case 7: {
                return (double)peer.downSpeed();
            }
            case 8: {
                return (double)peer.upSpeed();
            }
        }
        return null;
    }

    private String getSourceAsString(byte source) {
        StringBuilder sb = new StringBuilder();
        if ((source & 1) == 1) {
            sb.append("Tracker ");
        }
        if ((source & 2) == 2) {
            sb.append("DHT ");
        }
        if ((source & 4) == 4) {
            sb.append("PEX ");
        }
        if ((source & 8) == 8) {
            sb.append("LSD ");
        }
        if ((source & 0x10) == 16) {
            sb.append(I18n.tr("Resumed")).append(" ");
        }
        if ((source & 0x20) == 32) {
            sb.append(I18n.tr("Incoming")).append(" ");
        }
        return sb.toString();
    }

    private String getFlagsAsString(int flags, int sourceFlags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 1) == 1 && (flags & 8) == 0) {
            sb.append("D");
        }
        if ((flags & 1) == 1 && (flags & 8) == 8) {
            sb.append("d");
        }
        if ((flags & 4) == 4 && (flags & 2) == 0) {
            sb.append("U");
        }
        if ((flags & 4) == 4 && (flags & 2) == 2) {
            sb.append("u");
        }
        if ((flags & 0x800) == 2048) {
            sb.append("O");
        }
        if ((flags & 0x1000) == 4096) {
            sb.append("S");
        }
        if ((flags & 0x20) == 0) {
            sb.append("I");
        }
        if ((flags & 1) == 0 && (flags & 8) == 0) {
            sb.append("K");
        }
        if ((flags & 4) == 0 && (flags & 2) == 0) {
            sb.append("?");
        }
        if ((sourceFlags & 4) == 4) {
            sb.append("X");
        }
        if ((sourceFlags & 2) == 2) {
            sb.append("H");
        }
        if ((flags & 0x100000) == 0x100000 || (flags & 0x80000) == 524288 || (flags & 0x40000) == 262144) {
            sb.append("E");
        }
        if ((flags & 0x40) == 64 && ((flags & 0x100000) == 0x100000 || (flags & 0x80000) == 524288 || (flags & 0x40000) == 262144)) {
            sb.append("e");
        }
        if ((flags & 0x20000) == 131072) {
            sb.append("P");
        }
        if ((sourceFlags & 8) == 8) {
            sb.append("L");
        }
        return sb.toString();
    }

    private String connectionTypeAsString(PeerInfo.ConnectionType t, int flags) {
        switch (t) {
            case WEB_SEED: {
                return "web_seed";
            }
            case HTTP_SEED: {
                return "http_seed";
            }
        }
        return (flags & 0x20000) == 131072 ? "uTP" : "bt";
    }

    @Override
    public int getTypeAheadColumn() {
        return 0;
    }
}

