/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.components.slides;

import com.frostwire.bittorrent.PaymentOptions;
import com.frostwire.gui.components.slides.Slide;
import com.frostwire.gui.components.slides.SlidePanelController;
import com.frostwire.util.JsonUtils;
import com.frostwire.util.StringUtils;
import com.frostwire.util.UrlUtils;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIDefaults;
import javax.swing.plaf.FontUIResource;
import net.miginfocom.swing.MigLayout;

final class SlideControlsOverlay
extends JPanel {
    private static final Color BACKGROUND = new Color(45, 52, 58);
    private static final float BACKGROUND_ALPHA = 0.7f;
    private static final Color TEXT_FOREGROUND = new Color(255, 255, 255);
    private static final int BASE_TEXT_FONT_SIZE_DELTA = 3;
    private static final int TITLE_TEXT_FONT_SIZE_DELTA = 6;
    private static final int SOCIAL_BAR_HEIGHT = 55;
    private final SlidePanelController controller;
    private final Composite overlayComposite;

    public SlideControlsOverlay(SlidePanelController controller) {
        this.controller = controller;
        this.overlayComposite = AlphaComposite.getInstance(3, 0.7f);
        this.setupUI();
    }

    private void setupUI() {
        this.setOpaque(false);
        this.setLayout(new MigLayout("fill"));
        this.setBackground(BACKGROUND);
        this.setupTitle();
        this.setupPaymentOptions();
        this.setupButtons();
        this.setupSocialBar();
    }

    private void setupTitle() {
        if (this.controller.getSlide().title != null) {
            JLabel labelTitle = new JLabel(this.controller.getSlide().title);
            labelTitle.setForeground(TEXT_FOREGROUND);
            labelTitle.setFont(this.deriveFont(true, 6));
            this.add((Component)labelTitle, "alignx left, aligny baseline, pushx");
        }
    }

    private void setupPaymentOptions() {
        Slide slide = this.controller.getSlide();
        if (slide != null && slide.paymentOptions != null) {
            this.add((Component)this.createPaymentButton(slide), "aligny center, alignx right, wrap");
        } else {
            this.add((Component)new JPanel(), "wrap");
        }
    }

    private OverlayIconButton createPaymentButton(Slide slide) {
        final OverlayIconButton paymentButton = new OverlayIconButton(new PaymentAction(slide.paymentOptions, slide.title), true, false);
        Font origFont = paymentButton.getFont();
        Font newFont = origFont.deriveFont(origFont.getSize2D() - 3.0f);
        paymentButton.setFont(newFont);
        paymentButton.setForeground(new Color(6075616));
        paymentButton.setBackground(Color.WHITE);
        UIDefaults nimbusOverrides = (UIDefaults)paymentButton.getClientProperty("Nimbus.Overrides");
        nimbusOverrides.put("Button.contentMargins", new Insets(5, 7, 5, 7));
        paymentButton.putClientProperty("Nimbus.Overrides", nimbusOverrides);
        paymentButton.updateUI();
        paymentButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                super.mouseEntered(e);
                paymentButton.setForeground(new Color(2374734));
                paymentButton.setBackground(new Color(6075616));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                super.mouseExited(e);
                paymentButton.setForeground(new Color(6075616));
                paymentButton.setBackground(Color.WHITE);
            }
        });
        paymentButton.setText(I18n.tr("Leave a tip"));
        return paymentButton;
    }

    private void setupButtons() {
        Slide slide = this.controller.getSlide();
        JPanel centerButtonsPanel = new JPanel(new MigLayout("fill"));
        if (slide.hasFlag(1024)) {
            this.addPreviewButtons(centerButtonsPanel, slide);
            this.addDownloadInstallButton(centerButtonsPanel, slide);
        } else {
            this.addDownloadInstallButton(centerButtonsPanel, slide);
            this.addPreviewButtons(centerButtonsPanel, slide);
        }
        this.add((Component)centerButtonsPanel, "gaptop 35px, gapbottom 25px, growy, pushy, pushx, spanx 3, aligny center, alignx center, wrap");
    }

    private void setupSocialBar() {
        Slide slide = this.controller.getSlide();
        JPanel container = new JPanel(new MigLayout("fillx, ins 0"));
        JLabel labelAuthor = new JLabel(slide.author + " " + I18n.tr("on"));
        labelAuthor.setForeground(TEXT_FOREGROUND);
        labelAuthor.setFont(this.deriveFont(false, 3));
        container.add((Component)labelAuthor, "aligny baseline");
        if (slide.facebook != null) {
            container.add((Component)new OverlayIconButton(new SocialAction("Facebook", slide.facebook)), "");
        }
        if (slide.twitter != null) {
            container.add((Component)new OverlayIconButton(new SocialAction("Twitter", slide.twitter)), "");
        }
        if (slide.gplus != null) {
            container.add((Component)new OverlayIconButton(new SocialAction("Google Plus", slide.gplus, "GPLUS")), "");
        }
        if (slide.youtube != null) {
            container.add((Component)new OverlayIconButton(new SocialAction("YouTube", slide.youtube)), "");
        }
        if (slide.instagram != null) {
            container.add((Component)new OverlayIconButton(new SocialAction("Instagram", slide.instagram)), "");
        }
        this.add((Component)container, "span 2, alignx center, pushx");
    }

    private Font deriveFont(boolean isBold, int fontSizeDelta) {
        Font font = this.getFont();
        if (isBold) {
            font = font.deriveFont(1);
        }
        return font.deriveFont(font.getSize2D() + (float)fontSizeDelta);
    }

    private void addPreviewButtons(JPanel container, Slide slide) {
        if (slide.hasFlag(256)) {
            container.add(new OverlayIconButton(new PreviewVideoAction(this.controller)));
        }
        if (slide.hasFlag(128)) {
            container.add(new OverlayIconButton(new PreviewAudioAction(this.controller)));
        }
    }

    private void addDownloadInstallButton(JPanel container, Slide slide) {
        if (slide.method == 2 || slide.method == 1) {
            if (slide.hasFlag(4)) {
                container.add(new OverlayIconButton(new InstallAction(this.controller)));
            } else {
                container.add(new OverlayIconButton(new DownloadAction(this.controller)));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color background = this.getBackground();
        Composite c = g2d.getComposite();
        g2d.setComposite(this.overlayComposite);
        g2d.setColor(background);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setComposite(c);
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, this.getHeight() - 55, this.getWidth(), 55);
        g2d.setColor(background);
        super.paint(g);
    }

    private static final class PaymentAction
    extends AbstractAction {
        private final String paymentOptionsUrl;

        public PaymentAction(PaymentOptions paymentOptions, String workTitle) {
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_TIP_JAR");
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_TIP_JAR_ROLLOVER");
            this.putValue("ShortDescription", String.format(I18n.tr("Support %s with a tip, donation or voluntary payment"), workTitle));
            String paymentOptionsJSON = UrlUtils.encode(JsonUtils.toJson(paymentOptions).replaceAll("\n", ""));
            this.paymentOptionsUrl = String.format("http://www.frostwire.com/tips/?method=%s&po=%s&title=%s", this.getDefaultPaymentMethod(paymentOptions), paymentOptionsJSON, UrlUtils.encode(workTitle));
        }

        private String getDefaultPaymentMethod(PaymentOptions paymentOptions) {
            String paymentMethod = "";
            if (!StringUtils.isNullOrEmpty(paymentOptions.bitcoin)) {
                paymentMethod = PaymentOptions.PaymentMethod.BITCOIN.toString();
            } else if (!StringUtils.isNullOrEmpty(paymentOptions.paypalUrl)) {
                paymentMethod = PaymentOptions.PaymentMethod.PAYPAL.toString();
            }
            return paymentMethod;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.openURL(this.paymentOptionsUrl);
            UXStats.instance().log(7002);
        }
    }

    private static final class SocialAction
    extends AbstractAction {
        private final String url;

        public SocialAction(String networkName, String url) {
            this(networkName, url, networkName.toUpperCase());
        }

        public SocialAction(String networkName, String url, String imageName) {
            this.url = url;
            this.putValue("ShortDescription", networkName);
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_" + imageName);
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_" + imageName + "_ROLLOVER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GUIMediator.openURL(this.url);
        }
    }

    private static final class OverlayIconButton
    extends IconButton {
        public OverlayIconButton(Action action, boolean useHorizontalText, boolean transparentBackground) {
            this(action);
            this.setHorizontalText(useHorizontalText);
            this.setUseTransparentBackground(transparentBackground);
        }

        public OverlayIconButton(Action action) {
            super(action);
            this.setForeground(TEXT_FOREGROUND);
            Font f = this.getFont().deriveFont(this.getFont().getSize2D() + 3.0f);
            UIDefaults defaults = new UIDefaults();
            defaults.put("Button.font", new FontUIResource(f));
            this.putClientProperty("Nimbus.Overrides.InheritDefaults", Boolean.TRUE);
            this.putClientProperty("Nimbus.Overrides", defaults);
        }
    }

    private static final class PreviewAudioAction
    extends AbstractAction {
        private SlidePanelController controller;

        public PreviewAudioAction(SlidePanelController controller) {
            this.controller = controller;
            this.putValue("Name", I18n.tr("Audio Preview"));
            this.putValue("LimeShortName", I18n.tr("Audio Preview"));
            this.putValue("ShortDescription", I18n.tr("Play Audio preview of") + " " + controller.getSlide().title);
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_PREVIEW");
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_PREVIEW_ROLLOVER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.controller.previewAudio();
        }
    }

    private static final class PreviewVideoAction
    extends AbstractAction {
        private SlidePanelController controller;

        public PreviewVideoAction(SlidePanelController controller) {
            this.controller = controller;
            this.putValue("Name", I18n.tr("Video Preview"));
            this.putValue("LimeShortName", I18n.tr("Video Preview"));
            this.putValue("ShortDescription", I18n.tr("Play Video preview of") + " " + controller.getSlide().title);
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_PREVIEW");
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_PREVIEW_ROLLOVER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.controller.previewVideo();
        }
    }

    private static final class DownloadAction
    extends AbstractAction {
        private SlidePanelController controller;

        public DownloadAction(SlidePanelController controller) {
            this.controller = controller;
            this.putValue("Name", I18n.tr("Download"));
            this.putValue("LimeShortName", I18n.tr("Download"));
            this.putValue("ShortDescription", I18n.tr("Download") + " " + controller.getSlide().title);
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_DOWNLOAD");
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_DOWNLOAD_ROLLOVER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.controller.downloadSlide();
        }
    }

    private static final class InstallAction
    extends AbstractAction {
        private SlidePanelController controller;

        public InstallAction(SlidePanelController controller) {
            this.controller = controller;
            this.putValue("Name", I18n.tr("Install"));
            this.putValue("LimeShortName", I18n.tr("Install"));
            this.putValue("ShortDescription", I18n.tr("Install") + " " + controller.getSlide().title);
            this.putValue("LimeIconName", "SLIDE_CONTROLS_OVERLAY_DOWNLOAD");
            this.putValue("RollOverFrostIconName", "SLIDE_CONTROLS_OVERLAY_DOWNLOAD_ROLLOVER");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.controller.installSlide();
        }
    }
}

