/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.AlphaIcon;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.components.transfers.TransferDetailFiles;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.FWAbstractJPanelTableCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class TransferDetailFilesActionsRenderer
extends FWAbstractJPanelTableCellRenderer {
    private static final ImageIcon play_solid = GUIMediator.getThemeImage("search_result_play_over");
    private static final AlphaIcon play_transparent = new AlphaIcon(play_solid, 0.1f);
    private static final ImageIcon share_solid = GUIMediator.getThemeImage("transfers_sharing_over");
    private static final AlphaIcon share_faded = new AlphaIcon(share_solid, 0.1f);
    private JLabel playButton;
    private JLabel shareButton;
    private TransferDetailFiles.TransferItemHolder transferItemHolder;

    public TransferDetailFilesActionsRenderer() {
        this.setLayout(new MigLayout("insets 2px 18px 0 0", "align center"));
        this.playButton = new JLabel(play_transparent);
        this.playButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TransferDetailFilesActionsRenderer.this.onPlay();
                }
            }
        });
        this.shareButton = new JLabel(share_faded);
        this.shareButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    TransferDetailFilesActionsRenderer.this.onShare();
                }
            }
        });
        this.add((Component)this.playButton, "center");
        this.add((Component)this.shareButton, "center");
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.updateButtons();
    }

    @Override
    protected void updateUIData(Object dataHolder, JTable table, int row, int column) {
        if (!(dataHolder instanceof TransferDetailFiles.TransferItemHolder)) {
            if (this.transferItemHolder != null) {
                this.updateButtons();
            }
            return;
        }
        this.transferItemHolder = (TransferDetailFiles.TransferItemHolder)dataHolder;
        this.updateButtons();
    }

    private void onPlay() {
        if (!this.transferItemHolder.transferItem.isComplete()) {
            return;
        }
        File file = this.transferItemHolder.transferItem.getFile();
        if (MediaPlayer.isPlayableFile(file)) {
            MediaPlayer.instance().asyncLoadMedia(new MediaSource(file), false, false);
        } else {
            GUIMediator.launchFile(file);
        }
    }

    private void onShare() {
        if (!this.transferItemHolder.transferItem.isComplete()) {
            return;
        }
        File file = this.transferItemHolder.transferItem.getFile();
        if (TorrentUtil.askForPermissionToSeedAndSeedDownloads(null)) {
            new Thread(() -> {
                TorrentUtil.makeTorrentAndDownload(file, null, true);
                GUIMediator.safeInvokeLater(() -> BTDownloadMediator.instance().updateTableFilters());
            }).start();
        }
    }

    private void updateButtons() {
        if (this.transferItemHolder == null) {
            return;
        }
        this.playButton.setIcon(this.transferItemHolder.transferItem.isComplete() ? play_solid : play_transparent);
        this.shareButton.setIcon(this.transferItemHolder.transferItem.isComplete() ? share_solid : share_faded);
        this.playButton.invalidate();
        this.shareButton.invalidate();
    }
}

