/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.util.Logger;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResultDataLine;
import com.limegroup.gnutella.gui.search.SearchResultMediator;
import com.limegroup.gnutella.gui.search.SearchResultTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

final class BTDownloadTransferHandler
extends LimeTransferHandler {
    private static final Logger LOG = Logger.getLogger(BTDownloadTransferHandler.class);

    BTDownloadTransferHandler() {
        super(1);
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return DNDUtils.contains(transferFlavors, SearchResultTransferable.dataFlavor) || DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(comp, transferFlavors);
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] flavors, DropInfo ddi) {
        return this.canImport(c, flavors);
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (DNDUtils.contains(t.getTransferDataFlavors(), SearchResultTransferable.dataFlavor)) {
            try {
                SearchResultTransferable srt = (SearchResultTransferable)t.getTransferData(SearchResultTransferable.dataFlavor);
                SearchResultMediator rp = srt.getResultPanel();
                SearchResultDataLine[] lines = srt.getTableLines();
                SearchMediator.downloadFromPanel(rp, lines);
                return true;
            }
            catch (Throwable e) {
                LOG.error("Error importing DnD data", e);
            }
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(comp, t);
    }

    @Override
    public boolean importData(JComponent c, Transferable t, DropInfo ddi) {
        return this.importData(c, t);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        BTDownload[] downloads = BTDownloadMediator.instance().getSelectedBTDownloads();
        if (downloads.length > 0) {
            List<File> filesToDrop = this.getListOfFilesFromBTDownloads(downloads);
            return new FileTransferable(filesToDrop);
        }
        return null;
    }

    private List<File> getListOfFilesFromBTDownloads(BTDownload[] downloads) {
        LinkedList<File> files = new LinkedList<File>();
        Set<File> ignore = TorrentUtil.getIgnorableFiles();
        for (BTDownload download : downloads) {
            File saveLocation = download.getSaveLocation();
            this.addFilesRecursively(files, saveLocation, ignore);
        }
        return files;
    }

    private void addFilesRecursively(List<File> files, File saveLocation, Set<File> ignore) {
        File[] listFiles;
        if (saveLocation.isFile()) {
            if (!ignore.contains(saveLocation)) {
                files.add(saveLocation);
            }
        } else if (saveLocation.isDirectory() && (listFiles = saveLocation.listFiles()) != null) {
            for (File f : listFiles) {
                this.addFilesRecursively(files, f, ignore);
            }
        }
    }
}

