/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.alexandria.Library;
import com.frostwire.alexandria.Playlist;
import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadActions;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.theme.SkinMenu;
import com.frostwire.gui.theme.SkinMenuItem;
import com.frostwire.gui.theme.ThemeMediator;
import com.frostwire.util.StringUtils;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;

final class BTDownloadMediatorAdvancedMenuFactory {
    BTDownloadMediatorAdvancedMenuFactory() {
    }

    public static SkinMenu createAdvancedSubMenu() {
        final com.frostwire.bittorrent.BTDownload[] dms = BTDownloadMediatorAdvancedMenuFactory.getSingleSelectedDownloadManagers();
        if (dms == null) {
            return null;
        }
        boolean upSpeedDisabled = false;
        long totalUpSpeed = 0L;
        boolean upSpeedUnlimited = false;
        long upSpeedSetMax = 0L;
        boolean downSpeedDisabled = false;
        long totalDownSpeed = 0L;
        boolean downSpeedUnlimited = false;
        long downSpeedSetMax = 0L;
        for (int i = 0; i < dms.length; ++i) {
            com.frostwire.bittorrent.BTDownload dm = dms[i];
            try {
                int maxul = dm.getUploadRateLimit();
                if (maxul == 0) {
                    upSpeedUnlimited = true;
                } else if ((long)maxul > upSpeedSetMax) {
                    upSpeedSetMax = maxul;
                }
                if (maxul == -1) {
                    maxul = 0;
                    upSpeedDisabled = true;
                }
                totalUpSpeed += (long)maxul;
                int maxdl = dm.getDownloadRateLimit();
                if (maxdl == 0) {
                    downSpeedUnlimited = true;
                } else if ((long)maxdl > downSpeedSetMax) {
                    downSpeedSetMax = maxdl;
                }
                if (maxdl == -1) {
                    maxdl = 0;
                    downSpeedDisabled = true;
                }
                totalDownSpeed += (long)maxdl;
                continue;
            }
            catch (Exception ex) {
                Debug.printStackTrace(ex);
            }
        }
        SkinMenu menuAdvanced = new SkinMenu(I18n.tr("Advanced"));
        BTEngine engine = BTEngine.getInstance();
        long maxDownload = engine.downloadRateLimit();
        long maxUpload = engine.uploadRateLimit();
        BTDownloadMediatorAdvancedMenuFactory.addSpeedMenu(menuAdvanced, true, true, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDownload, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUpload, dms.length, new SpeedAdapter(){

            @Override
            public void setDownSpeed(int speed) {
                for (int i = 0; i < dms.length; ++i) {
                    dms[i].setDownloadRateLimit(speed);
                }
            }

            @Override
            public void setUpSpeed(int speed) {
                for (int i = 0; i < dms.length; ++i) {
                    dms[i].setUploadRateLimit(speed);
                }
            }
        });
        SkinMenu menuTracker = BTDownloadMediatorAdvancedMenuFactory.createTrackerMenu();
        if (menuTracker != null) {
            menuAdvanced.add(menuTracker);
        }
        return menuAdvanced;
    }

    public static SkinMenu createAddToPlaylistSubMenu() {
        BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
        if (downloaders.length == 0) {
            return null;
        }
        for (BTDownload dler : downloaders) {
            if (!dler.isCompleted()) {
                return null;
            }
            File saveLocation = dler.getSaveLocation();
            if (!(saveLocation.isDirectory() ? !LibraryUtils.directoryContainsAudio(saveLocation) : !MediaPlayer.isPlayableFile(saveLocation))) continue;
            return null;
        }
        SkinMenu menu = new SkinMenu(I18n.tr("Add to playlist"));
        menu.add(new SkinMenuItem(new BTDownloadActions.CreateNewPlaylistAction()));
        Library library = LibraryMediator.getLibrary();
        List<Playlist> playlists = library.getPlaylists();
        if (playlists.size() > 0) {
            menu.addSeparator();
            for (Playlist playlist : library.getPlaylists()) {
                menu.add(new SkinMenuItem(new BTDownloadActions.AddToPlaylistAction(playlist)));
            }
        }
        return menu;
    }

    public static SkinMenu createTrackerMenu() {
        com.frostwire.bittorrent.BTDownload[] dms = BTDownloadMediatorAdvancedMenuFactory.getSingleSelectedDownloadManagers();
        if (dms == null) {
            return null;
        }
        SkinMenu menu = new SkinMenu(I18n.tr("Trackers"));
        menu.add(new SkinMenuItem(new EditTrackersAction(dms[0])));
        menu.add(new SkinMenuItem(new UpdateTrackerAction(dms[0])));
        menu.add(new SkinMenuItem(new ScrapeTrackerAction(dms[0])));
        return menu;
    }

    private static com.frostwire.bittorrent.BTDownload[] getSingleSelectedDownloadManagers() {
        BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
        if (downloaders.length != 1) {
            return null;
        }
        ArrayList<com.frostwire.bittorrent.BTDownload> list = new ArrayList<com.frostwire.bittorrent.BTDownload>(downloaders.length);
        for (BTDownload downloader : downloaders) {
            com.frostwire.bittorrent.BTDownload dm;
            if (!(downloader instanceof BittorrentDownload) || (dm = ((BittorrentDownload)downloader).getDl()) == null) continue;
            list.add(dm);
        }
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new com.frostwire.bittorrent.BTDownload[0]);
    }

    private static void addSpeedMenu(SkinMenu menuAdvanced, boolean isTorrentContext, boolean hasSelection, boolean downSpeedDisabled, boolean downSpeedUnlimited, long totalDownSpeed, long downSpeedSetMax, long maxDownload, boolean upSpeedDisabled, boolean upSpeedUnlimited, long totalUpSpeed, long upSpeedSetMax, long maxUpload, int num_entries, final SpeedAdapter adapter) {
        SkinMenu menuDownSpeed = new SkinMenu(I18n.tr("Set Down Speed"));
        menuAdvanced.add(menuDownSpeed);
        SkinMenuItem itemCurrentDownSpeed = new SkinMenuItem();
        itemCurrentDownSpeed.setEnabled(false);
        StringBuffer speedText = new StringBuffer();
        String separator = "";
        if (downSpeedDisabled) {
            speedText.append(I18n.tr("Disabled"));
            separator = " / ";
        }
        if (downSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(I18n.tr("Unlimited"));
            separator = " / ";
        }
        if (totalDownSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalDownSpeed));
        }
        itemCurrentDownSpeed.setText(speedText.toString());
        menuDownSpeed.add(itemCurrentDownSpeed);
        menuDownSpeed.addSeparator();
        SkinMenuItem[] itemsDownSpeed = new SkinMenuItem[12];
        ActionListener itemsDownSpeedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != null && e.getSource() instanceof SkinMenuItem) {
                    SkinMenuItem item = (SkinMenuItem)e.getSource();
                    int speed = item.getClientProperty("maxdl") == null ? 0 : (Integer)item.getClientProperty("maxdl");
                    adapter.setDownSpeed(speed);
                }
            }
        };
        itemsDownSpeed[1] = new SkinMenuItem();
        itemsDownSpeed[1].setText(I18n.tr("No limit"));
        itemsDownSpeed[1].putClientProperty("maxdl", new Integer(0));
        itemsDownSpeed[1].addActionListener(itemsDownSpeedListener);
        menuDownSpeed.add(itemsDownSpeed[1]);
        if (hasSelection) {
            if (maxDownload == 0L) {
                maxDownload = downSpeedSetMax == 0L ? 204800L : 4L * (downSpeedSetMax / 1024L) * 1024L;
            }
            for (int i = 2; i < 12; ++i) {
                itemsDownSpeed[i] = new SkinMenuItem();
                itemsDownSpeed[i].addActionListener(itemsDownSpeedListener);
                int limit = (int)(maxDownload / (long)(10 * num_entries) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries));
                itemsDownSpeed[i].setText(speed.toString());
                itemsDownSpeed[i].putClientProperty("maxdl", new Integer(limit));
                menuDownSpeed.add(itemsDownSpeed[i]);
            }
        }
        SkinMenu menuUpSpeed = new SkinMenu(I18n.tr("Set Up Speed"));
        menuAdvanced.add(menuUpSpeed);
        SkinMenuItem itemCurrentUpSpeed = new SkinMenuItem();
        itemCurrentUpSpeed.setEnabled(false);
        separator = "";
        speedText = new StringBuffer();
        if (upSpeedDisabled) {
            speedText.append(I18n.tr("Disabled"));
            separator = " / ";
        }
        if (upSpeedUnlimited) {
            speedText.append(separator);
            speedText.append(I18n.tr("Unlimited"));
            separator = " / ";
        }
        if (totalUpSpeed > 0L) {
            speedText.append(separator);
            speedText.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(totalUpSpeed));
        }
        itemCurrentUpSpeed.setText(speedText.toString());
        menuUpSpeed.add(itemCurrentUpSpeed);
        menuUpSpeed.addSeparator();
        SkinMenuItem[] itemsUpSpeed = new SkinMenuItem[12];
        ActionListener itemsUpSpeedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() != null && e.getSource() instanceof SkinMenuItem) {
                    SkinMenuItem item = (SkinMenuItem)e.getSource();
                    int speed = item.getClientProperty("maxul") == null ? 0 : (Integer)item.getClientProperty("maxul");
                    adapter.setUpSpeed(speed);
                }
            }
        };
        itemsUpSpeed[1] = new SkinMenuItem();
        itemsUpSpeed[1].setText(I18n.tr("No limit"));
        itemsUpSpeed[1].putClientProperty("maxul", new Integer(0));
        itemsUpSpeed[1].addActionListener(itemsUpSpeedListener);
        menuUpSpeed.add(itemsUpSpeed[1]);
        if (hasSelection) {
            maxUpload = maxUpload == 0L ? 76800L : (upSpeedSetMax == 0L ? 204800L : 4L * (upSpeedSetMax / 1024L) * 1024L);
            for (int i = 2; i < 12; ++i) {
                itemsUpSpeed[i] = new SkinMenuItem();
                itemsUpSpeed[i].addActionListener(itemsUpSpeedListener);
                int limit = (int)(maxUpload / (long)(10 * num_entries) * (long)(12 - i));
                StringBuffer speed = new StringBuffer();
                speed.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(limit * num_entries));
                itemsUpSpeed[i].setText(speed.toString());
                itemsUpSpeed[i].putClientProperty("maxul", new Integer(limit));
                menuUpSpeed.add(itemsUpSpeed[i]);
            }
        }
    }

    private static final class EditTrackerDialog
    extends JDialog {
        private final com.frostwire.bittorrent.BTDownload dm;

        public EditTrackerDialog(JFrame frame, com.frostwire.bittorrent.BTDownload dm) {
            super(frame);
            this.dm = dm;
            this.setupUI();
            this.setLocationRelativeTo(frame);
        }

        protected void setupUI() {
            this.setTitle(I18n.tr("Edit trackers"));
            Dimension dim = new Dimension(512, 400);
            this.setSize(dim);
            this.setMinimumSize(dim);
            this.setPreferredSize(dim);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            GUIUtils.addHideAction((JComponent)this.getContentPane());
            JPanel panel = new JPanel();
            panel.setLayout(new MigLayout("", "[grow]", "[top][center, grow][bottom]"));
            JLabel labelTitle = new JLabel(I18n.tr("Edit trackers, one by line"));
            panel.add((Component)labelTitle, "cell 0 0");
            final JTextArea textTrackers = new JTextArea();
            ThemeMediator.fixKeyStrokes(textTrackers);
            JScrollPane scrollPane = new JScrollPane(textTrackers);
            scrollPane.setVerticalScrollBarPolicy(20);
            this.fillTrackers(textTrackers);
            panel.add((Component)scrollPane, "cell 0 1, growx, growy");
            JButton buttonAccept = new JButton(I18n.tr("Accept"));
            buttonAccept.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.changeTrackers(textTrackers.getText());
                }
            });
            panel.add((Component)buttonAccept, "cell 0 2, split 2, right");
            JButton buttonCancel = new JButton(I18n.tr("Cancel"));
            buttonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.dispose();
                }
            });
            panel.add(buttonCancel);
            this.setContentPane(panel);
        }

        private void fillTrackers(JTextArea textTrackers) {
            Set<String> set = this.dm.trackers();
            for (String tracker : set) {
                if (StringUtils.isNullOrEmpty(tracker, true)) continue;
                textTrackers.append(tracker.trim() + System.lineSeparator());
            }
        }

        private void changeTrackers(String text) {
            List<String> urls = Arrays.asList(text.split(System.lineSeparator()));
            if (!this.validateTrackersUrls(urls)) {
                JOptionPane.showMessageDialog(this, I18n.tr("Check again your tracker URL(s).\n"), I18n.tr("Invalid Tracker URL\n"), 0);
            } else {
                this.setTrackersUrls(urls);
                this.dispose();
            }
        }

        private boolean validateTrackersUrls(List<String> urls) {
            if (urls == null || urls.size() == 0) {
                return false;
            }
            String patternStr = "^(https?|udp)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
            Pattern pattern = Pattern.compile(patternStr);
            for (String tracker_url : urls) {
                Matcher matcher;
                if (tracker_url.trim().equals("") || (matcher = pattern.matcher(tracker_url.trim())).matches()) continue;
                return false;
            }
            return true;
        }

        private void setTrackersUrls(List<String> urls) {
            this.dm.trackers(new HashSet<String>(urls));
        }
    }

    public static class ScrapeTrackerAction
    extends AbstractAction {
        private final com.frostwire.bittorrent.BTDownload dm;

        public ScrapeTrackerAction(com.frostwire.bittorrent.BTDownload dm) {
            this.dm = dm;
            this.putValue("Name", I18n.tr("Scrape Tracker"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    dm.requestTrackerScrape();
                }
            }).start();
        }
    }

    public static class UpdateTrackerAction
    extends AbstractAction {
        private final com.frostwire.bittorrent.BTDownload dm;

        public UpdateTrackerAction(com.frostwire.bittorrent.BTDownload dm) {
            this.dm = dm;
            this.putValue("Name", I18n.tr("Update Tracker"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    dm.requestTrackerAnnounce();
                }
            }).start();
        }
    }

    public static class EditTrackersAction
    extends AbstractAction {
        private final com.frostwire.bittorrent.BTDownload dm;

        public EditTrackersAction(com.frostwire.bittorrent.BTDownload dm) {
            this.dm = dm;
            this.putValue("Name", I18n.tr("Edit Trackers"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new EditTrackerDialog(GUIMediator.getAppFrame(), this.dm).setVisible(true);
        }
    }

    public static interface SpeedAdapter {
        public void setUpSpeed(int var1);

        public void setDownSpeed(int var1);
    }
}

