/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.gui.bittorrent;

import com.frostwire.alexandria.Playlist;
import com.frostwire.bittorrent.BTEngine;
import com.frostwire.gui.bittorrent.BTDownload;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.bittorrent.BittorrentDownload;
import com.frostwire.gui.bittorrent.ShareTorrentDialog;
import com.frostwire.gui.bittorrent.TorrentFetcherDownload;
import com.frostwire.gui.bittorrent.TorrentUtil;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.library.LibraryUtils;
import com.frostwire.gui.player.MediaPlayer;
import com.frostwire.gui.player.MediaSource;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.uxstats.UXStats;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.iTunesMediator;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;

final class BTDownloadActions {
    static final ExploreAction EXPLORE_ACTION = new ExploreAction();
    static final ShowInLibraryAction SHOW_IN_LIBRARY_ACTION = new ShowInLibraryAction();
    static final ResumeAction RESUME_ACTION = new ResumeAction();
    static final PauseAction PAUSE_ACTION = new PauseAction();
    static final ClearInactiveAction CLEAR_INACTIVE_ACTION = new ClearInactiveAction();
    static final RemoveAction REMOVE_ACTION = new RemoveAction(false, false);
    static final RemoveAction REMOVE_YOUTUBE_ACTION = new RemoveYouTubeAction();
    static final RemoveAction REMOVE_TORRENT_ACTION = new RemoveAction(true, false);
    static final RemoveAction REMOVE_TORRENT_AND_DATA_ACTION = new RemoveAction(true, true);
    static final CopyMagnetAction COPY_MAGNET_ACTION = new CopyMagnetAction();
    static final CopyInfoHashAction COPY_HASH_ACTION = new CopyInfoHashAction();
    static final SendBTDownloaderAudioFilesToiTunes SEND_TO_ITUNES_ACTION = new SendBTDownloaderAudioFilesToiTunes();
    static final ShareTorrentAction SHARE_TORRENT_ACTION = new ShareTorrentAction();
    static final PlaySingleMediaFileAction PLAY_SINGLE_AUDIO_FILE_ACTION = new PlaySingleMediaFileAction();

    BTDownloadActions() {
    }

    static class AddToPlaylistAction
    extends AbstractAction {
        private static final int MAX_VISIBLE_PLAYLIST_NAME_LENGTH_IN_MENU = 80;
        private Playlist playlist;

        public AddToPlaylistAction(Playlist playlist) {
            super(AddToPlaylistAction.getTruncatedString(playlist.getName(), 80));
            this.putValue("LongDescription", I18n.tr("Add to playlist") + " \"" + this.getValue("Name") + "\"");
            System.out.println("Truncated playlist name was: " + this.getValue("Name"));
            this.playlist = playlist;
        }

        private static String getTruncatedString(String string, int MAX_LENGTH) {
            return string.length() > MAX_LENGTH ? string.substring(0, MAX_LENGTH - 1) + "..." : string;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            ArrayList<File> playlistFiles = new ArrayList<File>(downloaders.length);
            for (BTDownload d : downloaders) {
                if (!d.isCompleted()) {
                    return;
                }
                playlistFiles.add(d.getSaveLocation());
            }
            LibraryUtils.asyncAddToPlaylist(this.playlist, playlistFiles.toArray(new File[0]));
            GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        }
    }

    static final class PlaySingleMediaFileAction
    extends AbstractAction {
        PlaySingleMediaFileAction() {
            super(I18n.tr("Play file"));
            this.putValue("LongDescription", I18n.tr("Play media file"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = BTDownloadMediator.instance().getSelectedDownloaders()[0].getSaveLocation();
            if (file.isDirectory() && LibraryUtils.directoryContainsASinglePlayableFile(file)) {
                try {
                    file = file.listFiles()[0];
                }
                catch (Throwable t) {
                    file = null;
                }
            }
            if (file != null && MediaPlayer.isPlayableFile(file)) {
                MediaPlayer.instance().loadMedia(new MediaSource(file), false, false);
            }
        }
    }

    static class CreateNewPlaylistAction
    extends AbstractAction {
        CreateNewPlaylistAction() {
            super(I18n.tr("Create New Playlist"));
            this.putValue("LongDescription", I18n.tr("Create and add to a new playlist"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            ArrayList<File> playlistFiles = new ArrayList<File>(downloaders.length);
            for (BTDownload d : downloaders) {
                if (!d.isCompleted()) {
                    return;
                }
                File downloadFolder = new File(d.getSaveLocation(), d.getDisplayName());
                if (!downloadFolder.exists()) continue;
                playlistFiles.add(downloadFolder);
            }
            LibraryUtils.createNewPlaylist(playlistFiles.toArray(new File[0]));
        }
    }

    private static class ShareTorrentAction
    extends RefreshingAction {
        ShareTorrentAction() {
            this.putValue("Name", I18n.tr("Send to friend"));
            this.putValue("LimeShortName", I18n.tr("Send to friend"));
            this.putValue("ShortDescription", I18n.tr("Send to friend"));
            this.putValue("LimeIconName", "SEND_HASH");
        }

        @Override
        public void performAction(ActionEvent e) {
            TorrentInfo t;
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length != 1) {
                return;
            }
            BTDownload btDownload = downloaders[0];
            if (btDownload instanceof BittorrentDownload && (t = ((BittorrentDownload)btDownload).getTorrentInfo()) != null) {
                new ShareTorrentDialog(GUIMediator.getAppFrame(), t).setVisible(true);
            }
        }
    }

    private static class CopyInfoHashAction
    extends RefreshingAction {
        CopyInfoHashAction() {
            this.putValue("Name", I18n.tr("Copy Infohash"));
            this.putValue("LimeShortName", I18n.tr("Copy Infohash"));
            this.putValue("ShortDescription", I18n.tr("Copy Infohash"));
            this.putValue("LimeIconName", "COPY_HASH");
        }

        @Override
        public void performAction(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            String str = "";
            for (int i = 0; i < downloaders.length; ++i) {
                str = str + downloaders[i].getHash();
                if (i >= downloaders.length - 1) continue;
                str = str + "\n";
            }
            GUIMediator.setClipboardContent(str);
        }
    }

    private static class CopyMagnetAction
    extends RefreshingAction {
        CopyMagnetAction() {
            this.putValue("Name", I18n.tr("Copy Magnet"));
            this.putValue("LimeShortName", I18n.tr("Copy Magnet"));
            this.putValue("ShortDescription", I18n.tr("Copy Magnet"));
            this.putValue("LimeIconName", "COPY_MAGNET");
        }

        @Override
        public void performAction(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            String str = "";
            for (int i = 0; i < downloaders.length; ++i) {
                TorrentFetcherDownload tfd;
                BTDownload d = downloaders[i];
                if (d instanceof BittorrentDownload) {
                    BittorrentDownload btDownload = (BittorrentDownload)d;
                    String magnetUri = btDownload.makeMagnetUri();
                    str = str + magnetUri;
                    str = str + BTEngine.getInstance().magnetPeers();
                    if (i >= downloaders.length - 1) continue;
                    str = str + System.lineSeparator();
                    continue;
                }
                if (!(d instanceof TorrentFetcherDownload) || !(tfd = (TorrentFetcherDownload)d).getUri().startsWith("magnet")) continue;
                str = tfd.getUri();
            }
            GUIMediator.setClipboardContent(str);
        }
    }

    private static class ClearInactiveAction
    extends RefreshingAction {
        ClearInactiveAction() {
            this.putValue("Name", I18n.tr("Clear Inactive"));
            this.putValue("LimeShortName", I18n.tr("Clear Inactive"));
            this.putValue("ShortDescription", I18n.tr("Clear Inactive (completed) transfers from the Transfers list."));
            this.putValue("LimeIconName", "DOWNLOAD_CLEAR_INACTIVE");
        }

        @Override
        protected void performAction(ActionEvent e) {
            BTDownloadMediator.instance().removeCompleted();
        }
    }

    public static class RemoveYouTubeAction
    extends RemoveAction {
        private static final long serialVersionUID = 4101890173830827703L;

        public RemoveYouTubeAction() {
            super(true, true);
            this.putValue("Name", I18n.tr("Remove Download and Data"));
            this.putValue("LimeShortName", I18n.tr("Remove Download and Data"));
            this.putValue("ShortDescription", I18n.tr("Remove Download and Data from selected downloads"));
        }
    }

    public static class RemoveAction
    extends RefreshingAction {
        private static final long serialVersionUID = -1742554445891016991L;
        private final boolean _deleteTorrent;
        private final boolean _deleteData;

        public RemoveAction(boolean deleteTorrent, boolean deleteData) {
            if (deleteTorrent && deleteData) {
                this.putValue("Name", I18n.tr("Remove Torrent and Data"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent and Data"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent and Data from selected downloads"));
            } else if (deleteTorrent) {
                this.putValue("Name", I18n.tr("Remove Torrent"));
                this.putValue("LimeShortName", I18n.tr("Remove Torrent"));
                this.putValue("ShortDescription", I18n.tr("Remove Torrent from selected downloads"));
            } else {
                this.putValue("Name", I18n.tr("Remove Download"));
                this.putValue("LimeShortName", I18n.tr("Remove"));
                this.putValue("ShortDescription", I18n.tr("Remove Selected Downloads"));
            }
            this.putValue("LimeIconName", "DOWNLOAD_KILL");
            this._deleteTorrent = deleteTorrent;
            this._deleteData = deleteData;
        }

        @Override
        public void performAction(ActionEvent e) {
            DialogOption result;
            if (this._deleteData && (result = GUIMediator.showYesNoMessage(I18n.tr("Are you sure you want to remove the data files from your computer?\n\nYou won't be able to recover the files."), I18n.tr("Are you sure?"), 3)) != DialogOption.YES) {
                return;
            }
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            for (int i = 0; i < downloaders.length; ++i) {
                downloaders[i].setDeleteTorrentWhenRemove(this._deleteTorrent);
                downloaders[i].setDeleteDataWhenRemove(this._deleteData);
            }
            BTDownloadMediator.instance().removeSelection();
            BTDownloadMediator.instance().updateTableFilters();
            UXStats.instance().log(2012);
        }
    }

    private static class PauseAction
    extends RefreshingAction {
        public PauseAction() {
            this.putValue("Name", I18n.tr("Pause Download"));
            this.putValue("LimeShortName", I18n.tr("Pause"));
            this.putValue("ShortDescription", I18n.tr("Pause Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_PAUSE");
        }

        @Override
        public void performAction(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            BTDownload lastSelectedDownload = null;
            if (downloaders.length == 1) {
                lastSelectedDownload = downloaders[0];
            }
            for (int i = 0; i < downloaders.length; ++i) {
                downloaders[i].pause();
            }
            BTDownloadMediator.instance().updateTableFilters();
            UXStats.instance().log(2010);
            if (lastSelectedDownload != null) {
                BTDownloadMediator.instance().selectBTDownload(lastSelectedDownload);
            }
        }
    }

    private static class ResumeAction
    extends RefreshingAction {
        public ResumeAction() {
            this.putValue("Name", I18n.tr("Resume Download"));
            this.putValue("LimeShortName", I18n.tr("Resume"));
            this.putValue("ShortDescription", I18n.tr("Reattempt Selected Downloads"));
            this.putValue("LimeIconName", "DOWNLOAD_FILE_MORE_SOURCES");
        }

        @Override
        public void performAction(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            BTDownload lastSelectedDownload = null;
            if (downloaders.length == 1) {
                lastSelectedDownload = downloaders[0];
            }
            TorrentUtil.askForPermissionToSeedAndSeedDownloads(downloaders);
            BTDownloadMediator.instance().updateTableFilters();
            if (lastSelectedDownload != null) {
                BTDownloadMediator.instance().selectBTDownload(lastSelectedDownload);
            }
        }
    }

    private static class ShowInLibraryAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        public ShowInLibraryAction() {
            this.putValue("Name", I18n.tr("Show"));
            this.putValue("LimeShortName", I18n.tr("Show"));
            this.putValue("ShortDescription", I18n.tr("Shows the contents of this transfer in the Library Tab"));
            this.putValue("LimeIconName", "DOWNLOAD_SHOW_IN_LIBRARY");
        }

        @Override
        public void performAction(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length > 0) {
                String toExplore = downloaders[0].getDisplayName();
                if (toExplore == null) {
                    return;
                }
                LibraryMediator.instance().getLibrarySearch().searchFor(toExplore.replace("_", " ").replace("-", " ").replace(".", " "), false);
            }
        }
    }

    private static class ExploreAction
    extends RefreshingAction {
        private static final long serialVersionUID = -4648558721588938475L;

        public ExploreAction() {
            this.putValue("Name", I18n.tr("Explore"));
            this.putValue("LimeShortName", I18n.tr("Explore"));
            this.putValue("ShortDescription", I18n.tr("Open Folder Containing the File"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        public void performAction(ActionEvent e) {
            File toExplore;
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders.length > 0 && (toExplore = new File(downloaders[0].getSaveLocation(), downloaders[0].getDisplayName())) != null) {
                if (!toExplore.exists() && downloaders[0].getSaveLocation() != null && downloaders[0].getSaveLocation().isFile()) {
                    toExplore = downloaders[0].getSaveLocation();
                }
                if (toExplore.exists()) {
                    GUIMediator.launchExplorer(toExplore);
                }
            }
        }
    }

    private static class ShowDetailsAction
    extends RefreshingAction {
        private static final long serialVersionUID = 6100070262538050091L;

        public ShowDetailsAction() {
            this.putValue("Name", I18n.tr("Details"));
            this.putValue("LimeShortName", I18n.tr("Show Details"));
            this.putValue("ShortDescription", I18n.tr("Show Torrent Details"));
            this.putValue("LimeIconName", "LIBRARY_EXPLORE");
        }

        @Override
        protected void performAction(ActionEvent e) {
            System.out.println("Pending implementation");
        }
    }

    private static abstract class RefreshingAction
    extends AbstractAction {
        private RefreshingAction() {
        }

        @Override
        public final void actionPerformed(ActionEvent e) {
            this.performAction(e);
            BTDownloadMediator.instance().doRefresh();
        }

        protected abstract void performAction(ActionEvent var1);
    }

    private static class SendBTDownloaderAudioFilesToiTunes
    extends AbstractAction {
        public SendBTDownloaderAudioFilesToiTunes() {
            this.putValue("Name", I18n.tr("Send to iTunes"));
            this.putValue("ShortDescription", I18n.tr("Send files to iTunes"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BTDownload[] downloaders = BTDownloadMediator.instance().getSelectedDownloaders();
            if (downloaders != null && downloaders.length > 0) {
                try {
                    BTDownload downloader = downloaders[0];
                    File saveLocation = downloader.getSaveLocation();
                    if (downloader instanceof BittorrentDownload) {
                        BittorrentDownload btDownload = (BittorrentDownload)downloader;
                        saveLocation = new File(btDownload.getSaveLocation(), btDownload.getName());
                    }
                    System.out.println("Sending to iTunes " + saveLocation.getAbsolutePath());
                    iTunesMediator.instance().scanForSongs(saveLocation);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

