/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.frostwire.bittorrent.Mappable;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.licenses.License;
import com.frostwire.licenses.Licenses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CopyrightLicenseBroker
implements Mappable<String, Map<String, String>> {
    public final LicenseCategory licenseCategory;
    public final License license;
    public final String attributionTitle;
    public final String attributionAuthor;
    public final String attributionUrl;
    public static final List<String> validLicenseUrls = new ArrayList<String>();
    public static final Map<String, License> urlToLicense;

    public CopyrightLicenseBroker(boolean shareAlike, boolean nonCommercial, boolean noDerivatives, String attributionTitle, String attributionAuthor, String attributionURL) {
        this.licenseCategory = LicenseCategory.CreativeCommons;
        String licenseUrl = CopyrightLicenseBroker.getCreativeCommonsLicenseUrl(shareAlike, nonCommercial, noDerivatives);
        if (CopyrightLicenseBroker.isInvalidLicense(licenseUrl)) {
            throw new IllegalArgumentException("The given license string is invalid.");
        }
        this.license = urlToLicense.get(licenseUrl);
        this.attributionTitle = attributionTitle;
        this.attributionAuthor = attributionAuthor;
        this.attributionUrl = attributionURL;
    }

    public CopyrightLicenseBroker(Map<String, Entry> map) {
        this.licenseCategory = map.containsKey("creative-commons") ? LicenseCategory.CreativeCommons : (map.containsKey("open-source") ? LicenseCategory.OpenSource : (map.containsKey("public-domain") ? LicenseCategory.PublicDomain : LicenseCategory.NoLicense));
        if (this.licenseCategory != LicenseCategory.NoLicense) {
            Map<String, Entry> innerMap = map.get(this.licenseCategory.toString()).dictionary();
            String licenseUrl = innerMap.get("licenseUrl").string();
            this.license = urlToLicense.get(licenseUrl);
            this.attributionTitle = innerMap.get("attributionTitle").string();
            this.attributionAuthor = innerMap.get("attributionAuthor").string();
            this.attributionUrl = innerMap.get("attributionUrl").string();
        } else {
            this.license = null;
            this.attributionTitle = null;
            this.attributionAuthor = null;
            this.attributionUrl = null;
        }
    }

    public CopyrightLicenseBroker(LicenseCategory category, License license, String title, String author, String attributionUrl) {
        this.licenseCategory = category;
        this.license = license;
        this.attributionTitle = title;
        this.attributionAuthor = author;
        this.attributionUrl = attributionUrl;
    }

    @Override
    public Map<String, Map<String, String>> asMap() {
        HashMap<String, Map<String, String>> container = new HashMap<String, Map<String, String>>();
        HashMap<String, String> innerMap = new HashMap<String, String>();
        innerMap.put("licenseUrl", this.license.getUrl());
        innerMap.put("attributionTitle", this.attributionTitle);
        innerMap.put("attributionAuthor", this.attributionAuthor);
        innerMap.put("attributionUrl", this.attributionUrl);
        container.put(this.licenseCategory.toString(), innerMap);
        return container;
    }

    public String getLicenseName() {
        return this.license != null ? this.license.getName() : null;
    }

    private static boolean isInvalidLicense(String licenseStr) {
        return licenseStr == null || licenseStr.isEmpty() || !validLicenseUrls.contains(licenseStr);
    }

    public static String getCreativeCommonsLicenseUrl(boolean shareAlike, boolean nonCommercial, boolean noDerivatives) {
        if (nonCommercial && shareAlike) {
            noDerivatives = false;
        } else if (nonCommercial && noDerivatives) {
            shareAlike = false;
        } else if (shareAlike) {
            noDerivatives = false;
        }
        String licenseShortCode = "by-" + (nonCommercial ? "nc-" : "") + (shareAlike ? "sa" : "") + (noDerivatives ? "-nd" : "");
        licenseShortCode = licenseShortCode.replace("--", "-");
        if (licenseShortCode.endsWith("-")) {
            licenseShortCode = licenseShortCode.substring(0, licenseShortCode.length() - 1);
        }
        return "http://creativecommons.org/licenses/" + licenseShortCode + "/4.0/";
    }

    static {
        validLicenseUrls.add(Licenses.CC_BY_4.getUrl());
        validLicenseUrls.add(Licenses.CC_BY_SA_4.getUrl());
        validLicenseUrls.add(Licenses.CC_BY_ND_4.getUrl());
        validLicenseUrls.add(Licenses.CC_BY_NC_4.getUrl());
        validLicenseUrls.add(Licenses.CC_BY_NC_SA_4.getUrl());
        validLicenseUrls.add(Licenses.CC_BY_NC_ND_4.getUrl());
        urlToLicense = new HashMap<String, License>();
        urlToLicense.put(Licenses.CC_BY_4.getUrl(), Licenses.CC_BY_4);
        urlToLicense.put(Licenses.CC_BY_SA_4.getUrl(), Licenses.CC_BY_SA_4);
        urlToLicense.put(Licenses.CC_BY_ND_4.getUrl(), Licenses.CC_BY_ND_4);
        urlToLicense.put(Licenses.CC_BY_NC_4.getUrl(), Licenses.CC_BY_NC_4);
        urlToLicense.put(Licenses.CC_BY_NC_SA_4.getUrl(), Licenses.CC_BY_NC_SA_4);
        urlToLicense.put(Licenses.CC_BY_NC_ND_4.getUrl(), Licenses.CC_BY_NC_ND_4);
        urlToLicense.put(Licenses.APACHE.getUrl(), Licenses.APACHE);
        urlToLicense.put(Licenses.BSD_2_CLAUSE.getUrl(), Licenses.BSD_2_CLAUSE);
        urlToLicense.put(Licenses.BSD_3_CLAUSE.getUrl(), Licenses.BSD_3_CLAUSE);
        urlToLicense.put(Licenses.GPL3.getUrl(), Licenses.GPL3);
        urlToLicense.put(Licenses.LGPL.getUrl(), Licenses.LGPL);
        urlToLicense.put(Licenses.MIT.getUrl(), Licenses.MIT);
        urlToLicense.put(Licenses.MOZILLA.getUrl(), Licenses.MOZILLA);
        urlToLicense.put(Licenses.CDDL.getUrl(), Licenses.CDDL);
        urlToLicense.put(Licenses.ECLIPSE.getUrl(), Licenses.ECLIPSE);
        urlToLicense.put(Licenses.PUBLIC_DOMAIN_MARK.getUrl(), Licenses.PUBLIC_DOMAIN_MARK);
        urlToLicense.put(Licenses.PUBLIC_DOMAIN_CC0.getUrl(), Licenses.PUBLIC_DOMAIN_CC0);
    }

    public static enum LicenseCategory {
        CreativeCommons("creative-commons"),
        OpenSource("open-source"),
        PublicDomain("public-domain"),
        NoLicense("no-license");

        private String name;

        private LicenseCategory(String stringName) {
            this.name = stringName;
        }

        public String toString() {
            return this.name;
        }
    }
}

