/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.bittorrent;

import com.frostwire.bittorrent.BTContext;
import com.frostwire.bittorrent.BTDownload;
import com.frostwire.bittorrent.BTEngineListener;
import com.frostwire.jlibtorrent.AlertListener;
import com.frostwire.jlibtorrent.Entry;
import com.frostwire.jlibtorrent.Priority;
import com.frostwire.jlibtorrent.SessionManager;
import com.frostwire.jlibtorrent.SessionParams;
import com.frostwire.jlibtorrent.SettingsPack;
import com.frostwire.jlibtorrent.TcpEndpoint;
import com.frostwire.jlibtorrent.TorrentHandle;
import com.frostwire.jlibtorrent.TorrentInfo;
import com.frostwire.jlibtorrent.Vectors;
import com.frostwire.jlibtorrent.alerts.Alert;
import com.frostwire.jlibtorrent.alerts.AlertType;
import com.frostwire.jlibtorrent.alerts.ExternalIpAlert;
import com.frostwire.jlibtorrent.alerts.FastresumeRejectedAlert;
import com.frostwire.jlibtorrent.alerts.ListenFailedAlert;
import com.frostwire.jlibtorrent.alerts.ListenSucceededAlert;
import com.frostwire.jlibtorrent.alerts.TorrentAlert;
import com.frostwire.jlibtorrent.swig.bdecode_node;
import com.frostwire.jlibtorrent.swig.byte_vector;
import com.frostwire.jlibtorrent.swig.entry;
import com.frostwire.jlibtorrent.swig.error_code;
import com.frostwire.jlibtorrent.swig.libtorrent;
import com.frostwire.jlibtorrent.swig.session_params;
import com.frostwire.jlibtorrent.swig.settings_pack;
import com.frostwire.platform.FileSystem;
import com.frostwire.platform.Platforms;
import com.frostwire.search.torrent.TorrentCrawledSearchResult;
import com.frostwire.util.Logger;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class BTEngine
extends SessionManager {
    private static final Logger LOG = Logger.getLogger(BTEngine.class);
    private static final int[] INNER_LISTENER_TYPES = new int[]{AlertType.ADD_TORRENT.swig(), AlertType.LISTEN_SUCCEEDED.swig(), AlertType.LISTEN_FAILED.swig(), AlertType.EXTERNAL_IP.swig(), AlertType.FASTRESUME_REJECTED.swig(), AlertType.DHT_BOOTSTRAP.swig(), AlertType.TORRENT_LOG.swig(), AlertType.PEER_LOG.swig(), AlertType.LOG.swig()};
    private static final String TORRENT_ORIG_PATH_KEY = "torrent_orig_path";
    private static final String STATE_VERSION_KEY = "state_version";
    private static final String STATE_VERSION_VALUE = "1.2.0.6";
    public static BTContext ctx;
    private final InnerListener innerListener = new InnerListener();
    private final Queue<RestoreDownloadTask> restoreDownloadsQueue = new LinkedList<RestoreDownloadTask>();
    private BTEngineListener listener;
    private static final CountDownLatch ctxSetupLatch;

    private BTEngine() {
        super(false);
    }

    public static BTEngine getInstance() {
        if (ctx == null) {
            try {
                ctxSetupLatch.await();
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), e);
            }
            if (ctx == null && Loader.INSTANCE.isRunning()) {
                throw new IllegalStateException("BTContext can't be null");
            }
        }
        return Loader.INSTANCE;
    }

    public static void onCtxSetupComplete() {
        ctxSetupLatch.countDown();
    }

    public BTEngineListener getListener() {
        return this.listener;
    }

    public void setListener(BTEngineListener listener) {
        this.listener = listener;
    }

    @Override
    public void start() {
        SessionParams params = this.loadSettings();
        settings_pack sp = params.settings().swig();
        sp.set_str(settings_pack.string_types.listen_interfaces.swigValue(), BTEngine.ctx.interfaces);
        sp.set_int(settings_pack.int_types.max_retry_port_bind.swigValue(), BTEngine.ctx.retries);
        sp.set_str(settings_pack.string_types.dht_bootstrap_nodes.swigValue(), BTEngine.dhtBootstrapNodes());
        sp.set_int(settings_pack.int_types.active_limit.swigValue(), 2000);
        sp.set_int(settings_pack.int_types.stop_tracker_timeout.swigValue(), 0);
        sp.set_int(settings_pack.int_types.alert_queue_size.swigValue(), 5000);
        sp.set_bool(settings_pack.bool_types.enable_dht.swigValue(), BTEngine.ctx.enableDht);
        sp.set_bool(settings_pack.bool_types.upnp_ignore_nonrouters.swigValue(), true);
        if (BTEngine.ctx.optimizeMemory) {
            sp.set_bool(settings_pack.bool_types.enable_ip_notifier.swigValue(), false);
        }
        String fwFingerPrint = libtorrent.generate_fingerprint("FW", BTEngine.ctx.version[0], BTEngine.ctx.version[1], BTEngine.ctx.version[2], BTEngine.ctx.version[3]);
        sp.set_str(settings_pack.string_types.peer_fingerprint.swigValue(), fwFingerPrint);
        String userAgent = String.format(Locale.ENGLISH, "FrostWire/%d.%d.%d libtorrent/%s", BTEngine.ctx.version[0], BTEngine.ctx.version[1], BTEngine.ctx.version[2], libtorrent.version());
        sp.set_str(settings_pack.string_types.user_agent.swigValue(), userAgent);
        System.out.println("Peer Fingerprint: " + sp.get_str(settings_pack.string_types.peer_fingerprint.swigValue()));
        System.out.println("User Agent: " + sp.get_str(settings_pack.string_types.user_agent.swigValue()));
        super.start(params);
    }

    @Override
    public void stop() {
        super.stop();
        if (ctx == null) {
            BTEngine.onCtxSetupComplete();
        }
    }

    @Override
    protected void onBeforeStart() {
        this.addListener(this.innerListener);
    }

    @Override
    protected void onAfterStart() {
        this.fireStarted();
    }

    @Override
    protected void onBeforeStop() {
        this.removeListener(this.innerListener);
        this.saveSettings();
    }

    @Override
    protected void onAfterStop() {
        this.fireStopped();
    }

    @Override
    public void moveStorage(File dataDir) {
        if (this.swig() == null) {
            return;
        }
        BTEngine.ctx.dataDir = dataDir;
        super.moveStorage(dataDir);
    }

    private SessionParams loadSettings() {
        try {
            File f = this.settingsFile();
            if (f.exists()) {
                error_code ec;
                bdecode_node n;
                byte[] data = FileUtils.readFileToByteArray(f);
                byte_vector buffer = Vectors.bytes2byte_vector(data);
                int ret = bdecode_node.bdecode(buffer, n = new bdecode_node(), ec = new error_code());
                if (ret == 0) {
                    String stateVersion = n.dict_find_string_value_s(STATE_VERSION_KEY);
                    if (!STATE_VERSION_VALUE.equals(stateVersion)) {
                        return this.defaultParams();
                    }
                    session_params params = libtorrent.read_session_params(n);
                    buffer.clear();
                    return new SessionParams(params);
                }
                LOG.error("Can't decode session state data: " + ec.message());
                return this.defaultParams();
            }
            return this.defaultParams();
        }
        catch (Throwable e) {
            LOG.error("Error loading session state", e);
            return this.defaultParams();
        }
    }

    private SessionParams defaultParams() {
        SettingsPack sp = BTEngine.defaultSettings();
        return new SessionParams(sp);
    }

    @Override
    protected void onApplySettings(SettingsPack sp) {
        this.saveSettings();
    }

    @Override
    public byte[] saveState() {
        if (this.swig() == null) {
            return null;
        }
        entry e = new entry();
        this.swig().save_state(e);
        e.set(STATE_VERSION_KEY, STATE_VERSION_VALUE);
        return Vectors.byte_vector2bytes(e.bencode());
    }

    private void saveSettings() {
        if (this.swig() == null) {
            return;
        }
        try {
            byte[] data = this.saveState();
            FileUtils.writeByteArrayToFile(this.settingsFile(), data);
        }
        catch (Throwable e) {
            LOG.error("Error saving session state", e);
        }
    }

    public void revertToDefaultConfiguration() {
        if (this.swig() == null) {
            return;
        }
        SettingsPack sp = BTEngine.defaultSettings();
        this.applySettings(sp);
    }

    public void download(File torrent, File saveDir, boolean[] selection) {
        boolean exists;
        if (this.swig() == null) {
            return;
        }
        if ((saveDir = this.setupSaveDir(saveDir)) == null) {
            return;
        }
        TorrentInfo ti = new TorrentInfo(torrent);
        if (selection == null) {
            selection = new boolean[ti.numFiles()];
            Arrays.fill(selection, true);
        }
        Priority[] priorities = null;
        TorrentHandle th = this.find(ti.infoHash());
        boolean bl = exists = th != null;
        if (selection != null) {
            priorities = th != null ? th.filePriorities() : Priority.array(Priority.IGNORE, ti.numFiles());
            boolean changed = false;
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i] || priorities[i] != Priority.IGNORE) continue;
                priorities[i] = Priority.NORMAL;
                changed = true;
            }
            if (!changed) {
                return;
            }
        }
        this.download(ti, saveDir, priorities, null, null);
        if (!exists) {
            this.saveResumeTorrent(ti);
        }
    }

    public void download(TorrentInfo ti, File saveDir, boolean[] selection, List<TcpEndpoint> peers) {
        this.download(ti, saveDir, selection, peers, false);
    }

    public void download(TorrentInfo ti, File saveDir, boolean[] selection, List<TcpEndpoint> peers, boolean dontSaveTorrentFile) {
        boolean torrentHandleExists;
        if (this.swig() == null) {
            return;
        }
        if ((saveDir = this.setupSaveDir(saveDir)) == null) {
            return;
        }
        if (selection == null) {
            selection = new boolean[ti.numFiles()];
            Arrays.fill(selection, true);
        }
        Priority[] priorities = null;
        TorrentHandle th = this.find(ti.infoHash());
        boolean bl = torrentHandleExists = th != null;
        if (torrentHandleExists) {
            try {
                priorities = th.filePriorities();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        } else {
            priorities = Priority.array(Priority.IGNORE, ti.numFiles());
        }
        if (priorities != null) {
            boolean changed = false;
            for (int i = 0; i < selection.length; ++i) {
                if (!selection[i] || i >= priorities.length || priorities[i] != Priority.IGNORE) continue;
                priorities[i] = Priority.NORMAL;
                changed = true;
            }
            if (!changed) {
                return;
            }
        }
        this.download(ti, saveDir, priorities, null, peers);
        if (!torrentHandleExists) {
            this.saveResumeTorrent(ti);
            if (!dontSaveTorrentFile) {
                this.saveTorrent(ti);
            }
        }
    }

    public void download(TorrentCrawledSearchResult sr, File saveDir) {
        this.download(sr, saveDir, false);
    }

    public void download(TorrentCrawledSearchResult sr, File saveDir, boolean dontSaveTorrentFile) {
        boolean exists;
        if (this.swig() == null) {
            return;
        }
        if ((saveDir = this.setupSaveDir(saveDir)) == null) {
            return;
        }
        TorrentInfo ti = sr.getTorrentInfo();
        int fileIndex = sr.getFileIndex();
        TorrentHandle th = this.find(ti.infoHash());
        boolean bl = exists = th != null;
        if (th != null) {
            Priority[] priorities = th.filePriorities();
            if (priorities[fileIndex] == Priority.IGNORE) {
                priorities[fileIndex] = Priority.NORMAL;
                this.download(ti, saveDir, priorities, null, null);
            }
        } else {
            Priority[] priorities = Priority.array(Priority.IGNORE, ti.numFiles());
            priorities[fileIndex] = Priority.NORMAL;
            this.download(ti, saveDir, priorities, null, null);
        }
        if (!exists) {
            this.saveResumeTorrent(ti);
            if (!dontSaveTorrentFile) {
                this.saveTorrent(ti);
            }
        }
    }

    public void restoreDownloads() {
        if (this.swig() == null) {
            return;
        }
        if (BTEngine.ctx.homeDir == null || !BTEngine.ctx.homeDir.exists()) {
            LOG.warn("Wrong setup with BTEngine home dir");
            return;
        }
        File[] torrents = BTEngine.ctx.homeDir.listFiles((dir, name) -> name != null && FilenameUtils.getExtension(name).toLowerCase().equals("torrent"));
        if (torrents != null) {
            for (File t : torrents) {
                try {
                    String infoHash = FilenameUtils.getBaseName(t.getName());
                    if (infoHash == null) continue;
                    File resumeFile = this.resumeDataFile(infoHash);
                    File savePath = this.readSavePath(infoHash);
                    if (this.setupSaveDir(savePath) == null) {
                        LOG.warn("Can't create data dir or mount point is not accessible");
                        return;
                    }
                    this.restoreDownloadsQueue.add(new RestoreDownloadTask(t, null, null, resumeFile));
                }
                catch (Throwable e) {
                    LOG.error("Error restoring torrent download: " + t, e);
                }
            }
        }
        this.migrateVuzeDownloads();
        this.runNextRestoreDownloadTask();
    }

    File settingsFile() {
        return new File(BTEngine.ctx.homeDir, "settings.dat");
    }

    File resumeTorrentFile(String infoHash) {
        return new File(BTEngine.ctx.homeDir, infoHash + ".torrent");
    }

    File torrentFile(String name) {
        return new File(BTEngine.ctx.torrentsDir, name + ".torrent");
    }

    File resumeDataFile(String infoHash) {
        return new File(BTEngine.ctx.homeDir, infoHash + ".resume");
    }

    File readTorrentPath(String infoHash) {
        File torrent = null;
        try {
            byte[] arr = FileUtils.readFileToByteArray(this.resumeTorrentFile(infoHash));
            entry e = entry.bdecode(Vectors.bytes2byte_vector(arr));
            torrent = new File(e.dict().get(TORRENT_ORIG_PATH_KEY).string());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return torrent;
    }

    File readSavePath(String infoHash) {
        File savePath = null;
        try {
            byte[] arr = FileUtils.readFileToByteArray(this.resumeDataFile(infoHash));
            entry e = entry.bdecode(Vectors.bytes2byte_vector(arr));
            savePath = new File(e.dict().get("save_path").string());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return savePath;
    }

    private void saveTorrent(TorrentInfo ti) {
        try {
            String name = this.getEscapedFilename(ti);
            File torrentFile = this.torrentFile(name);
            byte[] arr = ti.toEntry().bencode();
            FileSystem fs = Platforms.get().fileSystem();
            fs.write(torrentFile, arr);
            fs.scan(torrentFile);
        }
        catch (Throwable e) {
            LOG.warn("Error saving torrent info to file", e);
        }
    }

    private void saveResumeTorrent(TorrentInfo ti) {
        try {
            String name = this.getEscapedFilename(ti);
            entry e = ti.toEntry().swig();
            e.dict().set(TORRENT_ORIG_PATH_KEY, new entry(this.torrentFile(name).getAbsolutePath()));
            byte[] arr = Vectors.byte_vector2bytes(e.bencode());
            FileUtils.writeByteArrayToFile(this.resumeTorrentFile(ti.infoHash().toString()), arr);
        }
        catch (Throwable e) {
            LOG.warn("Error saving resume torrent", e);
        }
    }

    private String getEscapedFilename(TorrentInfo ti) {
        String name = ti.name();
        if (name == null || name.length() == 0) {
            name = ti.infoHash().toString();
        }
        return BTEngine.escapeFilename(name);
    }

    private void fireStarted() {
        if (this.listener != null) {
            this.listener.started(this);
        }
    }

    private void fireStopped() {
        if (this.listener != null) {
            this.listener.stopped(this);
        }
    }

    private void fireDownloadAdded(TorrentAlert<?> alert2) {
        try {
            TorrentHandle th = this.find(alert2.handle().infoHash());
            if (th != null) {
                BTDownload dl = new BTDownload(this, th);
                if (this.listener != null) {
                    this.listener.downloadAdded(this, dl);
                }
            } else {
                LOG.info("torrent was not successfully added");
            }
        }
        catch (Throwable e) {
            LOG.error("Unable to create and/or notify the new download", e);
        }
    }

    private void fireDownloadUpdate(TorrentHandle th) {
        try {
            BTDownload dl = new BTDownload(this, th);
            if (this.listener != null) {
                this.listener.downloadUpdate(this, dl);
            }
        }
        catch (Throwable e) {
            LOG.error("Unable to notify update the a download", e);
        }
    }

    private void onListenSucceeded(ListenSucceededAlert alert2) {
        try {
            String endp = alert2.address() + ":" + alert2.port();
            String s = "endpoint: " + endp + " type:" + (Object)((Object)alert2.socketType());
            LOG.info("Listen succeeded on " + s);
        }
        catch (Throwable e) {
            LOG.error("Error adding listen endpoint to internal list", e);
        }
    }

    private void onListenFailed(ListenFailedAlert alert2) {
        String endp = alert2.address() + ":" + alert2.port();
        String s = "endpoint: " + endp + " type:" + (Object)((Object)alert2.socketType());
        String message = alert2.error().message();
        LOG.info("Listen failed on " + s + " (error: " + message + ")");
    }

    private void migrateVuzeDownloads() {
        try {
            File dir = new File(BTEngine.ctx.homeDir.getParent(), "azureus");
            File file = new File(dir, "downloads.config");
            if (file.exists()) {
                Entry configEntry = Entry.bdecode(file);
                List<Entry> downloads = configEntry.dictionary().get("downloads").list();
                for (Entry d : downloads) {
                    try {
                        Map<String, Entry> map = d.dictionary();
                        File saveDir = new File(map.get("save_dir").string());
                        File torrent = new File(map.get("torrent").string());
                        List<Entry> filePriorities = map.get("file_priorities").list();
                        Priority[] priorities = Priority.array(Priority.IGNORE, filePriorities.size());
                        for (int i = 0; i < filePriorities.size(); ++i) {
                            long p = filePriorities.get(i).integer();
                            if (p == 0L) continue;
                            priorities[i] = Priority.NORMAL;
                        }
                        if (!torrent.exists() || !saveDir.exists()) continue;
                        LOG.info("Restored old vuze download: " + torrent);
                        this.restoreDownloadsQueue.add(new RestoreDownloadTask(torrent, saveDir, priorities, null));
                        this.saveResumeTorrent(new TorrentInfo(torrent));
                    }
                    catch (Throwable e) {
                        LOG.error("Error restoring vuze torrent download", e);
                    }
                }
                file.delete();
            }
        }
        catch (Throwable e) {
            LOG.error("Error migrating old vuze downloads", e);
        }
    }

    private File setupSaveDir(File saveDir) {
        File result = null;
        if (saveDir == null) {
            if (BTEngine.ctx.dataDir != null) {
                result = BTEngine.ctx.dataDir;
            } else {
                LOG.warn("Unable to setup save dir path, review your logic, both saveDir and ctx.dataDir are null.");
            }
        } else {
            result = saveDir;
        }
        FileSystem fs = Platforms.get().fileSystem();
        if (result != null && !fs.isDirectory(result) && !fs.mkdirs(result)) {
            result = null;
            LOG.warn("Failed to create save dir to download");
        }
        if (result != null && !fs.canWrite(result)) {
            result = null;
            LOG.warn("Failed to setup save dir with write access");
        }
        return result;
    }

    private void runNextRestoreDownloadTask() {
        RestoreDownloadTask task = null;
        try {
            if (!this.restoreDownloadsQueue.isEmpty()) {
                task = this.restoreDownloadsQueue.poll();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (task != null) {
            task.run();
        }
    }

    private void download(TorrentInfo ti, File saveDir, Priority[] priorities, File resumeFile, List<TcpEndpoint> peers) {
        TorrentHandle th = this.find(ti.infoHash());
        if (th != null) {
            if (priorities != null) {
                if (ti.numFiles() != priorities.length) {
                    throw new IllegalArgumentException("The priorities length should be equals to the number of files");
                }
                th.prioritizeFiles(priorities);
                this.fireDownloadUpdate(th);
                th.resume();
            } else {
                Priority[] wholeTorrentPriorities = Priority.array(Priority.NORMAL, ti.numFiles());
                th.prioritizeFiles(wholeTorrentPriorities);
                this.fireDownloadUpdate(th);
                th.resume();
            }
        } else {
            this.download(ti, saveDir, resumeFile, priorities, peers);
            th = this.find(ti.infoHash());
            if (th != null) {
                this.fireDownloadUpdate(th);
            }
        }
    }

    private static String escapeFilename(String s) {
        return s.replaceAll("[\\\\/:*?\"<>|\\[\\]]+", "_");
    }

    private void onExternalIpAlert(ExternalIpAlert alert2) {
        try {
            String address2 = alert2.externalAddress().toString();
            LOG.info("External IP: " + address2);
        }
        catch (Throwable e) {
            LOG.error("Error saving reported external ip", e);
        }
    }

    private void onFastresumeRejected(FastresumeRejectedAlert alert2) {
        try {
            LOG.warn("Failed to load fastresume data, path: " + alert2.filePath() + ", operation: " + (Object)((Object)alert2.operation()) + ", error: " + alert2.error().message());
        }
        catch (Throwable e) {
            LOG.error("Error logging fastresume rejected alert", e);
        }
    }

    private void onDhtBootstrap() {
    }

    private void printAlert(Alert alert2) {
        System.out.println("Log: " + alert2);
    }

    private static String dhtBootstrapNodes() {
        StringBuilder sb = new StringBuilder();
        sb.append("dht.libtorrent.org:25401").append(",");
        sb.append("router.bittorrent.com:6881").append(",");
        sb.append("dht.transmissionbt.com:6881").append(",");
        sb.append("router.silotis.us:6881");
        return sb.toString();
    }

    private static SettingsPack defaultSettings() {
        SettingsPack sp = new SettingsPack();
        sp.broadcastLSD(true);
        if (BTEngine.ctx.optimizeMemory) {
            int maxQueuedDiskBytes = sp.maxQueuedDiskBytes();
            sp.maxQueuedDiskBytes(maxQueuedDiskBytes / 2);
            int sendBufferWatermark = sp.sendBufferWatermark();
            sp.sendBufferWatermark(sendBufferWatermark / 2);
            sp.cacheSize(256);
            sp.activeDownloads(4);
            sp.activeSeeds(4);
            sp.maxPeerlistSize(200);
            sp.tickInterval(1000);
            sp.inactivityTimeout(60);
            sp.seedingOutgoingConnections(false);
            sp.connectionsLimit(200);
        } else {
            sp.activeDownloads(10);
            sp.activeSeeds(10);
        }
        return sp;
    }

    static {
        ctxSetupLatch = new CountDownLatch(1);
    }

    private final class RestoreDownloadTask
    implements Runnable {
        private final File torrent;
        private final File saveDir;
        private final Priority[] priorities;
        private final File resume;

        public RestoreDownloadTask(File torrent, File saveDir, Priority[] priorities, File resume) {
            this.torrent = torrent;
            this.saveDir = saveDir;
            this.priorities = priorities;
            this.resume = resume;
        }

        @Override
        public void run() {
            try {
                BTEngine.this.download(new TorrentInfo(this.torrent), this.saveDir, this.resume, this.priorities, null);
            }
            catch (Throwable e) {
                LOG.error("Unable to restore download from previous session. (" + this.torrent.getAbsolutePath() + ")", e);
            }
        }
    }

    private final class InnerListener
    implements AlertListener {
        private InnerListener() {
        }

        @Override
        public int[] types() {
            return INNER_LISTENER_TYPES;
        }

        @Override
        public void alert(Alert<?> alert2) {
            AlertType type = alert2.type();
            switch (type) {
                case ADD_TORRENT: {
                    TorrentAlert torrentAlert = (TorrentAlert)alert2;
                    BTEngine.this.fireDownloadAdded(torrentAlert);
                    BTEngine.this.runNextRestoreDownloadTask();
                    break;
                }
                case LISTEN_SUCCEEDED: {
                    BTEngine.this.onListenSucceeded((ListenSucceededAlert)alert2);
                    break;
                }
                case LISTEN_FAILED: {
                    BTEngine.this.onListenFailed((ListenFailedAlert)alert2);
                    break;
                }
                case EXTERNAL_IP: {
                    BTEngine.this.onExternalIpAlert((ExternalIpAlert)alert2);
                    break;
                }
                case FASTRESUME_REJECTED: {
                    BTEngine.this.onFastresumeRejected((FastresumeRejectedAlert)alert2);
                    break;
                }
                case DHT_BOOTSTRAP: {
                    BTEngine.this.onDhtBootstrap();
                    break;
                }
                case TORRENT_LOG: 
                case PEER_LOG: 
                case LOG: {
                    BTEngine.this.printAlert(alert2);
                }
            }
        }
    }

    private static class Loader {
        static final BTEngine INSTANCE = new BTEngine();

        private Loader() {
        }
    }
}

