/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria.db;

import com.frostwire.alexandria.db.LibraryDatabase;
import java.io.File;
import java.io.PrintWriter;
import java.util.List;

public class DumpDatabase {
    private static final String TABLE_SEPARATOR = "------------------------------------------------------------------------------";
    private final LibraryDatabase db;
    private final File file;

    public DumpDatabase(LibraryDatabase db, File file) {
        this.db = db;
        this.file = file;
    }

    public void dump() {
        try (PrintWriter out = null;){
            out = new PrintWriter(this.file);
            this.dumpPlaylists(out);
            this.dumpPlaylistItems(out);
        }
    }

    private void dumpTable(PrintWriter out, String columns, String table) {
        List<List<Object>> rows = this.db.query("SELECT " + columns + " FROM " + table, new Object[0]);
        out.println(columns);
        this.dumpRows(out, rows);
        out.println(TABLE_SEPARATOR);
    }

    private void dumpRows(PrintWriter out, List<List<Object>> rows) {
        for (List<Object> row : rows) {
            this.dumpRow(out, row);
        }
    }

    private void dumpRow(PrintWriter out, List<Object> row) {
        int lastIndex = row.size() - 1;
        for (int i = 0; i < lastIndex; ++i) {
            out.print(row.get(i));
            out.print(", ");
        }
        out.print(row.get(lastIndex));
        out.println();
    }

    private void dumpPlaylists(PrintWriter out) {
        String columns = "playlistId, name, description";
        this.dumpTable(out, columns, "Playlists");
    }

    private void dumpPlaylistItems(PrintWriter out) {
        String columns = "playlistItemId, filePath, fileName, fileSize, fileExtension, trackTitle, duration, artistName, albumName, coverArtPath, bitrate, comment, genre, track, year";
        this.dumpTable(out, columns, "PlaylistItems");
    }
}

