/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

import com.frostwire.alexandria.Playlist;
import com.frostwire.alexandria.db.LibraryDatabaseEntity;
import com.frostwire.alexandria.db.PlaylistItemDB;
import com.frostwire.util.StringUtils;

public class PlaylistItem
extends LibraryDatabaseEntity {
    private Playlist playlist;
    private int id;
    private String filePath;
    private String fileName;
    private long fileSize;
    private String fileExtension;
    private String trackTitle;
    private float trackDurationInSecs;
    private String trackArtist;
    private String trackAlbum;
    private String coverArtPath;
    private String trackBitrate;
    private String trackComment;
    private String trackGenre;
    private String trackNumber;
    private String trackYear;
    private boolean starred;
    private int sortIndex;

    public PlaylistItem(Playlist playlist) {
        super(playlist != null ? playlist.getLibraryDatabase() : null);
        this.playlist = playlist;
        this.id = -2;
    }

    public PlaylistItem(Playlist playlist, int id, String filePath, String fileName, long fileSize, String fileExtension, String trackTitle, float trackDurationInSecs, String trackArtist, String trackAlbum, String coverArtPath, String trackBitrate, String trackComment, String trackGenre, String trackNumber, String trackYear, boolean starred) {
        super(playlist != null ? playlist.getLibraryDatabase() : null);
        this.playlist = playlist;
        this.id = id;
        this.filePath = filePath;
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.fileExtension = fileExtension;
        this.trackTitle = trackTitle;
        this.trackDurationInSecs = trackDurationInSecs;
        this.trackArtist = trackArtist;
        this.trackAlbum = trackAlbum;
        this.coverArtPath = coverArtPath;
        this.trackBitrate = trackBitrate;
        this.trackComment = trackComment;
        this.trackGenre = trackGenre;
        this.trackNumber = trackNumber;
        this.trackYear = trackYear;
        this.starred = starred;
        this.sortIndex = playlist != null ? playlist.getItems().size() + 1 : 0;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
        this.setLibraryDatabase(playlist.getLibraryDatabase());
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getTrackTitle() {
        return this.trackTitle;
    }

    public void setTrackTitle(String trackTitle) {
        this.trackTitle = trackTitle;
    }

    public float getTrackDurationInSecs() {
        return this.trackDurationInSecs;
    }

    public void setTrackDurationInSecs(float trackDurationInSecs) {
        this.trackDurationInSecs = trackDurationInSecs;
    }

    public String getTrackArtist() {
        return this.trackArtist;
    }

    public void setTrackArtist(String artistName) {
        this.trackArtist = artistName;
    }

    public String getTrackAlbum() {
        return this.trackAlbum;
    }

    public void setTrackAlbum(String albumName) {
        this.trackAlbum = albumName;
    }

    public String getCoverArtPath() {
        return this.coverArtPath;
    }

    public void setCoverArtPath(String coverArtPath) {
        this.coverArtPath = coverArtPath;
    }

    public String getTrackBitrate() {
        return this.trackBitrate;
    }

    public void setTrackBitrate(String bitrate) {
        this.trackBitrate = bitrate;
    }

    public String getTrackComment() {
        return this.trackComment;
    }

    public void setTrackComment(String comment) {
        this.trackComment = comment;
    }

    public String getTrackGenre() {
        return this.trackGenre;
    }

    public void setTrackGenre(String genre) {
        this.trackGenre = genre;
    }

    public String getTrackNumber() {
        return this.trackNumber;
    }

    public void setTrackNumber(String trackNum) {
        if ("null".equals(trackNum)) {
            trackNum = "-1";
        }
        this.trackNumber = trackNum;
    }

    public String getTrackYear() {
        return this.trackYear;
    }

    public void setTrackYear(String year) {
        this.trackYear = year;
    }

    public boolean isStarred() {
        return this.starred;
    }

    public void setStarred(boolean starred) {
        this.starred = starred;
    }

    public void save() {
        this.save(false);
    }

    public void save(boolean updateStarred) {
        if (this.db != null) {
            PlaylistItemDB.save(this.db, this, updateStarred);
        }
    }

    public void delete() {
        if (this.db != null) {
            PlaylistItemDB.delete(this.db, this);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof PlaylistItem && this.id == ((PlaylistItem)obj).id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return "(" + this.id + ", title:" + this.trackTitle + ", number:" + this.trackNumber + ")";
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    private void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void setSortIndexByTrackNumber(int fallBackIndexValue) {
        int sortIndex = fallBackIndexValue;
        try {
            if (!StringUtils.isNullOrEmpty(this.getTrackNumber())) {
                sortIndex = Integer.parseInt(this.getTrackNumber().trim());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.setSortIndex(sortIndex);
    }
}

