/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.alexandria;

public final class LibraryUtils {
    private LibraryUtils() {
    }

    public static String luceneEncode(String s) {
        int length = s.length();
        s = s.replace("AND", " ").replace("OR", " ").replace("NOT", " ");
        StringBuilder buff = new StringBuilder(2 * length);
        for (int i = 0; i < length; ++i) {
            try {
                char c = s.charAt(i);
                switch (c) {
                    case '+': {
                        buff.append("\\+");
                        break;
                    }
                    case '-': {
                        buff.append("\\-");
                        break;
                    }
                    case '&': {
                        buff.append("\\&");
                        break;
                    }
                    case '|': {
                        buff.append("\\r");
                        break;
                    }
                    case '!': {
                        buff.append("\\!");
                        break;
                    }
                    case '(': {
                        buff.append("\\(");
                        break;
                    }
                    case ')': {
                        buff.append("\\)");
                        break;
                    }
                    case '{': {
                        buff.append("\\{");
                        break;
                    }
                    case '}': {
                        buff.append("\\}");
                        break;
                    }
                    case '[': {
                        buff.append("\\[");
                        break;
                    }
                    case ']': {
                        buff.append("\\]");
                        break;
                    }
                    case '^': {
                        buff.append("\\^");
                        break;
                    }
                    case '\"': {
                        buff.append("\\\"");
                        break;
                    }
                    case '~': {
                        buff.append("\\~");
                        break;
                    }
                    case '*': {
                        buff.append("\\*");
                        break;
                    }
                    case '?': {
                        buff.append("\\?");
                        break;
                    }
                    case ':': {
                        buff.append("\\:");
                        break;
                    }
                    case '\\': {
                        buff.append("\\\\");
                        break;
                    }
                    default: {
                        buff.append(c);
                        break;
                    }
                }
                continue;
            }
            catch (Throwable e) {
                break;
            }
        }
        return buff.toString().replaceAll("\\s+", " ");
    }

    public static String fuzzyLuceneQuery(String str) {
        String luceneStr = LibraryUtils.luceneEncode(str);
        String[] tokens = luceneStr.split(" ");
        if (tokens.length == 0) {
            return luceneStr;
        }
        if (tokens.length == 1) {
            return luceneStr + "~";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            sb.append(tokens[i]).append("~ AND ");
        }
        sb.append(tokens[tokens.length - 1]).append("~");
        return sb.toString().trim();
    }

    public static String wildcardLuceneQuery(String str) {
        String luceneStr = LibraryUtils.luceneEncode(str);
        String[] tokens = luceneStr.split(" ");
        if (tokens.length == 0) {
            return luceneStr;
        }
        if (tokens.length == 1) {
            return luceneStr + "*";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.length - 1; ++i) {
            sb.append(tokens[i]).append("* AND ");
        }
        sb.append(tokens[tokens.length - 1]).append("*");
        return sb.toString().trim();
    }
}

