/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
!function(){"use strict";const t=require("electron").ipcRenderer,e=function(){let t=!1;return()=>{t||(t=!0,require("electron").webFrame.registerURLSchemeAsPrivileged("vscode-resource",{secure:!0,bypassCSP:!1,allowServiceWorkers:!1,supportFetchAPI:!0,corsEnabled:!0}))}}();var n,o=!0,r=[],s=!1;let a=!1;const i={initialScrollProgress:void 0},c=t=>{t&&(t.classList.remove("vscode-light","vscode-dark","vscode-high-contrast"),t.classList.add(i.activeTheme))},d=()=>document.getElementById("active-frame"),l=()=>document.getElementById("pending-frame");var u=!1;document.addEventListener("DOMContentLoaded",()=>{t.on("baseUrl",(t,e)=>{i.baseUrl=e}),t.on("styles",(t,e,n)=>{i.styles=e,i.activeTheme=n;var o=d();if(o){var r=o.contentDocument.getElementsByTagName("body");c(r[0]),Object.keys(e).forEach(t=>{o.contentDocument.documentElement.style.setProperty(`--${t}`,e[t])})}}),t.on("focus",()=>{const t=d();t&&t.contentWindow.focus()}),t.on("content",(m,g)=>{const h=g.options;(s=h&&h.enableWrappedPostMessage)&&e()
;const v=g.contents,f=(new DOMParser).parseFromString(v,"text/html");if(f.querySelectorAll("a").forEach(t=>{t.title||(t.title=t.href)}),i.baseUrl&&0===f.head.getElementsByTagName("base").length){const t=f.createElement("base");t.href=i.baseUrl,f.head.appendChild(t)}if(s&&h.allowScripts){const t=f.createElement("script")
;t.textContent=`\n\t\t\t\t\tconst acquireVsCodeApi = (function() {\n\t\t\t\t\t\tconst originalPostMessage = window.parent.postMessage.bind(window.parent);\n\t\t\t\t\t\tlet acquired = false;\n\n\t\t\t\t\t\tlet state = ${g.state?`JSON.parse(${JSON.stringify(g.state)})`:void 0};\n\n\t\t\t\t\t\treturn () => {\n\t\t\t\t\t\t\tif (acquired) {\n\t\t\t\t\t\t\t\tthrow new Error('An instance of the VS Code API has already been acquired');\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\tacquired = true;\n\t\t\t\t\t\t\treturn Object.freeze({\n\t\t\t\t\t\t\t\tpostMessage: function(msg) {\n\t\t\t\t\t\t\t\t\treturn originalPostMessage({ command: 'onmessage', data: msg }, '*');\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\tsetState: function(newState) {\n\t\t\t\t\t\t\t\t\tstate = newState;\n\t\t\t\t\t\t\t\t\toriginalPostMessage({ command: 'do-update-state', data: JSON.stringify(newState) }, '*');\n\t\t\t\t\t\t\t\t\treturn newState;\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\tgetState: function() {\n\t\t\t\t\t\t\t\t\treturn state;\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t});\n\t\t\t\t\t\t};\n\t\t\t\t\t})();\n\t\t\t\t\tdelete window.parent;\n\t\t\t\t\tdelete window.top;\n\t\t\t\t\tdelete window.frameElement;\n\t\t\t\t`,
f.head.hasChildNodes()?f.head.insertBefore(t,f.head.firstChild):f.head.appendChild(t)}const b=f.createElement("style");b.id="_defaultStyles";const w=Object.keys(i.styles||{}).map(t=>`--${t}: ${i.styles[t].replace(/[^\#\"\'\,\. a-z0-9\-\(\)]/gi,"")};`)
;b.innerHTML=`\n\t\t\t:root { ${w.join("\n")} }\n\n\t\t\tbody {\n\t\t\t\tbackground-color: var(--vscode-editor-background);\n\t\t\t\tcolor: var(--vscode-editor-foreground);\n\t\t\t\tfont-family: var(--vscode-editor-font-family);\n\t\t\t\tfont-weight: var(--vscode-editor-font-weight);\n\t\t\t\tfont-size: var(--vscode-editor-font-size);\n\t\t\t\tmargin: 0;\n\t\t\t\tpadding: 0 20px;\n\t\t\t}\n\n\t\t\timg {\n\t\t\t\tmax-width: 100%;\n\t\t\t\tmax-height: 100%;\n\t\t\t}\n\n\t\t\ta {\n\t\t\t\tcolor: var(--vscode-textLink-foreground);\n\t\t\t}\n\n\t\t\ta:hover {\n\t\t\t\tcolor: var(--vscode-textLink-activeForeground);\n\t\t\t}\n\n\t\t\ta:focus,\n\t\t\tinput:focus,\n\t\t\tselect:focus,\n\t\t\ttextarea:focus {\n\t\t\t\toutline: 1px solid -webkit-focus-ring-color;\n\t\t\t\toutline-offset: -1px;\n\t\t\t}\n\n\t\t\tcode {\n\t\t\t\tcolor: var(--vscode-textPreformat-foreground);\n\t\t\t}\n\n\t\t\tblockquote {\n\t\t\t\tbackground: var(--vscode-textBlockQuote-background);\n\t\t\t\tborder-color: var(--vscode-textBlockQuote-border);\n\t\t\t}\n\n\t\t\t::-webkit-scrollbar {\n\t\t\t\twidth: 10px;\n\t\t\t\theight: 10px;\n\t\t\t}\n\n\t\t\t::-webkit-scrollbar-thumb {\n\t\t\t\tbackground-color: var(--vscode-scrollbarSlider-background);\n\t\t\t}\n\t\t\t::-webkit-scrollbar-thumb:hover {\n\t\t\t\tbackground-color: var(--vscode-scrollbarSlider-hoverBackground);\n\t\t\t}\n\t\t\t::-webkit-scrollbar-thumb:active {\n\t\t\t\tbackground-color: var(--vscode-scrollbarSlider-activeBackground);\n\t\t\t}\n\t\t\t`,
f.head.hasChildNodes()?f.head.insertBefore(b,f.head.firstChild):f.head.appendChild(b),c(f.body);const p=d();var y;if(o)o=!1,y=((t,e)=>{isNaN(i.initialScrollProgress)||0===e.scrollY&&e.scroll(0,t.clientHeight*i.initialScrollProgress)});else{const t=p&&p.contentDocument&&p.contentDocument.body?p.contentWindow.scrollY:0;y=((e,n)=>{0===n.scrollY&&n.scroll(0,t)})}const k=l();k&&(k.setAttribute("id",""),document.body.removeChild(k)),r=[];const S=document.createElement("iframe");S.setAttribute("id","pending-frame"),S.setAttribute("frameborder","0"),S.setAttribute("sandbox",h.allowScripts?"allow-scripts allow-forms allow-same-origin":"allow-same-origin"),S.style.cssText="display: block; margin: 0; overflow: hidden; position: absolute; width: 100%; height: 100%; visibility: hidden",document.body.appendChild(S),S.contentDocument.open("text/html","replace"),S.contentWindow.onbeforeunload=(()=>a?(t.sendToHost("do-reload"),!1):(console.log("prevented webview navigation"),!1));var E=(e,n)=>{e.body&&y(e.body,n);const o=l()
;if(o&&o.contentDocument===e){const e=d();e&&document.body.removeChild(e),o.setAttribute("id","active-frame"),o.style.visibility="visible",o.contentWindow.focus(),n.addEventListener("scroll",e=>{if(u)return;const n=e.currentTarget.scrollY/e.target.body.clientHeight;isNaN(n)||(u=!0,window.requestAnimationFrame(()=>{try{t.sendToHost("did-scroll",n)}catch(t){}u=!1}))}),r.forEach(t=>{n.postMessage(t,"*")}),r=[]}};clearTimeout(n),n=void 0,n=setTimeout(()=>{clearTimeout(n),n=void 0,E(S.contentDocument,S.contentWindow)},200),S.contentWindow.addEventListener("load",function(t){n&&(clearTimeout(n),n=void 0,E(t.target,this))}),S.contentWindow.addEventListener("click",e=>{if(e&&e.view&&e.view.document)for(var n=e.view.document.getElementsByTagName("base")[0],o=e.target;o;){if(o.tagName&&"a"===o.tagName.toLowerCase()&&o.href){if("#"===o.getAttribute("href"))e.view.scrollTo(0,0);else if(o.hash&&(o.getAttribute("href")===o.hash||n&&o.href.indexOf(n.href)>=0)){
var r=e.view.document.getElementById(o.hash.substr(1,o.hash.length-1));r&&r.scrollIntoView()}else t.sendToHost("did-click-link",o.href);e.preventDefault();break}o=o.parentNode}}),S.contentDocument.write("<!DOCTYPE html>"),S.contentDocument.write(f.documentElement.innerHTML),S.contentDocument.close(),t.sendToHost("did-set-content")}),t.on("message",(t,e)=>{if(l())r.push(e);else{const t=d();t&&t.contentWindow.postMessage(e,"*")}}),t.on("initial-scroll-position",(t,e)=>{i.initialScrollProgress=e}),t.on("devtools-opened",()=>{a=!0}),window.onmessage=(e=>{t.sendToHost(e.data.command,e.data.data)}),t.sendToHost("webview-ready",process.pid)})}();
//# sourceMappingURL=https://ticino.blob.core.windows.net/sourcemaps/bc24f98b5f70467bc689abf41cc5550ca637088e/core/vs/workbench/parts/webview/electron-browser/webview-pre.js.map
