/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.libraries.ContributedLibraryReference;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import processing.app.I18n;
import processing.app.packages.UserLibrary;

public abstract class ContributedLibrary
extends DownloadableContribution {
    public static final Comparator<ContributedLibrary> CASE_INSENSITIVE_ORDER = (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    private Optional<UserLibrary> installedLib = Optional.empty();

    public abstract String getName();

    public abstract String getMaintainer();

    public abstract String getAuthor();

    public abstract String getWebsite();

    public abstract String getCategory();

    public abstract void setCategory(String var1);

    public abstract String getLicense();

    public abstract String getParagraph();

    public abstract String getSentence();

    public abstract List<String> getArchitectures();

    public abstract List<String> getTypes();

    public abstract List<ContributedLibraryReference> getRequires();

    public abstract List<String> getProvidesIncludes();

    public Optional<UserLibrary> getInstalledLibrary() {
        return this.installedLib;
    }

    public boolean isLibraryInstalled() {
        return this.installedLib.isPresent();
    }

    public void setInstalledUserLibrary(UserLibrary installed) {
        this.installedLib = Optional.of(installed);
    }

    public void unsetInstalledUserLibrary() {
        this.installedLib = Optional.empty();
    }

    public boolean isIDEBuiltIn() {
        if (!this.installedLib.isPresent()) {
            return false;
        }
        return this.installedLib.get().isIDEBuiltIn();
    }

    public boolean supportsArchitecture(String reqArch) {
        return this.getArchitectures().contains(reqArch) || this.getArchitectures().contains("*");
    }

    public boolean supportsArchitecture(List<String> reqArchs) {
        if (reqArchs.contains("*")) {
            return true;
        }
        for (String reqArch : reqArchs) {
            if (!this.supportsArchitecture(reqArch)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return I18n.format(I18n.tr("Version {0}"), this.getParsedVersion());
    }

    public String info() {
        String res = "";
        res = res + "  ContributedLibrary : " + this.getName() + "\n";
        res = res + "              author : " + this.getAuthor() + "\n";
        res = res + "          maintainer : " + this.getMaintainer() + "\n";
        res = res + "             version : " + this.getParsedVersion() + "\n";
        res = res + "             website : " + this.getUrl() + "\n";
        res = res + "            category : " + this.getCategory() + "\n";
        res = res + "             license : " + this.getLicense() + "\n";
        res = res + "             descrip : " + this.getSentence() + "\n";
        if (this.getParagraph() != null && !this.getParagraph().isEmpty()) {
            res = res + "                       " + this.getParagraph() + "\n";
        }
        res = res + "       architectures : ";
        if (this.getArchitectures() != null) {
            for (String a : this.getArchitectures()) {
                res = res + a + ",";
            }
        }
        res = res + "\n";
        res = res + "            requires :\n";
        if (this.getRequires() != null) {
            for (ContributedLibraryReference r : this.getRequires()) {
                res = res + "                       " + r;
            }
        }
        res = res + "\n";
        res = res + super.toString();
        return res;
    }

    public boolean equals(Object obj) {
        boolean versionEquals;
        if (!(obj instanceof ContributedLibrary)) {
            return false;
        }
        ContributedLibrary other = (ContributedLibrary)obj;
        String thisVersion = this.getParsedVersion();
        String otherVersion = other.getParsedVersion();
        boolean bl = versionEquals = thisVersion != null && otherVersion != null && thisVersion.equals(otherVersion);
        if (thisVersion == null && otherVersion == null) {
            versionEquals = true;
        }
        String thisName = this.getName();
        String otherName = other.getName();
        boolean nameEquals = thisName == null || otherName == null || thisName.equals(otherName);
        return versionEquals && nameEquals;
    }
}

