/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.util.Locale;
import java.util.TimeZone;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.Gregorian;
import sun.util.calendar.ImmutableGregorianDate;

public final class Era {
    private final String name;
    private final String abbr;
    private final long since;
    private final CalendarDate sinceDate;
    private final boolean localTime;
    private int hash = 0;

    public Era(String string, String string2, long l, boolean bl) {
        this.name = string;
        this.abbr = string2;
        this.since = l;
        this.localTime = bl;
        Gregorian gregorian = CalendarSystem.getGregorianCalendar();
        Gregorian.Date date = gregorian.newCalendarDate(null);
        gregorian.getCalendarDate(l, date);
        this.sinceDate = new ImmutableGregorianDate(date);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName(Locale locale) {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbr;
    }

    public String getDiaplayAbbreviation(Locale locale) {
        return this.abbr;
    }

    public long getSince(TimeZone timeZone) {
        if (timeZone == null || !this.localTime) {
            return this.since;
        }
        int n = timeZone.getOffset(this.since);
        return this.since - (long)n;
    }

    public CalendarDate getSinceDate() {
        return this.sinceDate;
    }

    public boolean isLocalTime() {
        return this.localTime;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Era)) {
            return false;
        }
        Era era = (Era)object;
        return this.name.equals(era.name) && this.abbr.equals(era.abbr) && this.since == era.since && this.localTime == era.localTime;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.name.hashCode() ^ this.abbr.hashCode() ^ (int)this.since ^ (int)(this.since >> 32) ^ (this.localTime ? 1 : 0);
        }
        return this.hash;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        stringBuilder.append(this.getName()).append(" (");
        stringBuilder.append(this.getAbbreviation()).append(')');
        stringBuilder.append(" since ").append(this.getSinceDate());
        if (this.localTime) {
            stringBuilder.setLength(stringBuilder.length() - 1);
            stringBuilder.append(" local time");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

