/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.crypto;

import java.security.GeneralSecurityException;
import sun.security.krb5.KrbCryptoException;
import sun.security.krb5.internal.crypto.ArcFourHmac;
import sun.security.krb5.internal.crypto.CksumType;

public class HmacMd5ArcFourCksumType
extends CksumType {
    @Override
    public int confounderSize() {
        return 8;
    }

    @Override
    public int cksumType() {
        return -138;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public int cksumSize() {
        return 16;
    }

    @Override
    public int keyType() {
        return 4;
    }

    @Override
    public int keySize() {
        return 16;
    }

    @Override
    public byte[] calculateChecksum(byte[] byArray, int n) {
        return null;
    }

    @Override
    public byte[] calculateKeyedChecksum(byte[] byArray, int n, byte[] byArray2, int n2) throws KrbCryptoException {
        try {
            return ArcFourHmac.calculateChecksum(byArray2, n2, byArray, 0, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }

    @Override
    public boolean verifyKeyedChecksum(byte[] byArray, int n, byte[] byArray2, byte[] byArray3, int n2) throws KrbCryptoException {
        try {
            byte[] byArray4 = ArcFourHmac.calculateChecksum(byArray2, n2, byArray, 0, n);
            return HmacMd5ArcFourCksumType.isChecksumEqual(byArray3, byArray4);
        }
        catch (GeneralSecurityException generalSecurityException) {
            KrbCryptoException krbCryptoException = new KrbCryptoException(generalSecurityException.getMessage());
            krbCryptoException.initCause(generalSecurityException);
            throw krbCryptoException;
        }
    }
}

