/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.IIOPHelper;
import java.io.IOException;
import java.rmi.Remote;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;

public class RMIIIOPServerImpl
extends RMIServerImpl {
    private final Map<String, ?> env;
    private final AccessControlContext callerACC;

    public RMIIIOPServerImpl(Map<String, ?> map) throws IOException {
        super(map);
        this.env = map == null ? Collections.emptyMap() : map;
        this.callerACC = AccessController.getContext();
    }

    @Override
    protected void export() throws IOException {
        IIOPHelper.exportObject(this);
    }

    @Override
    protected String getProtocol() {
        return "iiop";
    }

    @Override
    public Remote toStub() throws IOException {
        Remote remote = IIOPHelper.toStub(this);
        return remote;
    }

    @Override
    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        IIOPHelper.exportObject(rMIConnectionImpl);
        return rMIConnectionImpl;
    }

    @Override
    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        IIOPHelper.unexportObject(rMIConnection);
    }

    @Override
    protected void closeServer() throws IOException {
        IIOPHelper.unexportObject(this);
    }

    @Override
    RMIConnection doNewClient(final Object object) throws IOException {
        if (this.callerACC == null) {
            throw new SecurityException("AccessControlContext cannot be null");
        }
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<RMIConnection>(){

                @Override
                public RMIConnection run() throws IOException {
                    return RMIIIOPServerImpl.this.superDoNewClient(object);
                }
            }, this.callerACC);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    RMIConnection superDoNewClient(Object object) throws IOException {
        return super.doNewClient(object);
    }
}

