/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.packages.ContributedBoard;
import cc.arduino.contributions.packages.ContributedHelp;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ui.ContributedPlatformReleases;
import cc.arduino.contributions.ui.InstallerTableCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Theme;

public class ContributedPlatformTableCellJPanel
extends JPanel {
    final JButton installButton;
    final JButton removeButton;
    final Component removeButtonPlaceholder;
    final Component installButtonPlaceholder;
    final JComboBox downgradeChooser;
    final JComboBox versionToInstallChooser;
    final JButton downgradeButton;
    final JPanel buttonsPanel;
    final JPanel inactiveButtonsPanel;
    final JLabel statusLabel;

    public ContributedPlatformTableCellJPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.installButton = new JButton(I18n.tr((String)"Install"));
        int width = this.installButton.getPreferredSize().width;
        this.installButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.removeButton = new JButton(I18n.tr((String)"Remove"));
        width = this.removeButton.getPreferredSize().width;
        this.removeButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.downgradeButton = new JButton(I18n.tr((String)"Install"));
        this.downgradeChooser = new JComboBox();
        this.downgradeChooser.addItem("-");
        this.downgradeChooser.setMaximumSize(this.downgradeChooser.getPreferredSize());
        this.downgradeChooser.addItemListener(e -> {
            Object selectVersionItem = this.downgradeChooser.getItemAt(0);
            boolean disableDowngrade = e.getItem() == selectVersionItem;
            this.downgradeButton.setEnabled(!disableDowngrade);
            if (!disableDowngrade) {
                InstallerTableCell.dropdownSelected(true);
            }
        });
        this.versionToInstallChooser = new JComboBox();
        this.versionToInstallChooser.addItem("-");
        this.versionToInstallChooser.setMaximumSize(this.versionToInstallChooser.getPreferredSize());
        this.makeNewDescription();
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.add(Box.createHorizontalStrut(7));
        this.buttonsPanel.add(this.downgradeChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.downgradeButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.versionToInstallChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.removeButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(Box.createHorizontalStrut(15));
        this.add(this.buttonsPanel);
        this.inactiveButtonsPanel = new JPanel();
        this.inactiveButtonsPanel.setLayout(new BoxLayout(this.inactiveButtonsPanel, 0));
        this.inactiveButtonsPanel.setOpaque(false);
        int height = this.installButton.getMinimumSize().height;
        this.inactiveButtonsPanel.add(Box.createVerticalStrut(height));
        this.inactiveButtonsPanel.add(Box.createGlue());
        this.statusLabel = new JLabel(" ");
        this.inactiveButtonsPanel.add(this.statusLabel);
        this.inactiveButtonsPanel.add(Box.createHorizontalStrut(15));
        this.add(this.inactiveButtonsPanel);
        this.add(Box.createVerticalStrut(15));
    }

    void update(JTable parentTable, Object value, boolean isSelected, boolean hasBuiltInRelease) {
        String url;
        String author;
        boolean upgradable;
        boolean removable;
        boolean installable;
        ContributedPlatformReleases releases = (ContributedPlatformReleases)value;
        JTextPane description = this.makeNewDescription();
        if (releases == null) {
            return;
        }
        ContributedPlatform selected = releases.getSelected();
        ContributedPlatform installed = releases.getInstalled();
        if (installed == null) {
            installable = true;
            removable = false;
            upgradable = false;
        } else {
            installable = false;
            removable = !installed.isBuiltIn() && !hasBuiltInRelease;
            boolean bl = upgradable = new DownloadableContributionVersionComparator().compare((DownloadableContribution)selected, (DownloadableContribution)installed) > 0;
        }
        if (installable) {
            this.installButton.setText(I18n.tr((String)"Install"));
        }
        if (upgradable) {
            this.installButton.setText(I18n.tr((String)"Update"));
        }
        this.installButton.setVisible(installable || upgradable);
        this.installButtonPlaceholder.setVisible(!installable && !upgradable);
        this.removeButton.setVisible(removable);
        this.removeButtonPlaceholder.setVisible(!removable);
        String desc = "<html><body>";
        desc = desc + "<b>" + selected.getName() + "</b>";
        if (installed != null && installed.isBuiltIn()) {
            desc = desc + " Built-In ";
        }
        if ((author = selected.getParentPackage().getMaintainer()) != null && !author.isEmpty()) {
            desc = desc + " " + I18n.format((String)"by <b>{0}</b>", (Object[])new Object[]{author});
        }
        if (installed != null) {
            desc = desc + " " + I18n.format((String)I18n.tr((String)"version <b>{0}</b>"), (Object[])new Object[]{installed.getParsedVersion()}) + " <strong><font color=\"#00979D\">INSTALLED</font></strong>";
        }
        desc = desc + "<br />";
        desc = desc + I18n.tr((String)"Boards included in this package:") + "<br />";
        for (ContributedBoard board : selected.getBoards()) {
            desc = desc + board.getName() + ", ";
        }
        if (desc.lastIndexOf(44) != -1) {
            desc = desc.substring(0, desc.lastIndexOf(44)) + ".<br />";
        }
        ContributedHelp help = null;
        if (selected.getHelp() != null) {
            help = selected.getHelp();
        } else if (selected.getParentPackage().getHelp() != null) {
            help = selected.getParentPackage().getHelp();
        }
        if (help != null && (url = help.getOnline()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">Online help</a><br/>", (Object[])new Object[]{url});
        }
        if ((url = selected.getParentPackage().getWebsiteURL()) != null && !url.isEmpty()) {
            desc = desc + " " + I18n.format((String)"<a href=\"{0}\">More info</a>", (Object[])new Object[]{url});
        }
        desc = desc + "</body></html>";
        description.setText(desc);
        description.setBackground(Color.WHITE);
        int width = parentTable.getBounds().width;
        InstallerTableCell.setJTextPaneDimensionToFitContainedText(description, width);
        if (isSelected) {
            this.setBackground(parentTable.getSelectionBackground());
            this.setForeground(parentTable.getSelectionForeground());
        } else {
            this.setBackground(parentTable.getBackground());
            this.setForeground(parentTable.getForeground());
        }
    }

    private JTextPane makeNewDescription() {
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        JTextPane description = new JTextPane();
        description.setInheritsPopupMenu(true);
        Insets margin = description.getMargin();
        margin.bottom = 0;
        description.setMargin(margin);
        description.setContentType("text/html");
        Document doc = description.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet s = html.getStyleSheet();
            s.addRule("body { margin: 0; padding: 0;font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;font-size: " + 10 * Theme.getScale() / 100 + "; }");
        }
        description.setOpaque(false);
        description.setBorder(new EmptyBorder(4, 7, 7, 7));
        description.setHighlighter(null);
        description.setEditable(false);
        description.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Base.openURL(e.getDescription());
            }
        });
        this.add((Component)description, 0);
        return description;
    }

    public void setButtonsVisible(boolean enabled) {
        this.installButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.buttonsPanel.setVisible(enabled);
        this.inactiveButtonsPanel.setVisible(!enabled);
    }
}

